/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.engine;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.util.CollectionUtils;

public final class Term
implements Comparable<Term> {
    private final String name;
    private final Map<String, String> parameters;
    private static final TreeMapComparator<String, String> treeMapComparator = new TreeMapComparator();

    public Term(String name) {
        this(name, null);
    }

    public Term(String name, Map<String, String> parameters) {
        this.name = name;
        this.parameters = parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(new TreeMap<String, String>(parameters));
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.parameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(Term o) {
        if (o == null) {
            return 1;
        }
        if (this == o) {
            return 0;
        }
        return treeMapComparator.compare(this.parameters, o.parameters);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parameters != null) {
            for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
                sb.append(", ");
                sb.append(parameter.getKey());
                sb.append("=");
                sb.append(parameter.getValue());
            }
        }
        return this.getClass().getSimpleName() + "([" + this.name + "]" + sb.toString() + ")";
    }

    private static class TreeMapComparator<T extends Comparable, V extends Comparable>
    implements Comparator<Map<T, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private TreeMapComparator() {
        }

        @Override
        public int compare(Map<T, V> o1, Map<T, V> o2) {
            if (CollectionUtils.isEmpty(o1)) {
                if (CollectionUtils.isEmpty(o2)) {
                    return 0;
                }
                return -1;
            }
            if (CollectionUtils.isEmpty(o2)) {
                return 1;
            }
            Iterator<Map.Entry<T, V>> o1Iter = o1.entrySet().iterator();
            Iterator<Map.Entry<T, V>> o2Iter = o2.entrySet().iterator();
            while (o1Iter.hasNext() && o2Iter.hasNext()) {
                Map.Entry<T, V> o1Elem = o1Iter.next();
                Map.Entry<T, V> o2Elem = o2Iter.next();
                if (o1Elem == null) {
                    if (o2Elem == null) continue;
                    return -1;
                }
                Comparable o1ElemKey = (Comparable)o1Elem.getKey();
                Comparable o2ElemKey = (Comparable)o2Elem.getKey();
                if (o1ElemKey == null) {
                    if (o2ElemKey != null) {
                        return -1;
                    }
                } else {
                    int elemKeyCompare = o1ElemKey.compareTo(o2ElemKey);
                    if (elemKeyCompare != 0) {
                        return elemKeyCompare;
                    }
                }
                Comparable o1ElemValue = (Comparable)o1Elem.getValue();
                Comparable o2ElemValue = (Comparable)o2Elem.getValue();
                if (o1ElemValue == null) {
                    if (o2ElemValue == null) continue;
                    return -1;
                }
                int elemValueCompare = o1ElemValue.compareTo(o2ElemValue);
                if (elemValueCompare == 0) continue;
                return elemValueCompare;
            }
            if (o1Iter.hasNext()) {
                return 1;
            }
            if (o2Iter.hasNext()) {
                return -1;
            }
            return 0;
        }
    }
}

