/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.type;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.impl.KimAttributes;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceHelper;

public class KimTypeAttributesHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private KimType kimType;
    private transient KimTypeService kimTypeService;
    private List<? extends KimAttributes> attributes;
    private transient List<KimAttributeField> definitions;
    private transient Map<String, Object> attributeEntry;

    public KimTypeAttributesHelper(KimType kimType) {
        this.kimType = kimType;
    }

    public List<? extends KimAttributes> getAttributes() {
        return this.attributes;
    }

    public KimType getKimType() {
        return this.kimType;
    }

    public KimTypeService getKimTypeService(KimType kimType) {
        if (this.kimTypeService == null) {
            this.kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
        }
        return this.kimTypeService;
    }

    public Map<String, Object> getAttributeEntry() {
        if (this.attributeEntry == null || this.attributeEntry.isEmpty()) {
            this.attributeEntry = KIMServiceLocatorInternal.getUiDocumentService().getAttributeEntries(this.getDefinitions());
        }
        return this.attributeEntry;
    }

    public String getKimAttributeDefnId(KimAttributeField definition) {
        return definition.getId();
    }

    public List<KimAttributeField> getDefinitions() {
        KimTypeService kimTypeService;
        if ((this.definitions == null || this.definitions.isEmpty()) && (kimTypeService = this.getKimTypeService(this.getKimType())) != null) {
            this.definitions = kimTypeService.getAttributeDefinitions(this.getKimType().getId());
        }
        return this.definitions;
    }

    public String getCommaDelimitedAttributesLabels(String commaDelimitedAttributesNamesList) {
        String[] names = StringUtils.splitByWholeSeparator((String)commaDelimitedAttributesNamesList, (String)", ");
        StringBuffer commaDelimitedAttributesLabels = new StringBuffer();
        for (String name : names) {
            commaDelimitedAttributesLabels.append(this.getAttributeEntry().get(name.trim()) + ", ");
        }
        if (commaDelimitedAttributesLabels.toString().endsWith(", ")) {
            commaDelimitedAttributesLabels.delete(commaDelimitedAttributesLabels.length() - ", ".length(), commaDelimitedAttributesLabels.length());
        }
        return commaDelimitedAttributesLabels.toString();
    }

    public KimAttributeField getAttributeDefinition(String attributeName) {
        return DataDictionaryTypeServiceHelper.findAttributeField((String)attributeName, this.getDefinitions());
    }

    public String getAttributeValue(Map<String, String> aSet, String attributeName) {
        if (StringUtils.isEmpty((String)attributeName) || aSet == null) {
            return null;
        }
        for (String attributeNameKey : aSet.keySet()) {
            if (!attributeName.equals(attributeNameKey)) continue;
            return aSet.get(attributeNameKey);
        }
        return null;
    }
}

