/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.common.api.person.attr.CitizenshipTypeService;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="citizenshipTypeService")
public class CitizenshipTypeServiceImpl
implements CitizenshipTypeService {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    public CitizenshipType getPersonCitizenshipType(ProposalPersonContract proposalPerson) {
        if (proposalPerson == null) {
            throw new IllegalArgumentException("proposalPerson is null");
        }
        Boolean citizenshipTypeSourceInternal = this.isCitizenshipTypeSourceInternal();
        if (citizenshipTypeSourceInternal != null && !citizenshipTypeSourceInternal.booleanValue()) {
            return this.getCitizenshipDataFromExternalSource(proposalPerson);
        }
        Integer citizenshipTypeCode = null;
        Boolean allowOverride = this.isAllowCitizenshipTypeOverride();
        if (allowOverride.booleanValue() && proposalPerson.getCitizenshipType() != null) {
            citizenshipTypeCode = proposalPerson.getCitizenshipType().getCode();
        } else if (proposalPerson.getPerson() != null) {
            citizenshipTypeCode = proposalPerson.getPerson().getCitizenshipTypeCode();
        }
        if (citizenshipTypeCode != null) {
            return this.getCitizenshipTypeFromCode(String.valueOf(citizenshipTypeCode));
        }
        return CitizenshipType.NOT_AVAILABLE;
    }

    protected Boolean isAllowCitizenshipTypeOverride() {
        return this.parameterService.getParameterValueAsBoolean("KC-S2S", "All", "ALLOW_PROPOSAL_PERSON_TO_OVERRIDE_KC_PERSON_EXTENDED_ATTRIBUTES");
    }

    protected CitizenshipType getCitizenshipTypeFromCode(String citizenShipCode) {
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-S2S", "All", "NON_US_CITIZEN_WITH_TEMPORARY_VISA_TYPE_CODE"))) {
            return CitizenshipType.NON_US_CITIZEN_WITH_TEMPORARY_VISA;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-S2S", "All", "PERMANENT_RESIDENT_OF_US_TYPE_CODE"))) {
            return CitizenshipType.PERMANENT_RESIDENT_OF_US;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-S2S", "All", "US_CITIZEN_OR_NONCITIZEN_NATIONAL_TYPE_CODE"))) {
            return CitizenshipType.US_CITIZEN_OR_NONCITIZEN_NATIONAL;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-S2S", "All", "PERMANENT_RESIDENT_OF_US_PENDING"))) {
            return CitizenshipType.PERMANENT_RESIDENT_OF_US_PENDING;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-S2S", "All", "NOT_RESIDING_IN_US"))) {
            return CitizenshipType.NOT_RESIDING_IN_US;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-S2S", "All", "TEMP_VISA_ALSO_APPLIED_FOR_PERM_RESIDENT_STATUS"))) {
            return CitizenshipType.TEMP_VISA_ALSO_APPLIED_FOR_PERM_RESIDENT_STATUS;
        }
        return CitizenshipType.NOT_AVAILABLE;
    }

    protected Boolean isCitizenshipTypeSourceInternal() {
        return this.parameterService.getParameterValueAsBoolean("KC-S2S", "All", "PI_CITIZENSHIP_FROM_CUSTOM_DATA");
    }

    protected CitizenshipType getCitizenshipDataFromExternalSource(ProposalPersonContract proposalPerson) {
        throw new UnsupportedOperationException("External Source Must be configured when system parameter PI_CITIZENSHIP_FROM_CUSTOM_DATA is set to '0'");
    }

    private static class ConfigurationConstants {
        private static final String PI_CUSTOM_DATA = "PI_CITIZENSHIP_FROM_CUSTOM_DATA";
        private static final String PERMANENT_RESIDENT_OF_US_TYPE_CODE = "PERMANENT_RESIDENT_OF_US_TYPE_CODE";
        private static final String ALLOW_PROPOSAL_PERSON_TO_OVERRIDE_KC_PERSON_EXTENDED_ATTRIBUTES = "ALLOW_PROPOSAL_PERSON_TO_OVERRIDE_KC_PERSON_EXTENDED_ATTRIBUTES";
        private static final String NON_US_CITIZEN_WITH_TEMPORARY_VISA_TYPE_CODE = "NON_US_CITIZEN_WITH_TEMPORARY_VISA_TYPE_CODE";
        private static final String US_CITIZEN_OR_NONCITIZEN_NATIONAL_TYPE_CODE = "US_CITIZEN_OR_NONCITIZEN_NATIONAL_TYPE_CODE";
        private static final String PERMANENT_RESIDENT_OF_US_PENDING = "PERMANENT_RESIDENT_OF_US_PENDING";
        private static final String NOT_RESIDING_IN_US = "NOT_RESIDING_IN_US";
        private static final String TEMP_VISA_ALSO_APPLIED_FOR_PERM_RESIDENT_STATUS = "TEMP_VISA_ALSO_APPLIED_FOR_PERM_RESIDENT_STATUS";

        private ConfigurationConstants() {
        }
    }
}

