/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.coi.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Set;
import javax.validation.Validator;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.sys.framework.mq.Producer;
import org.kuali.coeus.sys.framework.mq.rest.HttpMethod;
import org.kuali.coeus.sys.framework.mq.rest.RestRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="projectPublisher")
public class ProjectPublisherImpl
implements ProjectPublisher {
    @Autowired
    @Qualifier(value="restMessageProducer")
    private Producer<RestRequest> restMessageProducer;
    @Autowired
    @Qualifier(value="beanValidator")
    private Validator validator;

    @Override
    public void publishProject(Project project) {
        Set violations = this.validator.validate((Object)project, new Class[0]);
        if (!violations.isEmpty()) {
            throw new IllegalArgumentException(violations.toString());
        }
        RestRequest request = new RestRequest();
        request.setDestination("coi.projects");
        request.setHeaders(Collections.singletonMap("Content-Type", Collections.singletonList("application/json")));
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            objectMapper.setDateFormat((DateFormat)format);
            request.setBody(objectMapper.writeValueAsString((Object)project));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        request.setMethod(HttpMethod.POST);
        this.restMessageProducer.sendMessage(request);
    }

    public Producer<RestRequest> getRestMessageProducer() {
        return this.restMessageProducer;
    }

    public void setRestMessageProducer(Producer<RestRequest> restMessageProducer) {
        this.restMessageProducer = restMessageProducer;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

