/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit.sync;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.sync.TargetRoleInfo;
import org.kuali.coeus.common.framework.unit.sync.UnitRole;
import org.kuali.coeus.common.framework.unit.sync.UnitRoleSync;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.util.GlobalVariables;

public class UnitRoleSyncMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String DESCENDS = "targetRoleInfos[%s].descends";
    private static final String ERROR_UNIT_ROLE_SYNC_DESCENDS = "error.unit.role.sync.descends";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isValidDescends(document);
    }

    public boolean isValidDescends(MaintenanceDocument document) {
        UnitRoleSync unitRoleSync = (UnitRoleSync)document.getNewMaintainableObject().getDataObject();
        if (unitRoleSync != null && unitRoleSync.getTargetRoleInfos() != null) {
            for (int i = 0; i < unitRoleSync.getTargetRoleInfos().size(); ++i) {
                TargetRoleInfo targetRoleInfo = unitRoleSync.getTargetRoleInfos().get(i);
                if (!targetRoleInfo.isDescends() || !StringUtils.isNotBlank((CharSequence)targetRoleInfo.getRoleId())) continue;
                if (targetRoleInfo.getRole() == null) {
                    UnitRole role = new UnitRole();
                    role.setId(targetRoleInfo.getRoleId());
                    targetRoleInfo.setRole(role);
                }
                targetRoleInfo.getRole().refresh();
                if (targetRoleInfo.getRole().isUnitHierarchy()) continue;
                GlobalVariables.getMessageMap().putError(String.format("document.newMaintainableObject.targetRoleInfos[%s].descends", i), ERROR_UNIT_ROLE_SYNC_DESCENDS, new String[]{targetRoleInfo.getRole().getNamespaceCode(), targetRoleInfo.getRole().getName()});
            }
        }
        return true;
    }
}

