/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudMapBasedRestController;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class PermissionController
extends SimpleCrudMapBasedRestController<PermissionBo> {
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;

    @Override
    protected void validateBusinessObject(PermissionBo dataObject) {
        if (dataObject.getTemplateId() != null) {
            dataObject.setTemplate(PermissionTemplateBo.from((Template)this.getPermissionService().getPermissionTemplate(dataObject.getTemplateId())));
        }
        super.validateBusinessObject(dataObject);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"api/v1/permissions/{permissionName}/namespace/{namespace}/principals/{memberId}"})
    @ResponseBody
    public Boolean hasPermission(@PathVariable String permissionName, @PathVariable String namespace, @PathVariable String memberId) {
        this.assertMethodSupported(RequestMethod.GET);
        if (StringUtils.isBlank((CharSequence)permissionName)) {
            throw new ResourceNotFoundException("permissionName is blank");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new ResourceNotFoundException("namespace is blank");
        }
        if (StringUtils.isBlank((CharSequence)memberId)) {
            throw new ResourceNotFoundException("memberId is blank");
        }
        return this.permissionService.hasPermission(memberId, namespace, permissionName);
    }
}

