/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.web.struts.action;

import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.attachment.AttachmentDocumentStatus;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAttachments;
import org.kuali.kra.subaward.bo.SubAwardReports;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.subaward.subawardrule.events.AddSubAwardAttachmentEvent;
import org.kuali.kra.subaward.web.struts.action.SubAwardAction;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class SubAwardTemplateInformationAction
extends SubAwardAction {
    private static final String EMPTY_STRING = "";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String CONFIRM_DELETE_ATTACHMENT_KEY = "confirmDeleteAttachmentKey";
    private static final String CONFIRM_DELETE_ATTACHMENT = "confirmDeleteAttachment";
    private static final String CONFIRM_VOID_ATTACHMENT = "confirmVoidAttachment";
    private static final String CONFIRM_VOID_ATTACHMENT_KEY = "confirmVoidAttachmentKey";
    public static final String SUB_AWARD_ATTACHMENT_ERROR_PATH = "document.subAwardList[0].subAwardAttachments[%d]";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        return forward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        ActionForward forward = super.save(mapping, form, request, response);
        this.setModifyAttachments(subAward);
        return forward;
    }

    protected void setModifyAttachments(SubAward subAward) {
        if (this.getGlobableVariableService().getMessageMap().getErrorMessages().isEmpty()) {
            subAward.getSubAwardAttachments().stream().forEach(subAwardAttachments -> subAwardAttachments.setModifyAttachment(false));
        }
    }

    @Override
    protected boolean executeSaveRules(SubAward subAward) {
        return new SubAwardDocumentRule().processAddSubAwardBusinessRules(subAward) && new SubAwardDocumentRule().processAddSubAwardTemplateInfoBusinessRules(subAward);
    }

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    public ActionForward addAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardAttachments subAwardAttachment = ((SubAwardForm)form).getSubAwardAttachmentFormBean().getNewAttachment();
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAward = subAwardForm.getSubAwardDocument();
        if (this.getKualiRuleService().applyRules((DocumentEvent)new AddSubAwardAttachmentEvent(EMPTY_STRING, EMPTY_STRING, subAward, subAwardAttachment))) {
            subAwardAttachment.populateAttachment();
            ((SubAwardForm)form).getSubAwardAttachmentFormBean().addNewAwardAttachment();
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        int selection = this.getSelectedLine(request);
        SubAwardAttachments attachment = subAwardForm.getSubAwardAttachmentFormBean().retrieveExistingAttachment(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment, response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int delAttachment = this.getLineToDelete(request);
        return this.confirm(this.buildDeleteAttachmentConfirmationQuestion(mapping, form, request, response, delAttachment), CONFIRM_DELETE_ATTACHMENT, EMPTY_STRING);
    }

    private StrutsConfirmation buildDeleteAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int deleteAttachment) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        SubAwardAttachments attachment = subAwardDocument.getSubAward().getSubAwardAttachments().get(deleteAttachment);
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_ATTACHMENT_KEY, "document.question.deleteAttachment.text", "Subaward Attachment", attachment.getNewFile().getFileName());
    }

    public ActionForward confirmDeleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int delAttachment = this.getLineToDelete(request);
        subAwardDocument.getSubAward().getSubAwardAttachments().remove(delAttachment);
        return mapping.findForward("basic");
    }

    public ActionForward replaceHistoryOfChangesAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        SubAwardAttachments subAwardAttachments = subAwardDocument.getSubAward().getSubAwardAttachments().get(this.getSelectedLine(request));
        subAwardAttachments.populateAttachment();
        if (subAwardAttachments.getSubAwardId() != null) {
            this.getBusinessObjectService().save((PersistableBusinessObject)subAwardAttachments);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardReports subAwardReports = ((SubAwardForm)form).getSubAwardAttachmentFormBean().getNewReport();
        if (new SubAwardDocumentRule().processsAddSubawardReportRule(subAwardReports)) {
            ((SubAwardForm)form).getSubAwardAttachmentFormBean().addNewReport();
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        SubAwardReports subAwardReports = subAwardDocument.getSubAward().getSubAwardReportList().get(selectedLineNumber);
        subAwardDocument.getSubAward().getSubAwardReportList().remove(selectedLineNumber);
        return mapping.findForward("basic");
    }

    public ActionForward modifyAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardDocument subAwardDocument = ((SubAwardForm)form).getSubAwardDocument();
        int selectedLineIndex = this.getSelectedLine(request);
        subAwardDocument.getSubAwardList().get(0).getSubAwardAttachments().get(selectedLineIndex).setModifyAttachment(true);
        return mapping.findForward("basic");
    }

    public ActionForward voidAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildVoidAttachmentConfirmationQuestion(mapping, form, request, response, this.getSelectedLine(request)), CONFIRM_VOID_ATTACHMENT, EMPTY_STRING);
    }

    public ActionForward applyModifyAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardDocument subAwardDocument = ((SubAwardForm)form).getSubAwardDocument();
        int selectedLineIndex = this.getSelectedLine(request);
        SubAwardAttachments subAwardAttachments = subAwardDocument.getSubAward().getSubAwardAttachments().get(selectedLineIndex);
        boolean valid = new SubAwardDocumentRule().processApplySubawardAttachmentModificationRule(new AddSubAwardAttachmentEvent(",", String.format(SUB_AWARD_ATTACHMENT_ERROR_PATH, selectedLineIndex), subAwardDocument, subAwardAttachments));
        if (valid) {
            subAwardAttachments.setModifyAttachment(false);
            this.updateTimestampIfModified(subAwardAttachments);
            this.getBusinessObjectService().save((PersistableBusinessObject)subAwardAttachments);
        }
        return mapping.findForward("basic");
    }

    protected void updateTimestampIfModified(SubAwardAttachments subAwardAttachments) {
        if (this.hasSubAwardAttachmentBeenModified(subAwardAttachments)) {
            subAwardAttachments.setLastUpdateTimestamp(new Timestamp(new Date().getTime()));
            subAwardAttachments.setLastUpdateUser(this.getGlobableVariableService().getUserSession().getPrincipalName());
        }
    }

    private boolean hasSubAwardAttachmentBeenModified(SubAwardAttachments subAwardAttachments) {
        SubAwardAttachments dbSubAwardAttachments = (SubAwardAttachments)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardAttachments.class, (Object)subAwardAttachments.getAttachmentId());
        return !dbSubAwardAttachments.getSubAwardAttachmentTypeCode().equals(subAwardAttachments.getSubAwardAttachmentTypeCode()) || !dbSubAwardAttachments.getDescription().equals(subAwardAttachments.getDescription());
    }

    private StrutsConfirmation buildVoidAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int voidAttachment) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_VOID_ATTACHMENT_KEY, "document.question.voidAttachment.text", EMPTY_STRING, EMPTY_STRING);
    }

    public ActionForward confirmVoidAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardDocument subAwardDocument = ((SubAwardForm)form).getSubAwardDocument();
        int selectedLineIndex = this.getSelectedLine(request);
        subAwardDocument.getSubAward().getSubAwardAttachments().get(selectedLineIndex).setDocumentStatusCode(AttachmentDocumentStatus.VOID.getCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)subAwardDocument.getSubAward().getSubAwardAttachments().get(selectedLineIndex));
        return mapping.findForward("basic");
    }

    protected GlobalVariableService getGlobableVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }
}

