/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.xml.TableMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SchemaMeta {
    private final List<TableMeta> tables = new ArrayList<TableMeta>();
    private final String comments;
    private final File metaFile;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public SchemaMeta(String string, String string2, String string3) throws InvalidConfigurationException {
        Object object;
        File file = new File(string);
        if (file.isDirectory()) {
            object = (string3 == null ? string2 : string3) + ".meta.xml";
            if (!(file = new File(file, (String)object)).exists()) {
                if (Config.getInstance().isOneOfMultipleSchemas()) {
                    this.logger.info("Meta directory \"" + string + "\" should contain a file named \"" + (String)object + "\"");
                    this.comments = null;
                    this.metaFile = null;
                    return;
                }
                throw new InvalidConfigurationException("Meta directory \"" + string + "\" must contain a file named \"" + (String)object + "\"");
            }
        } else if (!file.exists()) {
            throw new InvalidConfigurationException("Specified meta file \"" + string + "\" does not exist");
        }
        this.metaFile = file;
        object = this.parse(this.metaFile);
        NodeList nodeList = object.getElementsByTagName("comments");
        if (nodeList == null) {
            nodeList = object.getElementsByTagName("remarks");
        }
        this.comments = nodeList != null && nodeList.getLength() > 0 ? nodeList.item(0).getTextContent() : null;
        NodeList nodeList2 = object.getElementsByTagName("tables");
        if (nodeList2 != null) {
            NodeList nodeList3 = ((Element)nodeList2.item(0)).getElementsByTagName("table");
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                Node node = nodeList3.item(i);
                TableMeta tableMeta = new TableMeta(node);
                this.tables.add(tableMeta);
            }
        }
    }

    public String getComments() {
        return this.comments;
    }

    public File getFile() {
        return this.metaFile;
    }

    public List<TableMeta> getTables() {
        return this.tables;
    }

    private void validate(Document document) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream inputStream = this.getClass().getResourceAsStream("/schemaspy.meta.xsd");
        Schema schema = schemaFactory.newSchema(new StreamSource(inputStream));
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    private Document parse(File file) throws InvalidConfigurationException {
        DocumentBuilder documentBuilder;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InvalidConfigurationException("Invalid XML parser configuration", parserConfigurationException);
        }
        try {
            this.logger.info("Parsing " + file);
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new InvalidConfigurationException("Failed to parse " + file, sAXException);
        }
        catch (IOException iOException) {
            throw new InvalidConfigurationException("Could not read " + file + ":", iOException);
        }
        try {
            this.validate(document);
        }
        catch (SAXException sAXException) {
            this.logger.warning("Failed to validate " + file + ": " + sAXException);
        }
        catch (IOException iOException) {
            this.logger.warning("Failed to validate " + file + ": " + iOException);
        }
        return document;
    }
}

