/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificConfig;

public class DbTypeSelectorModel
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 1L;
    private final List<DbSpecificConfig> dbConfigs = new ArrayList<DbSpecificConfig>();
    private Object selected;

    public DbTypeSelectorModel(String string) {
        Pattern pattern = Pattern.compile(".*/" + string);
        TreeSet<String> treeSet = new TreeSet<String>(Config.getBuiltInDatabaseTypes(Config.getLoadedFromJar()));
        for (String string2 : treeSet) {
            DbSpecificConfig dbSpecificConfig = new DbSpecificConfig(string2);
            this.dbConfigs.add(dbSpecificConfig);
            if (!pattern.matcher(string2).matches()) continue;
            this.setSelectedItem(dbSpecificConfig);
        }
        if (this.getSelectedItem() == null && this.dbConfigs.size() > 0) {
            this.setSelectedItem(this.dbConfigs.get(0));
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selected = object;
    }

    @Override
    public Object getElementAt(int n) {
        return this.dbConfigs.get(n);
    }

    @Override
    public int getSize() {
        return this.dbConfigs.size();
    }
}

