/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;

public class HtmlAnomaliesPage
extends HtmlFormatter {
    private static HtmlAnomaliesPage instance = new HtmlAnomaliesPage();

    private HtmlAnomaliesPage() {
    }

    public static HtmlAnomaliesPage getInstance() {
        return instance;
    }

    public void write(Database database, Collection<Table> collection, List<? extends ForeignKeyConstraint> list, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, lineWriter);
        this.writeImpliedConstraints(list, lineWriter);
        this.writeTablesWithoutIndexes(DbAnalyzer.getTablesWithoutIndexes(new HashSet<Table>(collection)), lineWriter);
        this.writeTablesWithOneColumn(DbAnalyzer.getTablesWithOneColumn(collection), lineWriter);
        this.writeTablesWithIncrementingColumnNames(DbAnalyzer.getTablesWithIncrementingColumnNames(collection), lineWriter);
        this.writeDefaultNullStrings(DbAnalyzer.getDefaultNullStringColumns(new HashSet<Table>(collection)), lineWriter);
        this.writeFooter(lineWriter);
    }

    private void writeHeader(Database database, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, null, "Anomalies", lineWriter);
        lineWriter.writeln("<table width='100%'>");
        if (this.sourceForgeLogoEnabled()) {
            lineWriter.writeln("  <tr><td class='container' align='right' valign='top' colspan='2'><a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a></td></tr>");
        }
        lineWriter.writeln("  <tr><td class='container'><b>Things that might not be 'quite right' about your schema:</b></td></tr>");
        lineWriter.writeln("</table>");
        lineWriter.writeln("<ul>");
    }

    private void writeImpliedConstraints(List<? extends ForeignKeyConstraint> list, LineWriter lineWriter) throws IOException {
        Table table;
        lineWriter.writeln("<li>");
        lineWriter.writeln("<b>Columns whose name and type imply a relationship to another table's primary key:</b>");
        int n = 0;
        for (ForeignKeyConstraint foreignKeyConstraint : list) {
            table = foreignKeyConstraint.getChildTable();
            if (table.isView()) continue;
            ++n;
        }
        if (n > 0) {
            lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
            lineWriter.writeln("<colgroup>");
            lineWriter.writeln("<colgroup>");
            lineWriter.writeln("<thead align='left'>");
            lineWriter.writeln("<tr>");
            lineWriter.writeln("  <th>Child Column</th>");
            lineWriter.writeln("  <th>Implied Parent Column</th>");
            lineWriter.writeln("</tr>");
            lineWriter.writeln("</thead>");
            lineWriter.writeln("<tbody>");
            for (ForeignKeyConstraint foreignKeyConstraint : list) {
                table = foreignKeyConstraint.getChildTable();
                if (table.isView()) continue;
                lineWriter.writeln(" <tr>");
                lineWriter.write("  <td class='detail'>");
                String string = table.getName();
                lineWriter.write("<a href='tables/");
                lineWriter.write(HtmlAnomaliesPage.urlEncode(string));
                lineWriter.write(".html'>");
                lineWriter.write(string);
                lineWriter.write("</a>.");
                lineWriter.write(ForeignKeyConstraint.toString(foreignKeyConstraint.getChildColumns()));
                lineWriter.writeln("</td>");
                lineWriter.write("  <td class='detail'>");
                string = foreignKeyConstraint.getParentTable().getName();
                lineWriter.write("<a href='tables/");
                lineWriter.write(HtmlAnomaliesPage.urlEncode(string));
                lineWriter.write(".html'>");
                lineWriter.write(string);
                lineWriter.write("</a>.");
                lineWriter.write(ForeignKeyConstraint.toString(foreignKeyConstraint.getParentColumns()));
                lineWriter.writeln("</td>");
                lineWriter.writeln(" </tr>");
            }
            lineWriter.writeln("</tbody>");
            lineWriter.writeln("</table>");
        }
        this.writeSummary(n, lineWriter);
        lineWriter.writeln("<p></li>");
    }

    private void writeTablesWithoutIndexes(List<Table> list, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<li>");
        lineWriter.writeln("<b>Tables without indexes:</b>");
        if (!list.isEmpty()) {
            lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
            lineWriter.writeln("<colgroup>");
            if (this.displayNumRows) {
                lineWriter.writeln("<colgroup>");
            }
            lineWriter.writeln("<thead align='left'>");
            lineWriter.writeln("<tr>");
            lineWriter.write("  <th>Table</th>");
            if (this.displayNumRows) {
                lineWriter.write("<th>Rows</th>");
            }
            lineWriter.writeln();
            lineWriter.writeln("</tr>");
            lineWriter.writeln("</thead>");
            lineWriter.writeln("<tbody>");
            for (Table table : list) {
                lineWriter.writeln(" <tr>");
                lineWriter.write("  <td class='detail'>");
                lineWriter.write("<a href='tables/");
                lineWriter.write(HtmlAnomaliesPage.urlEncode(table.getName()));
                lineWriter.write(".html'>");
                lineWriter.write(table.getName());
                lineWriter.write("</a>");
                lineWriter.writeln("</td>");
                if (this.displayNumRows) {
                    lineWriter.write("  <td class='detail' align='right'>");
                    if (table.getNumRows() >= 0L) {
                        lineWriter.write(String.valueOf(NumberFormat.getIntegerInstance().format(table.getNumRows())));
                    } else {
                        lineWriter.write("&nbsp;");
                    }
                    lineWriter.writeln("</td>");
                }
                lineWriter.writeln(" </tr>");
            }
            lineWriter.writeln("</tbody>");
            lineWriter.writeln("</table>");
        }
        this.writeSummary(list.size(), lineWriter);
        lineWriter.writeln("<p></li>");
    }

    private void writeTablesWithIncrementingColumnNames(List<Table> list, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<li>");
        lineWriter.writeln("<b>Tables with incrementing column names, potentially indicating denormalization:</b>");
        if (!list.isEmpty()) {
            lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
            lineWriter.writeln("<thead align='left'>");
            lineWriter.writeln("<tr>");
            lineWriter.writeln("  <th>Table</th>");
            lineWriter.writeln("</tr>");
            lineWriter.writeln("</thead>");
            lineWriter.writeln("<tbody>");
            for (Table table : list) {
                lineWriter.writeln(" <tr>");
                lineWriter.write("  <td class='detail'>");
                lineWriter.write("<a href='tables/");
                lineWriter.write(HtmlAnomaliesPage.urlEncode(table.getName()));
                lineWriter.write(".html'>");
                lineWriter.write(table.getName());
                lineWriter.write("</a>");
                lineWriter.writeln("</td>");
                lineWriter.writeln(" </tr>");
            }
            lineWriter.writeln("</tbody>");
            lineWriter.writeln("</table>");
        }
        this.writeSummary(list.size(), lineWriter);
        lineWriter.writeln("<p></li>");
    }

    private void writeTablesWithOneColumn(List<Table> list, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<li>");
        lineWriter.write("<b>Tables that contain a single column:</b>");
        if (!list.isEmpty()) {
            lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
            lineWriter.writeln("<colgroup>");
            lineWriter.writeln("<colgroup>");
            lineWriter.writeln("<thead align='left'>");
            lineWriter.writeln("<tr>");
            lineWriter.writeln("  <th>Table</th>");
            lineWriter.writeln("  <th>Column</th>");
            lineWriter.writeln("</tr>");
            lineWriter.writeln("</thead>");
            lineWriter.writeln("<tbody>");
            for (Table table : list) {
                lineWriter.writeln(" <tr>");
                lineWriter.write("  <td class='detail'>");
                lineWriter.write("<a href='tables/");
                lineWriter.write(HtmlAnomaliesPage.urlEncode(table.getName()));
                lineWriter.write(".html'>");
                lineWriter.write(table.getName());
                lineWriter.write("</a></td><td class='detail'>");
                lineWriter.write(table.getColumns().get(0).toString());
                lineWriter.writeln("</td>");
                lineWriter.writeln(" </tr>");
            }
            lineWriter.writeln("</tbody>");
            lineWriter.writeln("</table>");
        }
        this.writeSummary(list.size(), lineWriter);
        lineWriter.writeln("<p></li>");
    }

    private void writeDefaultNullStrings(List<TableColumn> list, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<li>");
        lineWriter.writeln("<b>Columns whose default value is the word 'NULL' or 'null', but the SQL NULL value may have been intended:</b>");
        this.writeColumnBasedAnomaly(list, lineWriter);
        lineWriter.writeln("<p></li>");
    }

    private void writeColumnBasedAnomaly(List<TableColumn> list, LineWriter lineWriter) throws IOException {
        if (!list.isEmpty()) {
            lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
            lineWriter.writeln("<thead align='left'>");
            lineWriter.writeln("<tr>");
            lineWriter.writeln("  <th>Column</th>");
            lineWriter.writeln("</tr>");
            lineWriter.writeln("</thead>");
            lineWriter.writeln("<tbody>");
            for (TableColumn tableColumn : list) {
                lineWriter.writeln(" <tr>");
                lineWriter.write("  <td class='detail'>");
                String string = tableColumn.getTable().getName();
                lineWriter.write("<a href='tables/");
                lineWriter.write(HtmlAnomaliesPage.urlEncode(string));
                lineWriter.write(".html'>");
                lineWriter.write(string);
                lineWriter.write("</a>.");
                lineWriter.write(tableColumn.getName());
                lineWriter.writeln("</td>");
                lineWriter.writeln(" </tr>");
            }
            lineWriter.writeln("</tbody>");
            lineWriter.writeln("</table>");
        }
        this.writeSummary(list.size(), lineWriter);
    }

    private void writeSummary(int n, LineWriter lineWriter) throws IOException {
        switch (n) {
            case 0: {
                lineWriter.write("<br>Anomaly not detected");
                break;
            }
            case 1: {
                lineWriter.write("1 instance of anomaly detected");
                break;
            }
            default: {
                lineWriter.write(n + " instances of anomaly detected");
            }
        }
    }

    @Override
    protected void writeFooter(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("</ul>");
        super.writeFooter(lineWriter);
    }

    @Override
    protected boolean isAnomaliesPage() {
        return true;
    }
}

