/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.security;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.security.PropertySuppressionService;

public class PropertySuppressionServiceImpl
implements PropertySuppressionService {
    private static final String PROP_SUPPRESS_PATTERNS = "prop.suppress.patterns";
    private ConfigurationService configurationService;

    public String suppressValue(String property, String value) {
        if (property == null) {
            throw new IllegalArgumentException("property is null");
        }
        return this.shouldSuppress(property) ? this.suppressionString() : value;
    }

    public Map<String, String> suppressValueMap(Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        return properties.entrySet().stream().map(e -> PropertySuppressionServiceImpl.entry((String)e.getKey(), this.suppressValue((String)e.getKey(), (String)e.getValue()))).collect(PropertySuppressionServiceImpl.nullSafeEntriesToMap());
    }

    public List<String> suppressValues(String property, List<String> values) {
        if (property == null) {
            throw new IllegalArgumentException("property is null");
        }
        if (this.shouldSuppress(property)) {
            if (values == null) {
                return null;
            }
            return values.stream().map(value -> {
                if (value != null) {
                    return this.suppressionString();
                }
                return null;
            }).collect(Collectors.toList());
        }
        return values;
    }

    public Map<String, List<String>> suppressValuesMap(Map<String, List<String>> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        return properties.entrySet().stream().map(e -> PropertySuppressionServiceImpl.entry((String)e.getKey(), this.suppressValues((String)e.getKey(), (List)e.getValue()))).collect(PropertySuppressionServiceImpl.nullSafeEntriesToMap());
    }

    public boolean shouldSuppress(String property) {
        return this.configuredSuppressionPatterns().stream().anyMatch(property::matches);
    }

    public String suppressionString() {
        return "*****";
    }

    public Set<String> configuredSuppressionPatterns() {
        return Stream.of(this.getConfigurationService().getPropertyValueAsString(PROP_SUPPRESS_PATTERNS).split(",")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    private static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> nullSafeEntriesToMap() {
        return PropertySuppressionServiceImpl.nullSafeToMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    private static <T, K, U> Collector<T, ?, Map<K, U>> nullSafeToMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            HashMap result = new HashMap();
            for (Object item : list) {
                Object key = keyMapper.apply((Object)item);
                if (result.putIfAbsent(key, valueMapper.apply((Object)item)) == null) continue;
                throw new IllegalStateException(String.format("Duplicate key %s", key));
            }
            return result;
        });
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

