/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContentTransformer {
    private static final Logger LOG = LogManager.getLogger(ContentTransformer.class);
    private Transformer transformer;

    public ContentTransformer(StreamSource aStyleSheet) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        this.transformer = factory.newTransformer(aStyleSheet);
    }

    public ContentTransformer(StreamSource aStyleSheet, HashMap parametermap) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        this.transformer = factory.newTransformer(aStyleSheet);
        for (Object o : parametermap.keySet()) {
            String param = o.toString();
            String value = (String)parametermap.get(param);
            this.transformer.setParameter(param, value);
        }
        this.transformer.setErrorListener(new LoggingErrorListener(this.transformer.getErrorListener()));
    }

    public String transform(String xml) throws Exception {
        StreamSource xmlsource = new StreamSource(new StringReader(xml));
        StringWriter sout = new StringWriter();
        this.transformer.transform(xmlsource, new StreamResult(sout));
        return sout.toString();
    }

    private static final class LoggingErrorListener
    implements ErrorListener {
        private final ErrorListener delegate;

        public LoggingErrorListener(ErrorListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            LOG.error("Error transforming document", (Throwable)exception);
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            if (this.delegate == null) {
                throw exception;
            }
            this.delegate.fatalError(exception);
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            LOG.warn("Error transforming document", (Throwable)exception);
        }
    }
}

