/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ReleaseWorkgroupAuthority
extends ActionTakenEvent {
    private String groupId;

    public ReleaseWorkgroupAuthority(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super("y", routeHeader, principal);
    }

    public ReleaseWorkgroupAuthority(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, String groupId) {
        super("y", routeHeader, principal, annotation);
        this.groupId = groupId;
    }

    @Override
    public String validateActionRules() {
        if (this.groupId == null) {
            return "User cannot Release Workgroup Authority without a given workgroup";
        }
        return this.performReleaseWorkgroupAuthority(true);
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules();
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        String error = this.performReleaseWorkgroupAuthority(false);
        if (!StringUtils.isEmpty((String)error)) {
            throw new InvalidActionTakenException(error);
        }
        this.queueDocumentProcessing();
    }

    private String performReleaseWorkgroupAuthority(boolean forValidationOnly) {
        if (!KimApiServiceLocator.getGroupService().isMemberOfGroup(this.getPrincipal().getPrincipalId(), this.groupId)) {
            return this.getPrincipal().getPrincipalName() + " not a member of workgroup " + this.groupId;
        }
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findPendingByDoc(this.getDocumentId());
        for (ActionRequestValue actionRequest : actionRequests) {
            List<ActionItem> actionItems;
            if (!actionRequest.isGroupRequest() || !actionRequest.isActive() || !actionRequest.getGroupId().equals(this.groupId) || (actionItems = actionRequest.getActionItems()).size() != 1) continue;
            ActionItem actionItem = actionItems.get(0);
            if (!actionItem.getPrincipalId().equals(this.getPrincipal().getPrincipalId())) {
                return "User attempting to release workgroup authority did not take it.";
            }
            if (forValidationOnly) continue;
            actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
            this.getActionRequestService().activateRequest(actionRequest);
        }
        return "";
    }
}

