/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.service.DocumentActionListService;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.kra.bo.AbstractPerson;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ElasticsearchDocumentSerializer {
    private static final String DEVELOPMENT_PROPOSAL = "DevelopmentProposal";
    private static final String DOCUMENT_SUFFIX = "Document";
    @Autowired
    @Qualifier(value="businessObjectService")
    protected BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    protected DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="documentActionListService")
    private DocumentActionListService documentActionListService;
    @Autowired
    @Qualifier(value="documentRouteHeaderService")
    private RouteHeaderService documentRouteHeaderService;
    @Autowired
    @Qualifier(value="groupService")
    protected GroupService groupService;
    @Autowired
    @Qualifier(value="personService")
    protected PersonService personService;

    public abstract GrantsSearchDocument translateDocument(Object var1);

    public abstract Set<String> getViewPermissions();

    public abstract boolean supports(Object var1);

    protected void setGenericDocumentFields(GrantsSearchDocument esDoc, Document document) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            document.getDocumentHeader().setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)"kr", (String)document.getDocumentNumber()));
        }
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        esDoc.setDocumentNumber(document.getDocumentNumber());
        esDoc.setDocumentTitle(document.getDocumentTitle());
        esDoc.setRouteStatus(workflowDoc.getStatus().getLabel());
        esDoc.setInitiatorPrincipalId(workflowDoc.getInitiatorPrincipalId());
        esDoc.setInitiatorName(this.personService.getPerson(workflowDoc.getInitiatorPrincipalId()).getName());
        workflowDoc.getActionsTaken().stream().max(Comparator.comparing(ActionTaken::getActionDate)).ifPresent(actionTaken -> {
            esDoc.setLastActionDate(actionTaken.getActionDate().toDate());
            esDoc.setLastActionPrincipalId(actionTaken.getPrincipalId());
            Person lastActionUser = this.personService.getPerson(actionTaken.getPrincipalId());
            esDoc.setLastActionUserName(lastActionUser.getName());
        });
        if ("ProposalDevelopmentDocument".equals(workflowDoc.getDocumentTypeName())) {
            esDoc.setDocumentType(DEVELOPMENT_PROPOSAL);
        } else {
            esDoc.setDocumentType(StringUtils.replace((String)workflowDoc.getDocumentTypeName(), (String)DOCUMENT_SUFFIX, (String)""));
        }
        esDoc.setCreateDate(workflowDoc.getDateCreated().toDate());
        if (workflowDoc.getStatus() == DocumentStatus.ENROUTE) {
            this.setActionRequestFields(esDoc, document);
        }
    }

    protected void setActionRequestFields(GrantsSearchDocument esDoc, Document document) {
        DocumentRouteHeaderValue routeHeader = this.documentRouteHeaderService.getRouteHeader(document.getDocumentNumber());
        this.documentActionListService.fixActionRequestsPositions(routeHeader);
        List<ActionRequestValue> allIncompleteRequests = Stream.concat(this.documentActionListService.populateRouteLogFormActionRequests(routeHeader).stream(), this.documentActionListService.populateRouteLogFutureRequests(routeHeader).stream()).filter(Predicate.not(ActionRequestValue::isDone)).filter(actionRequestValue -> ActionRequestType.COMPLETE.getCode().equalsIgnoreCase(actionRequestValue.getActionRequested()) || ActionRequestType.APPROVE.getCode().equalsIgnoreCase(actionRequestValue.getActionRequested())).collect(Collectors.toList());
        allIncompleteRequests.forEach(request -> this.setActionRequestFieldsForTopLevelRequest(esDoc, (ActionRequestValue)request, allIncompleteRequests));
    }

    protected void setActionRequestFieldsForTopLevelRequest(GrantsSearchDocument esDoc, ActionRequestValue parentRequest, List<ActionRequestValue> allRequests) {
        int position = allRequests.indexOf(parentRequest);
        if (position == 0) {
            esDoc.setApprovalType(parentRequest.getRecipientTypeLabel());
            esDoc.setApprovalPriorityStop(parentRequest.getPriority());
        }
        Set<String> approverPrincipalIds = this.getApproverIdsForRequest(esDoc, parentRequest);
        esDoc.addApproverIds(approverPrincipalIds);
        approverPrincipalIds.forEach(approverId -> {
            esDoc.addApproverSteps((String)approverId, position);
            if (DelegationType.PRIMARY.getCode().equals(parentRequest.getDelegationTypeCode())) {
                esDoc.addApproverPrimaryDelegate((String)approverId);
            }
            if (DelegationType.SECONDARY.getCode().equals(parentRequest.getDelegationTypeCode())) {
                esDoc.addApproverSecondaryDelegate((String)approverId);
            }
        });
        approverPrincipalIds.stream().map(arg_0 -> ((PersonService)this.personService).getPerson(arg_0)).forEach(person -> {
            esDoc.addApproverName(person.getName());
            esDoc.addApproverDetails(String.format("%s;%s", person.getPrincipalId(), person.getName()));
        });
    }

    protected Set<String> getApproverIdsForRequest(GrantsSearchDocument esDoc, ActionRequestValue parentRequest) {
        if (RecipientType.GROUP.getCode().equals(parentRequest.getRecipientTypeCd())) {
            Group group = this.groupService.getGroup(parentRequest.getGroupId());
            esDoc.setPrimaryApprover(group.getName());
            return new HashSet<String>(this.groupService.getMemberPrincipalIds(parentRequest.getGroupId()));
        }
        if (RecipientType.ROLE.getCode().equals(parentRequest.getRecipientTypeCd())) {
            esDoc.setPrimaryApprover(StringUtils.isNotBlank((CharSequence)parentRequest.getQualifiedRoleNameLabel()) ? parentRequest.getQualifiedRoleNameLabel() : parentRequest.getQualifiedRoleName());
            return parentRequest.getChildrenRequests().stream().map(request -> this.getApproverIdsForRequest(esDoc, (ActionRequestValue)request)).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return StringUtils.isBlank((CharSequence)parentRequest.getPrincipalId()) ? Set.of() : Set.of(parentRequest.getPrincipalId());
    }

    protected void setPdSpecificFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        this.setPdSpecificFields(esDoc, List.of(devProposal));
    }

    protected void setPdSpecificFields(GrantsSearchDocument esDoc, Collection<DevelopmentProposal> devProposals) {
        for (DevelopmentProposal proposal : devProposals) {
            esDoc.addProposalNumber(proposal.getProposalNumber());
            esDoc.addOpportunityId(proposal.getOpportunityIdForGG());
            esDoc.addPrevGrantsGovTrackingID(proposal.getPrevGrantsGovTrackingID());
            esDoc.addProgramAnnouncementNumber(proposal.getProgramAnnouncementNumber());
            esDoc.addProgramAnnouncementTitle(proposal.getProgramAnnouncementTitle());
            esDoc.addCfdaNumber(proposal.getProposalCfdas().stream().map(ProposalCfda::getCfdaNumber).collect(Collectors.toSet()));
            esDoc.addAgencyRoutingIdentifier(proposal.getAgencyRoutingIdentifier());
            esDoc.addDeadlineDate(proposal.getDeadlineDate());
            if (proposal.getDeadlineDate() != null) {
                int daysTilDeadline = (int)ChronoUnit.DAYS.between(LocalDate.now(), proposal.getDeadlineDate().toLocalDate());
                if (esDoc.getDaysTilNextDeadline() == null || esDoc.getDaysTilNextDeadline() > daysTilDeadline) {
                    esDoc.setDaysTilNextDeadline(daysTilDeadline);
                }
            }
            if (proposal.getFinalBudget() == null || !CollectionUtils.isNotEmpty(proposal.getFinalBudget().getBudgetSubAwards())) continue;
            esDoc.addSubrecipientOrganizationName(proposal.getFinalBudget().getBudgetSubAwards().stream().map(BudgetSubAwards::getOrganizationName).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
    }

    protected void setPersonFields(GrantsSearchDocument esDoc, Collection<? extends AbstractPersonRoleAware> projectPersons) {
        esDoc.setPersonnelIds(projectPersons.stream().map(person -> StringUtils.isNotBlank((CharSequence)person.getPersonId()) ? person.getPersonId() : String.valueOf(person.getRolodexId())).filter(Objects::nonNull).collect(Collectors.toSet()));
        esDoc.setPersonnelNames(projectPersons.stream().map(AbstractPerson::getFullName).collect(Collectors.toSet()));
        if (StringUtils.isBlank((CharSequence)esDoc.getPrincipalInvestigatorName())) {
            projectPersons.stream().filter(person -> "PI".equals(person.getRoleCode())).findFirst().map(AbstractPerson::getFullName).ifPresent(esDoc::setPrincipalInvestigatorName);
        }
    }

    protected Optional<Rolodex> getRolodex(String rolodexId) {
        if (StringUtils.isEmpty((CharSequence)rolodexId)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Rolodex)this.businessObjectService.findByPrimaryKey(NonOrganizationalRolodex.class, Map.of("rolodexId", rolodexId)));
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

