/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.contrib.jsptag;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.contrib.jsptag.DateTimeZoneSupport;
import org.joda.time.contrib.jsptag.Util;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class FormatSupport
extends TagSupport {
    protected Object value;
    protected String pattern;
    protected String style;
    protected DateTimeZone dateTimeZone;
    protected Locale locale;
    private String var;
    private int scope;

    public FormatSupport() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.value = null;
        this.pattern = null;
        this.style = null;
        this.dateTimeZone = null;
        this.locale = null;
        this.scope = 1;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public int doEndTag() throws JspException {
        String string;
        DateTimeZone dateTimeZone;
        if (this.value == null) {
            if (this.var != null) {
                this.pageContext.removeAttribute(this.var, this.scope);
            }
            return 6;
        }
        DateTimeFormatter dateTimeFormatter = this.pattern != null ? DateTimeFormat.forPattern((String)this.pattern) : (this.style != null ? DateTimeFormat.forStyle((String)this.style) : DateTimeFormat.mediumDate());
        Locale locale = this.locale;
        if (locale == null) {
            locale = Util.getFormattingLocale(this.pageContext, (Tag)this, true, DateFormat.getAvailableLocales());
        }
        if (locale != null) {
            dateTimeFormatter = dateTimeFormatter.withLocale(locale);
        }
        if ((dateTimeZone = this.dateTimeZone) == null) {
            dateTimeZone = DateTimeZoneSupport.getDateTimeZone(this.pageContext, (Tag)this);
        }
        if (dateTimeZone != null) {
            dateTimeFormatter = dateTimeFormatter.withZone(dateTimeZone);
        }
        if (this.value instanceof ReadableInstant) {
            string = dateTimeFormatter.print((ReadableInstant)this.value);
        } else if (this.value instanceof ReadablePartial) {
            string = dateTimeFormatter.print((ReadablePartial)this.value);
        } else {
            throw new JspException("value attribute of format tag must be a ReadableInstant or ReadablePartial, was: " + this.value.getClass().getName());
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)string, this.scope);
        } else {
            try {
                this.pageContext.getOut().print(string);
            }
            catch (IOException iOException) {
                throw new JspTagException(iOException.toString(), (Throwable)iOException);
            }
        }
        return 6;
    }

    public void release() {
        this.init();
    }
}

