/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.maintenance;

import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.exception.PessimisticLockingException;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceLock;
import org.kuali.rice.krad.rules.rule.event.AddCollectionLineEvent;
import org.kuali.rice.krad.service.DataObjectAuthorizationService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.MaintenanceDocumentService;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.MaintenanceDocumentView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;

public class MaintainableImpl
extends ViewHelperServiceImpl
implements Maintainable {
    private static final long serialVersionUID = 9125271369161634992L;
    private static final Logger LOG = LogManager.getLogger(MaintainableImpl.class);
    private String documentNumber;
    private Object dataObject;
    private Class<?> dataObjectClass;
    private String maintenanceAction;
    private transient LegacyDataAdapter legacyDataAdapter;
    private transient DataObjectAuthorizationService dataObjectAuthorizationService;
    private transient DocumentDictionaryService documentDictionaryService;
    private transient EncryptionService encryptionService;
    private transient DataObjectService dataObjectService;
    private transient MaintenanceDocumentService maintenanceDocumentService;
    private transient KualiRuleService kualiRuleService;

    @Override
    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        Object dataObject;
        block4: {
            dataObject = null;
            if (this.getDataObjectService().supports(this.getDataObjectClass())) {
                Map<String, Object> translatedValues = KRADUtils.coerceRequestParameterTypes(this.getDataObjectClass(), dataObjectKeys);
                dataObject = this.getDataObjectService().find(this.getDataObjectClass(), (Object)new CompoundKey(translatedValues));
            } else {
                try {
                    dataObject = this.getLegacyDataAdapter().findObjectBySearch(this.getDataObjectClass(), dataObjectKeys);
                }
                catch (Exception ex) {
                    if (!ex.getClass().equals("org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException") || document.getOldMaintainableObject().isExternalBusinessObject()) break block4;
                    throw new RuntimeException("Data Object Class: " + this.getDataObjectClass() + " is not persistable and is not externalizable - configuration error", ex);
                }
            }
        }
        return dataObject;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public String getDocumentTitle(MaintenanceDocument document) {
        return "";
    }

    @Override
    public Object getDataObject() {
        return this.dataObject;
    }

    @Override
    public void setDataObject(Object object) {
        this.dataObject = object;
    }

    @Override
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @Override
    @Deprecated
    public boolean isLockable() {
        return KRADServiceLocatorWeb.getLegacyDataAdapter().isLockable(this.getDataObject());
    }

    @Override
    public String getMaintenanceAction() {
        return this.maintenanceAction;
    }

    @Override
    public void setMaintenanceAction(String maintenanceAction) {
        this.maintenanceAction = maintenanceAction;
    }

    @Override
    public List<MaintenanceLock> generateMaintenanceLocks() {
        return this.generateMaintenanceLocks(this.getDocumentNumber(), this.getDocumentTypeName(), this.getDataObjectClass(), this.getDataObject());
    }

    protected List<MaintenanceLock> generateMaintenanceLocks(String documentNumber, String documentTypeName, Class<?> dataObjectClass, Object dataObject) {
        ArrayList<MaintenanceLock> maintenanceLocks = new ArrayList<MaintenanceLock>();
        StringBuffer lockRepresentation = new StringBuffer(dataObjectClass.getName());
        lockRepresentation.append("!!");
        DataObjectWrapper wrapper = this.getDataObjectService().wrap(dataObject);
        List<String> keyFieldNames = this.getDocumentDictionaryService().getLockingKeys(documentTypeName);
        if (keyFieldNames != null) {
            Iterator<String> i = keyFieldNames.iterator();
            while (i.hasNext()) {
                String fieldName = i.next();
                Object fieldValue = wrapper.getPropertyValueNullSafe(fieldName);
                if (fieldValue == null) {
                    fieldValue = "";
                }
                if (this.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(dataObjectClass, fieldName)) {
                    try {
                        if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                            fieldValue = this.getEncryptionService().encrypt(fieldValue);
                        }
                    }
                    catch (GeneralSecurityException e) {
                        LOG.error("Unable to encrypt secure field for locking representation " + e.getMessage(), (Throwable)e);
                        throw new RuntimeException("Unable to encrypt secure field for locking representation " + e.getMessage(), e);
                    }
                }
                lockRepresentation.append(fieldName);
                lockRepresentation.append("^^");
                lockRepresentation.append(String.valueOf(fieldValue));
                if (!i.hasNext()) continue;
                lockRepresentation.append("::");
            }
        }
        MaintenanceLock maintenanceLock = new MaintenanceLock();
        maintenanceLock.setDocumentNumber(documentNumber);
        maintenanceLock.setLockingRepresentation(lockRepresentation.toString());
        maintenanceLocks.add(maintenanceLock);
        return maintenanceLocks;
    }

    protected String getDocumentTypeName() {
        return this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(this.dataObjectClass);
    }

    @Override
    public void saveDataObject() {
        if (this.dataObject == null) {
            LOG.warn("dataObject in maintainable was null - this should not be the case.  Skipping saveDataObject()");
            return;
        }
        this.dataObject = this.getLegacyDataAdapter().linkAndSave((Serializable)this.dataObject);
    }

    @Override
    public void deleteDataObject() {
        if (this.dataObject == null) {
            return;
        }
        this.getLegacyDataAdapter().delete(this.dataObject);
    }

    @Override
    public void doRouteStatusChange(DocumentHeader documentHeader) {
    }

    @Override
    public String getLockingDocumentId() {
        return this.getMaintenanceDocumentService().getLockingDocumentId(this, this.documentNumber);
    }

    @Override
    public List<String> getWorkflowEngineDocumentIdsToLock() {
        return null;
    }

    @Override
    public boolean useCustomLockDescriptors() {
        return false;
    }

    @Override
    public String getCustomLockDescriptor(Person user) {
        throw new PessimisticLockingException("The Maintainable for document " + this.documentNumber + " is using pessimistic locking with custom lock descriptors, but the Maintainable has not overridden the getCustomLockDescriptor method");
    }

    @Override
    public boolean isNotesEnabled() {
        return this.getLegacyDataAdapter().areNotesSupported(this.dataObjectClass);
    }

    @Override
    public boolean isExternalBusinessObject() {
        return false;
    }

    @Override
    @Deprecated
    public void prepareExternalBusinessObject(BusinessObject businessObject) {
    }

    @Override
    public boolean isOldDataObjectInDocument() {
        boolean isOldDataObjectInExistence = true;
        if (this.getDataObject() == null) {
            isOldDataObjectInExistence = false;
        } else {
            Map keyFieldValues = this.getLegacyDataAdapter().getPrimaryKeyFieldValuesDOMDS(this.getDataObject());
            for (Object keyValue : keyFieldValues.values()) {
                if (keyValue == null) {
                    isOldDataObjectInExistence = false;
                } else if (keyValue instanceof String && StringUtils.isBlank((String)((String)keyValue))) {
                    isOldDataObjectInExistence = false;
                }
                if (isOldDataObjectInExistence) continue;
                break;
            }
        }
        return isOldDataObjectInExistence;
    }

    @Override
    public void prepareForSave() {
    }

    @Override
    public void processAfterRetrieve() {
    }

    @Override
    public void setupNewFromExisting(MaintenanceDocument document, Map<String, String[]> parameters) {
    }

    @Override
    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterAddLine(ViewModel viewModel, Object addLine, String collectionId, String collectionPath, boolean isValidLine) {
        super.processAfterAddLine(viewModel, addLine, collectionId, collectionPath, isValidLine);
        if (viewModel instanceof MaintenanceDocumentForm && "Edit".equals(((MaintenanceDocumentForm)viewModel).getMaintenanceAction()) && !(addLine instanceof Note) && !(addLine instanceof AdHocRoutePerson) && !(addLine instanceof AdHocRouteWorkgroup)) {
            MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)viewModel;
            MaintenanceDocument document = maintenanceForm.getDocument();
            BindingInfo bindingInfo = (BindingInfo)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "bindingInfo");
            String bindingPrefix = bindingInfo.getBindByNamePrefix();
            Object propertyPath = bindingInfo.getBindingName();
            if (bindingPrefix != "" && bindingPrefix != null) {
                propertyPath = bindingPrefix + "." + (String)propertyPath;
            }
            Collection oldCollection = (Collection)ObjectPropertyUtils.getPropertyValue(document.getOldMaintainableObject().getDataObject(), (String)propertyPath);
            Class collectionObjectClass = (Class)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "collectionObjectClass");
            try {
                Object blankLine = collectionObjectClass.newInstance();
                if (oldCollection instanceof List) {
                    ((List)oldCollection).add(0, blankLine);
                } else {
                    oldCollection.add(blankLine);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new line instance for old maintenance object", e);
            }
        }
    }

    @Override
    public void processAfterDeleteLine(ViewModel model, String collectionId, String collectionPath, int lineIndex) {
        super.processAfterDeleteLine(model, collectionId, collectionPath, lineIndex);
        Class collectionObjectClass = (Class)model.getViewPostMetadata().getComponentPostData(collectionId, "collectionObjectClass");
        if (model instanceof MaintenanceDocumentForm && "Edit".equals(((MaintenanceDocumentForm)model).getMaintenanceAction()) && !collectionObjectClass.getName().equals(Note.class.getName()) && !collectionObjectClass.getName().equals(AdHocRoutePerson.class.getName()) && !collectionObjectClass.getName().equals(AdHocRouteWorkgroup.class.getName())) {
            MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
            MaintenanceDocument document = maintenanceForm.getDocument();
            BindingInfo bindingInfo = (BindingInfo)model.getViewPostMetadata().getComponentPostData(collectionId, "bindingInfo");
            String bindingPrefix = bindingInfo.getBindByNamePrefix();
            Object propertyPath = bindingInfo.getBindingName();
            if (bindingPrefix != "" && bindingPrefix != null) {
                propertyPath = bindingPrefix + "." + (String)propertyPath;
            }
            Collection oldCollection = (Collection)ObjectPropertyUtils.getPropertyValue(document.getOldMaintainableObject().getDataObject(), (String)propertyPath);
            try {
                oldCollection.remove(oldCollection.toArray()[lineIndex]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to delete line instance for old maintenance object", e);
            }
        }
    }

    @Override
    protected boolean performAddLineValidation(ViewModel viewModel, Object newLine, String collectionId, String collectionPath) {
        boolean isValidLine = super.performAddLineValidation(viewModel, newLine, collectionId, collectionPath);
        BindingInfo bindingInfo = (BindingInfo)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "bindingInfo");
        if (viewModel instanceof MaintenanceDocumentForm) {
            MaintenanceDocumentForm form = (MaintenanceDocumentForm)viewModel;
            isValidLine &= this.getKualiRuleService().applyRules(new AddCollectionLineEvent(form.getDocument(), bindingInfo.getBindingName(), newLine));
        }
        return isValidLine;
    }

    protected String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public void performCustomApplyModel(LifecycleElement element, Object model) {
        MaintenanceDocumentForm form = (MaintenanceDocumentForm)model;
        if ("Edit".equals(form.getMaintenanceAction()) && element instanceof InputField && StringUtils.contains((String)((InputField)element).getName(), (String)"document.newMaintainableObject.") && !StringUtils.contains((String)((InputField)element).getName(), (String)"newCollectionLines")) {
            this.setPrimaryKeyReadOnly(element);
        }
    }

    private void setPrimaryKeyReadOnly(LifecycleElement element) {
        String propertyName = ((InputField)element).getPropertyName();
        MaintenanceDocumentView maintenanceView = (MaintenanceDocumentView)ViewLifecycle.getView();
        List primaryKeys = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(maintenanceView.getDataObjectClassName());
        for (String field : primaryKeys) {
            if (!propertyName.equals(field)) continue;
            ((InputField)element).setReadOnly(true);
        }
    }

    @Override
    public void performCustomFinalize(LifecycleElement element, Object model, LifecycleElement parent) {
        if (!(model instanceof MaintenanceDocumentForm)) {
            return;
        }
        MaintenanceDocumentForm form = (MaintenanceDocumentForm)model;
        if (form.getDocument().isFieldsClearedOnCopy()) {
            return;
        }
        if ("Copy".equals(form.getMaintenanceAction())) {
            View view = ViewLifecycle.getView();
            if (element instanceof DataField) {
                DataField field = (DataField)element;
                this.applyDefaultValuesForPreviouslyClearedFields(view, form, field);
                this.clearUnauthorizedField(view, form, field);
            } else if (element instanceof CollectionGroup) {
                CollectionGroup group = (CollectionGroup)element;
                this.clearUnauthorizedLine(view, form, group);
            }
        }
    }

    @Override
    public void performCustomViewFinalize(Object model) {
        if (!(model instanceof MaintenanceDocumentForm)) {
            return;
        }
        MaintenanceDocumentForm form = (MaintenanceDocumentForm)model;
        if ("Copy".equals(form.getMaintenanceAction())) {
            this.processAfterCopy(form.getDocument(), form.getInitialRequestParameters());
            form.getDocument().setFieldsClearedOnCopy(true);
        }
    }

    private void applyDefaultValuesForPreviouslyClearedFields(View view, ViewModel model, DataField field) {
        List<String> clearValueOnCopyPropertyNames = KRADServiceLocatorWeb.getDocumentDictionaryService().getClearValueOnCopyPropertyNames(((MaintenanceDocumentView)view).getDataObjectClassName());
        for (String clearValueOnCopyPropertyName : clearValueOnCopyPropertyNames) {
            if (!field.getPropertyName().equalsIgnoreCase(clearValueOnCopyPropertyName)) continue;
            String bindingPath = field.getBindingInfo().getBindingPath();
            view.getViewHelperService().populateDefaultValueForField(model, field, bindingPath);
        }
    }

    private void clearUnauthorizedField(View view, ViewModel model, DataField field) {
        ViewHelperService helper = ViewLifecycle.getHelper();
        String bindingPath = field.getBindingInfo().getBindingPath();
        if (StringUtils.contains((String)bindingPath, (String)"document.newMaintainableObject.")) {
            String propertyExpression;
            boolean isRestricted = field.isHidden() || Boolean.TRUE.equals(field.getReadOnly()) && !Boolean.TRUE.equals(field.getCanCopyOnReadOnly()) || field.isApplyMask();
            Map<String, String> propertyExpressions = field.getPropertyExpressions();
            if (isRestricted && propertyExpressions.containsKey("defaultValue") && StringUtils.contains((String)(propertyExpression = propertyExpressions.get("defaultValue")), (String)"#sequence")) {
                isRestricted = false;
            }
            if (isRestricted && !this.isLineRestricted(field)) {
                if (ObjectPropertyUtils.isWritableProperty(model, bindingPath)) {
                    ObjectPropertyUtils.setPropertyValue(model, bindingPath, null);
                }
                field.setReadOnlyDisplaySuffixPropertyName(null);
                field.setReadOnlyDisplaySuffix(null);
                helper.populateDefaultValueForField(model, field, bindingPath);
            }
        }
    }

    private boolean isLineRestricted(DataField field) {
        CollectionGroup group = (CollectionGroup)MapUtils.getObject(field.getContext(), (Object)"collectionGroup");
        return group != null && CollectionUtils.isNotEmpty(group.getUnauthorizedLineBindingInfos());
    }

    private void clearUnauthorizedLine(View view, ViewModel model, CollectionGroup group) {
        String bindingPath = group.getBindingInfo().getBindingPath();
        if (StringUtils.contains((String)bindingPath, (String)"document.newMaintainableObject.") && group.getUnauthorizedLineBindingInfos() != null && !group.getCanCopyOnReadOnly().booleanValue()) {
            Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, bindingPath);
            for (BindingInfo bindingInfo : group.getUnauthorizedLineBindingInfos()) {
                String lineBindingPath = bindingInfo.getBindingPath();
                Object line = ObjectPropertyUtils.getPropertyValue(model, lineBindingPath);
                collection.remove(line);
            }
        }
    }

    @Override
    @Deprecated
    protected LegacyDataAdapter getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = KRADServiceLocatorWeb.getLegacyDataAdapter();
        }
        return this.legacyDataAdapter;
    }

    @Override
    @Deprecated
    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        if (this.dataObjectAuthorizationService == null) {
            this.dataObjectAuthorizationService = KRADServiceLocatorWeb.getDataObjectAuthorizationService();
        }
        return this.dataObjectAuthorizationService;
    }

    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    @Override
    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    protected MaintenanceDocumentService getMaintenanceDocumentService() {
        if (this.maintenanceDocumentService == null) {
            this.maintenanceDocumentService = KRADServiceLocatorWeb.getMaintenanceDocumentService();
        }
        return this.maintenanceDocumentService;
    }

    public void setMaintenanceDocumentService(MaintenanceDocumentService maintenanceDocumentService) {
        this.maintenanceDocumentService = maintenanceDocumentService;
    }

    public KualiRuleService getKualiRuleService() {
        if (this.kualiRuleService == null) {
            this.kualiRuleService = KRADServiceLocatorWeb.getKualiRuleService();
        }
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    @Override
    public Object getPersistableBusinessObject() {
        return this.getDataObject();
    }
}

