/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.container.CollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="conditionalFilter", parent="Uif-ConditionalCollectionFilter")
public class ELCollectionFilter
implements CollectionFilter,
Copyable {
    private static final long serialVersionUID = 3273495753269940272L;
    private String expression = "";

    @Override
    public List<Integer> filter(View view, Object model, CollectionGroup collectionGroup) {
        List modelCollection = (List)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath());
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        ArrayList<Integer> showIndexes = new ArrayList<Integer>();
        int lineIndex = 0;
        for (Object line : modelCollection) {
            HashMap<String, Object> context = new HashMap<String, Object>(collectionGroup.getContext());
            context.put("line", line);
            context.put("index", lineIndex);
            Boolean conditionPasses = (Boolean)expressionEvaluator.evaluateExpression(context, this.expression);
            if (conditionPasses.booleanValue()) {
                showIndexes.add(lineIndex);
            }
            ++lineIndex;
        }
        return showIndexes;
    }

    @BeanTagAttribute
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public ELCollectionFilter clone() throws CloneNotSupportedException {
        return (ELCollectionFilter)super.clone();
    }
}

