/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.layout.GridLayoutManager;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTags(value={@BeanTag(name="gridLayout", parent="Uif-GridLayoutBase"), @BeanTag(name="twoColumnGridLayout", parent="Uif-TwoColumnGridLayout"), @BeanTag(name="fourColumnGridLayout", parent="Uif-FourColumnGridLayout"), @BeanTag(name="sixColumnGridLayout", parent="Uif-SixColumnGridLayout")})
public class GridLayoutManagerBase
extends LayoutManagerBase
implements GridLayoutManager {
    private static final long serialVersionUID = 1890011900375071128L;
    private int numberOfColumns;
    private boolean suppressLineWrapping;
    private boolean applyAlternatingRowStyles;
    private boolean applyDefaultCellWidths;
    private boolean renderFirstRowHeader;
    private boolean renderAlternatingHeaderColumns;
    private boolean renderRowFirstCellHeader;
    private List<String> rowCssClasses = new ArrayList<String>();
    private List<String> rowDataAttributes = new ArrayList<String>();

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        Container container = (Container)parent;
        if (this.isApplyDefaultCellWidths()) {
            this.addStyleClass("uif-table-fixed");
        }
        if (this.suppressLineWrapping) {
            this.numberOfColumns = container.getItems().size();
        }
        for (Component component : container.getItems()) {
            if (!(this instanceof TableLayoutManager)) {
                component.addWrapperCssClass("uif-gridLayoutCell");
            }
            this.setCellAttributes(component);
        }
    }

    protected void setCellAttributes(Component component) {
        if (StringUtils.isNotBlank((String)component.getWidth()) && StringUtils.isBlank((String)component.getCellWidth())) {
            component.setCellWidth(component.getWidth());
            component.setWidth("");
        }
        if (StringUtils.isNotBlank((String)component.getAlign()) && !StringUtils.contains((String)component.getWrapperStyle(), (String)"text-align: ")) {
            if (component.getWrapperStyle() == null) {
                component.setWrapperStyle("");
            }
            component.setWrapperStyle(component.getWrapperStyle() + "text-align: " + component.getAlign() + ";");
            component.setAlign("");
        }
        if (StringUtils.isNotBlank((String)component.getValign()) && !StringUtils.contains((String)component.getWrapperStyle(), (String)"vertical-align: ")) {
            if (component.getWrapperStyle() == null) {
                component.setWrapperStyle("");
            }
            component.setWrapperStyle(component.getWrapperStyle() + "vertical-align: " + component.getValign() + ";");
            component.setValign("");
        }
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return Group.class;
    }

    @Override
    @BeanTagAttribute
    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    @Override
    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    @Override
    @BeanTagAttribute
    public boolean isSuppressLineWrapping() {
        return this.suppressLineWrapping;
    }

    @Override
    public void setSuppressLineWrapping(boolean suppressLineWrapping) {
        this.suppressLineWrapping = suppressLineWrapping;
    }

    @Override
    @BeanTagAttribute
    public boolean isApplyAlternatingRowStyles() {
        return this.applyAlternatingRowStyles;
    }

    @Override
    public void setApplyAlternatingRowStyles(boolean applyAlternatingRowStyles) {
        this.applyAlternatingRowStyles = applyAlternatingRowStyles;
    }

    @Override
    @BeanTagAttribute
    public boolean isApplyDefaultCellWidths() {
        return this.applyDefaultCellWidths;
    }

    @Override
    public void setApplyDefaultCellWidths(boolean applyDefaultCellWidths) {
        this.applyDefaultCellWidths = applyDefaultCellWidths;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderRowFirstCellHeader() {
        return this.renderRowFirstCellHeader;
    }

    @Override
    public void setRenderRowFirstCellHeader(boolean renderRowFirstCellHeader) {
        this.renderRowFirstCellHeader = renderRowFirstCellHeader;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderFirstRowHeader() {
        return this.renderFirstRowHeader;
    }

    @Override
    public void setRenderFirstRowHeader(boolean renderFirstRowHeader) {
        this.renderFirstRowHeader = renderFirstRowHeader;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderAlternatingHeaderColumns() {
        return this.renderAlternatingHeaderColumns;
    }

    @Override
    public void setRenderAlternatingHeaderColumns(boolean renderAlternatingHeaderColumns) {
        this.renderAlternatingHeaderColumns = renderAlternatingHeaderColumns;
    }

    @Override
    @BeanTagAttribute
    public List<String> getRowCssClasses() {
        return this.rowCssClasses;
    }

    @Override
    public void setRowCssClasses(List<String> rowCssClasses) {
        this.rowCssClasses = rowCssClasses;
    }

    @Override
    @BeanTagAttribute(name="rowDataAttributes", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getRowDataAttributes() {
        return this.rowDataAttributes;
    }

    @Override
    public void setRowDataAttributes(List<String> rowDataAttributes) {
        this.rowDataAttributes = rowDataAttributes;
    }
}

