/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.kuali.rice.core.framework.util.ReflectionUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.RecycleUtils;

public class ContextUtils {
    private ContextUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushObjectToContextDeep(Collection<? extends LifecycleElement> elements, String contextName, Object contextValue) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        LinkedList<? extends LifecycleElement> elementQueue = new LinkedList<LifecycleElement>();
        try {
            elementQueue.addAll(elements);
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (currentElement instanceof Component) {
                    ((Component)currentElement).pushObjectToContext(contextName, contextValue);
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    public static void pushObjectToContextDeep(Component component, String contextName, Object contextValue) {
        if (component == null) {
            return;
        }
        ContextUtils.pushObjectToContextDeep(Collections.singletonList(component), contextName, contextValue);
    }

    public static void pushAllToContextDeep(Component component, Map<String, Object> sourceContext) {
        if (component == null) {
            return;
        }
        ContextUtils.pushAllToContextDeep(Collections.singletonList(component), sourceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushAllToContextDeep(List<? extends Component> components, Map<String, Object> sourceContext) {
        if (components == null || components.isEmpty()) {
            return;
        }
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        try {
            elementQueue.addAll(components);
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (currentElement instanceof Component) {
                    ((Component)currentElement).pushAllToContext(sourceContext);
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    public static void updateContextsForLine(List<? extends Component> components, CollectionGroup collectionGroup, Object collectionLine, int lineIndex, String lineSuffix) {
        for (Component component : components) {
            ContextUtils.updateContextForLine(component, collectionGroup, collectionLine, lineIndex, lineSuffix);
        }
    }

    public static void updateContextForLine(Component component, CollectionGroup collectionGroup, Object collectionLine, int lineIndex, String lineSuffix) {
        HashMap<String, Object> toUpdate = new HashMap<String, Object>(5);
        toUpdate.put("collectionGroup", collectionGroup);
        toUpdate.put("line", collectionLine);
        toUpdate.put("index", lineIndex);
        toUpdate.put("lineSuffix", lineSuffix);
        boolean isAddLine = lineIndex == -1;
        toUpdate.put("isAddLine", isAddLine);
        ContextUtils.pushAllToContextDeep(component, toUpdate);
    }

    public static void cleanContextDeep(LifecycleElement lifecycleElement) {
        if (lifecycleElement == null) {
            return;
        }
        lifecycleElement.setContext(null);
        Class<?> elementClass = lifecycleElement.getClass();
        List fields = ReflectionUtils.getAllFields(elementClass);
        for (Field field : fields) {
            Object elements;
            if (Collection.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.makeAccessible((Field)field);
                elements = (Collection)ReflectionUtils.getField((Field)field, (Object)lifecycleElement);
                if (elements == null) continue;
                Iterator<Object> iterator = elements.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e == null || !LifecycleElement.class.isAssignableFrom(e.getClass())) continue;
                    ContextUtils.cleanContextDeep((LifecycleElement)e);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.makeAccessible((Field)field);
                elements = (Map)ReflectionUtils.getField((Field)field, (Object)lifecycleElement);
                if (elements == null) continue;
                for (Object object : elements.entrySet()) {
                    if (object == null || !LifecycleElement.class.isAssignableFrom(object.getClass())) continue;
                    ContextUtils.cleanContextDeep((LifecycleElement)object);
                }
                continue;
            }
            if (!LifecycleElement.class.isAssignableFrom(field.getType())) continue;
            ReflectionUtils.makeAccessible((Field)field);
            LifecycleElement nestedElement = (LifecycleElement)ReflectionUtils.getField((Field)field, (Object)lifecycleElement);
            ContextUtils.cleanContextDeep(nestedElement);
        }
    }
}

