/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.Range;

public class HttpCookieManager {
    private static final String PERIOD_COOKIE_NAME = "javamelody.period";
    private static Range defaultRange = Period.JOUR.getRange();

    public Range getRange(HttpServletRequest req, HttpServletResponse resp) {
        Range range;
        String pattern = HttpParameter.PATTERN.getParameterFrom(req);
        DateFormat dateFormat = pattern == null || pattern.isEmpty() ? I18N.createDateFormat() : new SimpleDateFormat(pattern, Locale.US);
        if (HttpParameter.PERIOD.getParameterFrom(req) == null) {
            Cookie cookie = this.getCookieByName(req, PERIOD_COOKIE_NAME);
            range = cookie == null ? defaultRange : Range.parse(cookie.getValue(), dateFormat);
        } else {
            range = Range.parse(HttpParameter.PERIOD.getParameterFrom(req), dateFormat);
            this.addCookie(req, resp, PERIOD_COOKIE_NAME, range.getValue());
        }
        return range;
    }

    Cookie getCookieByName(HttpServletRequest req, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    void addCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, String cookieValue) {
        if (!"added".equals(req.getAttribute(cookieName))) {
            Cookie cookie = new Cookie(cookieName, cookieValue);
            cookie.setMaxAge(2592000);
            cookie.setPath(req.getRequestURI());
            resp.addCookie(cookie);
            req.setAttribute(cookieName, (Object)"added");
        }
    }

    String getCookiesAsString(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                sb.append(cookie.getName()).append('=').append(cookie.getValue());
                if (i >= cookies.length - 1) continue;
                sb.append("; ");
            }
            return sb.toString();
        }
        return null;
    }

    public static void setDefaultRange(Range range) {
        defaultRange = range;
    }
}

