/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.messaging.AsynchronousCallback;
import org.kuali.rice.ksb.api.messaging.MessageHelper;
import org.kuali.rice.ksb.messaging.serviceproxies.AsynchronousServiceCallProxy;
import org.kuali.rice.ksb.messaging.serviceproxies.DelayedAsynchronousServiceCallProxy;
import org.kuali.rice.ksb.messaging.serviceproxies.SynchronousServiceCallProxy;

public class MessageHelperImpl
implements MessageHelper {
    public <T> T getServiceAsynchronously(QName qname) {
        return this.getServiceAsynchronously(qname, null, null, null, null, null);
    }

    public <T> T getServiceAsynchronously(QName qname, String applicationId) {
        return this.getServiceAsynchronously(qname, applicationId, null, null, null, null);
    }

    public <T> T getServiceAsynchronously(QName qname, AsynchronousCallback callback) {
        return this.getServiceAsynchronously(qname, null, callback, null, null, null);
    }

    public <T> T getServiceAsynchronously(QName qname, AsynchronousCallback callback, Serializable context) {
        return this.getServiceAsynchronously(qname, null, callback, context, null, null);
    }

    public <T> T getServiceAsynchronously(QName qname, AsynchronousCallback callback, Serializable context, String value1, String value2) {
        return this.getServiceAsynchronously(qname, null, callback, context, value1, value2);
    }

    public <T> T getServiceAsynchronously(QName qname, String applicationId, AsynchronousCallback callback, Serializable context, String value1, String value2) {
        List<Endpoint> endpoints = KsbApiServiceLocator.getServiceBus().getEndpoints(qname);
        if ((endpoints = this.filterEndpointsByApplicationId(endpoints, applicationId)).isEmpty()) {
            throw new RuntimeException("Cannot create service proxy, failed to locate any endpoints with the given service name: " + qname + (String)(applicationId != null ? ", and application id: " + applicationId : ""));
        }
        return MessageHelperImpl.createProxy(MessageHelperImpl.syncMode(), endpoints, callback, context, value1, value2);
    }

    public <T> T getDelayedAsynchronousServiceCallProxy(QName qname, String applicationId, Serializable context, String value1, String value2, long delayMilliseconds) {
        List<Endpoint> endpoints = KsbApiServiceLocator.getServiceBus().getEndpoints(qname);
        if ((endpoints = this.filterEndpointsByApplicationId(endpoints, applicationId)).isEmpty()) {
            throw new RuntimeException("Cannot create service proxy, failed to locate any endpoints with the given service name: " + qname);
        }
        return MessageHelperImpl.createProxyDelayed(MessageHelperImpl.syncMode(), endpoints, context, value1, value2, delayMilliseconds);
    }

    public <T> T getServiceAsynchronously(QName qname, Serializable context, String value1, String value2, long delayMilliseconds) {
        return this.getDelayedAsynchronousServiceCallProxy(qname, null, context, value1, value2, delayMilliseconds);
    }

    public <T> T getServiceAsynchronously(QName qname, String applicationId, Serializable context, String value1, String value2, long delayMilliseconds) {
        return this.getDelayedAsynchronousServiceCallProxy(qname, applicationId, context, value1, value2, delayMilliseconds);
    }

    public <T> List<T> getAllRemoteServicesAsynchronously(QName qname) {
        List endpoints = KsbApiServiceLocator.getServiceBus().getRemoteEndpoints(qname);
        if (endpoints.isEmpty()) {
            throw new RuntimeException("Cannot create service proxy, failed to locate any endpoints with the given service name: " + qname);
        }
        ArrayList<T> proxies = new ArrayList<T>();
        boolean syncMode = MessageHelperImpl.syncMode();
        String instanceId = KsbApiServiceLocator.getServiceBus().getInstanceId();
        for (Endpoint e : endpoints) {
            if (e.getServiceConfiguration().getInstanceId().equals(instanceId)) continue;
            proxies.add(MessageHelperImpl.createProxy(syncMode, endpoints, null, null, null, null));
        }
        return proxies;
    }

    public static <T> T createProxy(boolean sync, List<Endpoint> endpoints, AsynchronousCallback callback, Serializable context, String value1, String value2) {
        return (T)(sync ? SynchronousServiceCallProxy.createInstance(endpoints, callback, context, value1, value2) : AsynchronousServiceCallProxy.createInstance(endpoints, callback, context, value1, value2));
    }

    public static <T> T createProxyDelayed(boolean sync, List<Endpoint> endpoints, Serializable context, String value1, String value2, long delayMilliseconds) {
        return (T)(sync ? SynchronousServiceCallProxy.createInstance(endpoints, null, context, value1, value2) : DelayedAsynchronousServiceCallProxy.createInstance(endpoints, context, value1, value2, delayMilliseconds));
    }

    private static boolean syncMode() {
        return "synchronous".equals(ConfigContext.getCurrentContextConfig().getProperty("message.delivery"));
    }

    private List<Endpoint> filterEndpointsByApplicationId(List<Endpoint> endpoints, String applicationId) {
        if (StringUtils.isBlank((String)applicationId)) {
            return endpoints;
        }
        ArrayList<Endpoint> filteredEndpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.getServiceConfiguration().getApplicationId().equals(applicationId)) continue;
            filteredEndpoints.add(endpoint);
        }
        return filteredEndpoints;
    }
}

