/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.exceptionhandling;

import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.exceptionhandling.MessageExceptionHandler;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class DefaultMessageExceptionHandler
implements MessageExceptionHandler {
    private static final Logger LOG = LogManager.getLogger(DefaultMessageExceptionHandler.class);
    private static final long DEFAULT_TIME_INCREMENT = 3600000L;
    private static final int DEFAULT_MAX_RETRIES = 7;

    @Override
    public void handleException(Throwable throwable, PersistedMessageBO message, Object service) throws Exception {
        if (this.isInException(message)) {
            this.placeInException(throwable, message);
        } else {
            this.requeue(throwable, message);
        }
    }

    @Override
    public void handleExceptionLastDitchEffort(Throwable throwable, PersistedMessageBO message, Object service) throws Exception {
        LOG.error("Complete failure when attempting to put message into exception routing!  Message was: " + message, throwable);
    }

    @Override
    public boolean isInException(PersistedMessageBO message) {
        ServiceConfiguration serviceConfiguration = message.getMethodCall().getServiceConfiguration();
        if (this.getImmediateExceptionRouting().booleanValue()) {
            return true;
        }
        Integer globalMaxRetryAttempts = this.getGlobalMaxRetryAttempts();
        if (globalMaxRetryAttempts != null) {
            LOG.info("Global Max Retry has been set, so is overriding other max retry attempts.");
            LOG.info("Global Max Retry count = " + globalMaxRetryAttempts + ".");
            return message.getRetryCount() >= globalMaxRetryAttempts;
        }
        if (serviceConfiguration.getRetryAttempts() > 0) {
            LOG.info("Message set for retry exception handling.  Message retry count = " + message.getRetryCount());
            if (message.getRetryCount() >= serviceConfiguration.getRetryAttempts()) {
                return true;
            }
        } else if (serviceConfiguration.getMillisToLive() > 0L) {
            LOG.info("Message set for time to live exception handling.  Message expiration date = " + message.getExpirationDate().getTime());
            if (System.currentTimeMillis() > message.getExpirationDate().getTime()) {
                return true;
            }
        } else if (message.getRetryCount() >= this.getMaxRetryAttempts()) {
            LOG.info("Message set for default exception handling.  Comparing retry count = " + message.getRetryCount() + " against default max count.");
            return true;
        }
        return false;
    }

    protected void requeue(Throwable throwable, PersistedMessageBO message) throws Exception {
        Integer retryCount = message.getRetryCount();
        message.setQueueStatus("Q");
        long addMilliseconds = Math.round((double)this.getTimeIncrement().longValue() * Math.pow(2.0, retryCount.intValue()));
        Timestamp currentTime = message.getQueueDate();
        Timestamp newTime = new Timestamp(currentTime.getTime() + addMilliseconds);
        message.setQueueStatus("Q");
        message.setRetryCount(new Integer(retryCount + 1));
        message.setQueueDate(newTime);
        this.scheduleExecution(throwable, message);
    }

    protected void placeInException(Throwable throwable, PersistedMessageBO message) throws Exception {
        message.setQueueStatus("E");
        message.setQueueDate(new Timestamp(System.currentTimeMillis()));
        message = KSBServiceLocator.getMessageQueueService().save(message);
    }

    protected void scheduleExecution(Throwable throwable, PersistedMessageBO message) throws Exception {
        KSBServiceLocator.getExceptionRoutingService().scheduleExecution(throwable, message, null);
    }

    public Integer getMaxRetryAttempts() {
        try {
            return new Integer(ConfigContext.getCurrentContextConfig().getProperty("RouteQueue.maxRetryAttempts"));
        }
        catch (NumberFormatException e) {
            LOG.error("Constant 'RouteQueue.maxRetryAttempts' is not a number and is being used as a default for exception messages.  7 will be used as a retry limit until this number is fixed", (Throwable)e);
            return 7;
        }
    }

    public Integer getGlobalMaxRetryAttempts() {
        String globalMax = ConfigContext.getCurrentContextConfig().getProperty("RouteQueue.maxRetryAttemptsOverride");
        if (StringUtils.isBlank((String)globalMax)) {
            return null;
        }
        try {
            Integer globalMaxRetries = new Integer(globalMax);
            if (globalMaxRetries >= 0) {
                return globalMaxRetries;
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Constant 'RouteQueue.maxRetryAttemptsOverride' is not a number and is being used as a default for exception messages.  7 will be used as a retry limit until this number is fixed", (Throwable)e);
        }
        return null;
    }

    public Long getTimeIncrement() {
        try {
            return new Long(ConfigContext.getCurrentContextConfig().getProperty("RouteQueue.timeIncrement"));
        }
        catch (NumberFormatException e) {
            LOG.error("Constant 'RouteQueue.timeIncrement' is not a number and will not be used as the default time increment for exception routing.  Default of 3600000 will be used.", (Throwable)e);
            return 3600000L;
        }
    }

    public Boolean getImmediateExceptionRouting() {
        return new Boolean(ConfigContext.getCurrentContextConfig().getProperty("Routing.ImmediateExceptionRouting"));
    }
}

