/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.rule;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;

public class ContextBusRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean isValid = true;
        ContextBo newContext = (ContextBo)document.getNewMaintainableObject().getDataObject();
        ContextBo oldContext = (ContextBo)document.getOldMaintainableObject().getDataObject();
        boolean isEditAction = "Edit".equals(document.getNewMaintainableObject().getMaintenanceAction());
        isValid &= this.validateId(oldContext, newContext, isEditAction);
        return isValid &= this.validateNameNamespace(newContext, isEditAction);
    }

    private boolean validateId(ContextBo oldContext, ContextBo newContext, boolean isEditAction) {
        if (StringUtils.isBlank((String)newContext.getId())) {
            this.putFieldError("dataObject.id", "error.context.blankId");
            return false;
        }
        if (isEditAction) {
            if (!oldContext.getId().equals(newContext.getId())) {
                throw new IllegalStateException("The ID of a Context being edited must not change.");
            }
        } else {
            ContextDefinition contextInDatabase = this.getContextBoService().getContextByContextId(newContext.getId());
            if (contextInDatabase != null) {
                this.putFieldError("dataObject.id", "error.context.duplicateId");
                return false;
            }
        }
        return true;
    }

    private boolean validateNameNamespace(ContextBo newContext, boolean isEditAction) {
        if (isEditAction) {
            ContextDefinition contextInDatabase = this.getContextBoService().getContextByNameAndNamespace(newContext.getName(), newContext.getNamespace());
            if (contextInDatabase != null && !contextInDatabase.getId().equals(newContext.getId())) {
                this.putFieldError("dataObject.name", "error.context.duplicateNameNamespace");
                return false;
            }
        } else if (StringUtils.isNotBlank((String)newContext.getName()) && StringUtils.isNotBlank((String)newContext.getNamespace())) {
            ContextDefinition contextInDatabase = this.getContextBoService().getContextByNameAndNamespace(newContext.getName(), newContext.getNamespace());
            if (contextInDatabase != null) {
                this.putFieldError("dataObject.name", "error.context.duplicateNameNamespace");
                return false;
            }
        } else {
            if (StringUtils.isBlank((String)newContext.getName())) {
                this.putFieldError("dataObject.name", "error.context.blankName");
            }
            if (StringUtils.isBlank((String)newContext.getNamespace())) {
                this.putFieldError("dataObject.name", "error.context.blankNamespace");
            }
            return false;
        }
        return true;
    }

    public ContextBoService getContextBoService() {
        return KrmsRepositoryServiceLocator.getContextBoService();
    }
}

