/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.api.county;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.location.api.county.CountyContract;
import org.w3c.dom.Element;

@XmlRootElement(name="county")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CountyType", propOrder={"code", "name", "countryCode", "stateCode", "active", "versionNumber", "_futureElements"})
public final class County
extends AbstractDataTransferObject
implements CountyContract {
    private static final long serialVersionUID = 6097498602725305353L;
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="countryCode", required=true)
    private final String countryCode;
    @XmlElement(name="stateCode", required=true)
    private final String stateCode;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private County() {
        this.code = null;
        this.name = null;
        this.countryCode = null;
        this.stateCode = null;
        this.active = false;
        this.versionNumber = null;
    }

    private County(Builder builder) {
        this.code = builder.getCode();
        this.name = builder.getName();
        this.countryCode = builder.getCountryCode();
        this.stateCode = builder.getStateCode();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getStateCode() {
        return this.stateCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/location/v2_0/CountyType";
    }

    static class Elements {
        static final String CODE = "code";
        static final String NAME = "name";
        static final String COUNTRY_CODE = "countryCode";
        static final String STATE_CODE = "stateCode";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "county";
        static final String TYPE_NAME = "CountyType";

        Constants() {
        }
    }

    public static class Builder
    implements CountyContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 7077484401017765844L;
        private String code;
        private String name;
        private String countryCode;
        private String stateCode;
        private boolean active;
        private Long versionNumber;

        private Builder(String code, String name, String countryCode, String stateCode) {
            this.setCode(code);
            this.setName(name);
            this.setCountryCode(countryCode);
            this.setStateCode(stateCode);
            this.setVersionNumber(this.versionNumber);
        }

        public static Builder create(String code, String name, String countryCode, String stateCode) {
            Builder builder = new Builder(code, name, countryCode, stateCode);
            builder.setActive(true);
            return builder;
        }

        public static Builder create(CountyContract contract) {
            Builder builder = new Builder(contract.getCode(), contract.getName(), contract.getCountryCode(), contract.getStateCode());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("code is blank");
            }
            this.code = code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        @Override
        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            if (StringUtils.isBlank((String)countryCode)) {
                throw new IllegalArgumentException("countryCode is blank");
            }
            this.countryCode = countryCode;
        }

        @Override
        public String getStateCode() {
            return this.stateCode;
        }

        public void setStateCode(String stateCode) {
            if (StringUtils.isBlank((String)stateCode)) {
                throw new IllegalArgumentException("stateCode is blank");
            }
            this.stateCode = stateCode;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public County build() {
            return new County(this);
        }
    }
}

