/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;

public class CoreServiceConfigurer
extends ModuleConfigurer {
    private static final String MODULE_NAME = "coreservice";
    public static final String CORESERVICE_DATASOURCE_OBJ = "coreService.datasource";
    private DataSource dataSource;

    public CoreServiceConfigurer() {
        super(MODULE_NAME);
        this.setValidRunModes(Arrays.asList(RunMode.REMOTE, RunMode.LOCAL));
    }

    public List<String> getPrimarySpringFiles() {
        this.LOG.info("CoreServiceConfigurer:getPrimarySpringFiles: getRunMode => " + this.getRunMode());
        ArrayList<String> springFileLocations = new ArrayList<String>();
        if (RunMode.REMOTE == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "CoreServiceRemoteSpringBeans.xml");
        } else if (RunMode.LOCAL == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "CoreServiceLocalSpringBeans.xml");
        }
        return springFileLocations;
    }

    protected void addAdditonalToConfig() {
        super.addAdditonalToConfig();
        this.configureDataSource();
    }

    private void configureDataSource() {
        if (this.getDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject(CORESERVICE_DATASOURCE_OBJ, (Object)this.getDataSource());
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

