/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.EntityUtils;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationContract;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierContract;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoDefault;
import org.w3c.dom.Element;

@XmlRootElement(name="entityDefault")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityDefaultType", propOrder={"entityId", "name", "principals", "entityTypeContactInfos", "affiliations", "defaultAffiliation", "employment", "externalIdentifiers", "privacyPreferences", "active", "_futureElements"})
public class EntityDefault
extends AbstractDataTransferObject {
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="name", required=false)
    private final EntityName name;
    @XmlElementWrapper(name="principals", required=false)
    @XmlElement(name="principal", required=false)
    private final List<Principal> principals;
    @XmlElementWrapper(name="entityTypeContactInfos", required=false)
    @XmlElement(name="entityTypeContactInfo", required=false)
    private final List<EntityTypeContactInfoDefault> entityTypeContactInfos;
    @XmlElementWrapper(name="affiliations", required=false)
    @XmlElement(name="affiliation", required=false)
    private final List<EntityAffiliation> affiliations;
    @XmlElement(name="defaultAffiliation", required=false)
    private final EntityAffiliation defaultAffiliation;
    @XmlElement(name="employment", required=false)
    private final EntityEmployment employment;
    @XmlElementWrapper(name="externalIdentifiers", required=false)
    @XmlElement(name="externalIdentifier", required=false)
    private final List<EntityExternalIdentifier> externalIdentifiers;
    @XmlElement(name="privacyPreferences", required=false)
    private final EntityPrivacyPreferences privacyPreferences;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityDefault() {
        this.entityId = null;
        this.name = null;
        this.principals = null;
        this.affiliations = null;
        this.defaultAffiliation = null;
        this.entityTypeContactInfos = null;
        this.employment = null;
        this.externalIdentifiers = null;
        this.privacyPreferences = null;
        this.active = false;
    }

    public EntityDefault(String entityId, EntityName name, List<Principal> principals, List<EntityTypeContactInfoDefault> entityTypes, List<EntityAffiliation> affiliations, EntityAffiliation defaultAffiliation, EntityEmployment employment, List<EntityExternalIdentifier> externalIdentifiers, EntityPrivacyPreferences privacyPreferences, boolean active) {
        this.entityId = entityId;
        this.name = name;
        this.principals = principals;
        this.entityTypeContactInfos = entityTypes;
        this.affiliations = affiliations;
        this.defaultAffiliation = defaultAffiliation;
        this.employment = employment;
        this.externalIdentifiers = externalIdentifiers;
        this.privacyPreferences = privacyPreferences;
        this.active = active;
    }

    public EntityDefault(Builder builder) {
        this.entityId = builder.entityId;
        this.name = builder.getName() == null ? null : builder.getName().build();
        this.principals = new ArrayList<Principal>();
        if (CollectionUtils.isNotEmpty(builder.getPrincipals())) {
            for (Principal.Builder principal : builder.getPrincipals()) {
                this.principals.add(principal.build());
            }
        }
        this.entityTypeContactInfos = new ArrayList<EntityTypeContactInfoDefault>();
        if (CollectionUtils.isNotEmpty(builder.getEntityTypeContactInfos())) {
            for (EntityTypeContactInfoDefault.Builder entityType : builder.getEntityTypeContactInfos()) {
                this.entityTypeContactInfos.add(entityType.build());
            }
        }
        this.affiliations = new ArrayList<EntityAffiliation>();
        if (CollectionUtils.isNotEmpty(builder.getAffiliations())) {
            for (EntityAffiliation.Builder affiliation : builder.getAffiliations()) {
                this.affiliations.add(affiliation.build());
            }
        }
        this.defaultAffiliation = builder.getDefaultAffiliation() == null && CollectionUtils.isNotEmpty(this.affiliations) ? EntityUtils.getDefaultItem(this.affiliations) : (builder.getDefaultAffiliation() == null ? null : builder.getDefaultAffiliation().build());
        this.employment = builder.getEmployment() == null ? null : builder.getEmployment().build();
        this.externalIdentifiers = new ArrayList<EntityExternalIdentifier>();
        if (CollectionUtils.isNotEmpty(builder.getExternalIdentifiers())) {
            for (EntityExternalIdentifier.Builder externalId : builder.getExternalIdentifiers()) {
                this.externalIdentifiers.add(externalId.build());
            }
        }
        this.privacyPreferences = builder.getPrivacyPreferences() == null ? null : builder.getPrivacyPreferences().build();
        this.active = builder.isActive();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public EntityName getName() {
        return this.name;
    }

    public List<Principal> getPrincipals() {
        return Collections.unmodifiableList(this.principals);
    }

    public List<EntityTypeContactInfoDefault> getEntityTypeContactInfos() {
        return Collections.unmodifiableList(this.entityTypeContactInfos);
    }

    public List<EntityAffiliation> getAffiliations() {
        return Collections.unmodifiableList(this.affiliations);
    }

    public EntityAffiliation getDefaultAffiliation() {
        return this.defaultAffiliation;
    }

    public EntityEmployment getEmployment() {
        return this.employment;
    }

    public List<EntityExternalIdentifier> getExternalIdentifiers() {
        return Collections.unmodifiableList(this.externalIdentifiers);
    }

    public EntityPrivacyPreferences getPrivacyPreferences() {
        return this.privacyPreferences;
    }

    public boolean isActive() {
        return this.active;
    }

    public EntityTypeContactInfoDefault getEntityType(String entityTypeCode) {
        if (this.entityTypeContactInfos == null) {
            return null;
        }
        for (EntityTypeContactInfoDefault entType : this.entityTypeContactInfos) {
            if (!entType.getEntityTypeCode().equals(entityTypeCode)) continue;
            return entType;
        }
        return null;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/EntityDefaultType";
    }

    static class Elements {
        static final String ENTITY_ID = "entityId";
        static final String NAME = "name";
        static final String PRINCIPALS = "principals";
        static final String PRINCIPAL = "principal";
        static final String ENTITY_TYPE_CONTACT_INFOS = "entityTypeContactInfos";
        static final String ENTITY_TYPE_CONTACT_INFO = "entityTypeContactInfo";
        static final String AFFILIATIONS = "affiliations";
        static final String AFFILIATION = "affiliation";
        static final String DEFAULT_AFFILIATION = "defaultAffiliation";
        static final String EMPLOYMENT = "employment";
        static final String EXTERNAL_IDENTIFIERS = "externalIdentifiers";
        static final String EXTERNAL_IDENTIFIER = "externalIdentifier";
        static final String PRIVACY_PREFERENCES = "privacyPreferences";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityDefault";
        static final String TYPE_NAME = "EntityDefaultType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder {
        private String entityId;
        private EntityName.Builder name;
        private List<Principal.Builder> principals;
        private List<EntityTypeContactInfoDefault.Builder> entityTypeContactInfos;
        private List<EntityAffiliation.Builder> affiliations;
        private EntityAffiliation.Builder defaultAffiliation;
        private EntityEmployment.Builder employment;
        private List<EntityExternalIdentifier.Builder> externalIdentifiers;
        private EntityPrivacyPreferences.Builder privacyPreferences;
        private boolean active;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(String entityId) {
            Builder builder = new Builder();
            builder.setEntityId(entityId);
            return builder;
        }

        public static Builder create(EntityContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = new Builder();
            builder.setEntityId(contract.getId());
            builder.setActive(contract.isActive());
            ArrayList<Principal.Builder> principalBuilders = new ArrayList<Principal.Builder>();
            for (PrincipalContract principalContract : contract.getPrincipals()) {
                principalBuilders.add(Principal.Builder.create(principalContract));
            }
            builder.setPrincipals(principalBuilders);
            builder.setPrivacyPreferences(contract.getPrivacyPreferences() == null ? EntityPrivacyPreferences.Builder.create(contract.getId()) : EntityPrivacyPreferences.Builder.create(contract.getPrivacyPreferences()));
            builder.setName(contract.getDefaultName() == null ? null : EntityName.Builder.create(contract.getDefaultName()));
            ArrayList<EntityTypeContactInfoDefault.Builder> typeBuilders = new ArrayList<EntityTypeContactInfoDefault.Builder>();
            for (EntityTypeContactInfoContract entityTypeContactInfoContract : contract.getEntityTypeContactInfos()) {
                typeBuilders.add(EntityTypeContactInfoDefault.Builder.create(entityTypeContactInfoContract));
            }
            builder.setEntityTypeContactInfos(typeBuilders);
            ArrayList<EntityAffiliation.Builder> arrayList = new ArrayList<EntityAffiliation.Builder>();
            for (EntityAffiliationContract entityAffiliationContract : contract.getAffiliations()) {
                if (!entityAffiliationContract.isActive()) continue;
                arrayList.add(EntityAffiliation.Builder.create(entityAffiliationContract));
                if (!entityAffiliationContract.isDefaultValue()) continue;
                builder.setDefaultAffiliation(EntityAffiliation.Builder.create(entityAffiliationContract));
            }
            builder.setAffiliations(arrayList);
            builder.setEmployment(contract.getPrimaryEmployment() == null ? null : EntityEmployment.Builder.create(contract.getPrimaryEmployment()));
            ArrayList<EntityExternalIdentifier.Builder> arrayList2 = new ArrayList<EntityExternalIdentifier.Builder>();
            for (EntityExternalIdentifierContract entityExternalIdentifierContract : contract.getExternalIdentifiers()) {
                arrayList2.add(EntityExternalIdentifier.Builder.create(entityExternalIdentifierContract));
            }
            builder.setExternalIdentifiers(arrayList2);
            return builder;
        }

        public EntityDefault build() {
            return new EntityDefault(this);
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public EntityName.Builder getName() {
            return this.name;
        }

        public void setName(EntityName.Builder name) {
            this.name = name;
        }

        public List<Principal.Builder> getPrincipals() {
            return this.principals;
        }

        public void setPrincipals(List<Principal.Builder> principals) {
            this.principals = principals;
        }

        public List<EntityTypeContactInfoDefault.Builder> getEntityTypeContactInfos() {
            return this.entityTypeContactInfos;
        }

        public void setEntityTypeContactInfos(List<EntityTypeContactInfoDefault.Builder> entityTypeContactInfos) {
            this.entityTypeContactInfos = entityTypeContactInfos;
        }

        public List<EntityAffiliation.Builder> getAffiliations() {
            return this.affiliations;
        }

        public void setAffiliations(List<EntityAffiliation.Builder> affiliations) {
            this.affiliations = affiliations;
        }

        public EntityAffiliation.Builder getDefaultAffiliation() {
            return this.defaultAffiliation;
        }

        public void setDefaultAffiliation(EntityAffiliation.Builder defaultAffiliation) {
            this.defaultAffiliation = defaultAffiliation;
        }

        public EntityEmployment.Builder getEmployment() {
            return this.employment;
        }

        public void setEmployment(EntityEmployment.Builder employment) {
            this.employment = employment;
        }

        public List<EntityExternalIdentifier.Builder> getExternalIdentifiers() {
            return this.externalIdentifiers;
        }

        public void setExternalIdentifiers(List<EntityExternalIdentifier.Builder> externalIdentifiers) {
            this.externalIdentifiers = externalIdentifiers;
        }

        public EntityPrivacyPreferences.Builder getPrivacyPreferences() {
            return this.privacyPreferences;
        }

        public void setPrivacyPreferences(EntityPrivacyPreferences.Builder privacyPreferences) {
            this.privacyPreferences = privacyPreferences;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

