/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectComplete;
import org.kuali.rice.core.api.mo.common.active.InactivatableFromToUtils;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.role.RoleResponsibilityActionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="roleMember")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RoleMemberType", propOrder={"id", "roleId", "attributes", "roleResponsibilityActions", "memberId", "typeCode", "memberName", "memberNamespaceCode", "activeFromDate", "activeToDate", "versionNumber", "objectId", "_futureElements"})
public class RoleMember
extends AbstractDataTransferObject
implements RoleMemberContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="roleId", required=true)
    private final String roleId;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElementWrapper(name="roleResponsibilityActions", required=false)
    @XmlElement(name="roleResponsibilityAction", required=false)
    private final List<RoleResponsibilityAction> roleResponsibilityActions;
    @XmlElement(name="memberId", required=true)
    private final String memberId;
    @XmlElement(name="typeCode", required=true)
    private final String typeCode;
    @XmlElement(name="memberName", required=true)
    private final String memberName;
    @XmlElement(name="memberNamespaceCode", required=true)
    private final String memberNamespaceCode;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="activeFromDate", required=false)
    private final DateTime activeFromDate;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="activeToDate", required=false)
    private final DateTime activeToDate;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RoleMember() {
        this.id = null;
        this.roleId = null;
        this.attributes = null;
        this.roleResponsibilityActions = null;
        this.memberId = null;
        this.typeCode = null;
        this.memberName = null;
        this.memberNamespaceCode = null;
        this.activeFromDate = null;
        this.activeToDate = null;
        this.versionNumber = null;
        this.objectId = null;
    }

    private RoleMember(Builder b) {
        this.id = b.getId();
        this.roleId = b.getRoleId();
        this.attributes = b.getAttributes();
        ArrayList<RoleResponsibilityAction> roleResponsibilityActions = new ArrayList<RoleResponsibilityAction>();
        if (!CollectionUtils.isEmpty(b.getRoleRspActions())) {
            for (RoleResponsibilityAction.Builder rraBuilder : b.getRoleRspActions()) {
                roleResponsibilityActions.add(rraBuilder.build());
            }
        }
        this.roleResponsibilityActions = roleResponsibilityActions;
        this.memberId = b.getMemberId();
        this.typeCode = b.getType().getCode();
        this.memberName = b.getMemberName();
        this.memberNamespaceCode = b.getMemberNamespaceCode();
        this.activeFromDate = b.getActiveFromDate();
        this.activeToDate = b.getActiveToDate();
        this.versionNumber = b.getVersionNumber();
        this.objectId = b.getObjectId();
    }

    @Override
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public MemberType getType() {
        return MemberType.fromCode((String)this.typeCode);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<RoleResponsibilityAction> getRoleRspActions() {
        return this.roleResponsibilityActions;
    }

    public DateTime getActiveFromDate() {
        return this.activeFromDate;
    }

    public DateTime getActiveToDate() {
        return this.activeToDate;
    }

    public boolean isActive(DateTime activeAsOfDate) {
        return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, (DateTime)activeAsOfDate);
    }

    public boolean isActive() {
        return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, null);
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public String getMemberNamespaceCode() {
        return this.memberNamespaceCode;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/RoleMemberType";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "roleMember";
        static final String TYPE_NAME = "RoleMemberType";

        Constants() {
        }
    }

    static class Elements {
        static final String ID = "id";
        static final String ROLE_ID = "roleId";
        static final String ATTRIBUTES = "attributes";
        static final String ROLE_RESPONSIBILITY_ACTIONS = "roleResponsibilityActions";
        static final String ROLE_RESPONSIBILITY_ACTION = "roleResponsibilityAction";
        static final String MEMBER_ID = "memberId";
        static final String TYPE_CODE = "typeCode";
        static final String MEMBER_NAME = "memberName";
        static final String MEMBER_NAMESPACE_CODE = "memberNamespaceCode";

        Elements() {
        }
    }

    public static final class Builder
    implements ModelBuilder,
    RoleMemberContract,
    ModelObjectComplete {
        private String id;
        private String roleId;
        private Map<String, String> attributes;
        private List<RoleResponsibilityAction.Builder> roleRspActions;
        private String memberId;
        private MemberType type;
        private DateTime activeFromDate;
        private DateTime activeToDate;
        private Long versionNumber;
        private String objectId;
        private String memberName;
        private String memberNamespaceCode;

        private Builder(String roleId, String memberId, MemberType type) {
            this.setRoleId(roleId);
            this.setMemberId(memberId);
            this.setType(type);
        }

        public static Builder create(String roleId, String id, String memberId, MemberType memberType, DateTime activeFromDate, DateTime activeToDate, Map<String, String> attributes, String memberName, String memberNamespaceCode) {
            Builder b = new Builder(roleId, memberId, memberType);
            b.setId(id);
            b.setActiveFromDate(activeFromDate);
            b.setActiveToDate(activeToDate);
            b.setAttributes(attributes);
            b.setMemberName(memberName);
            b.setMemberNamespaceCode(memberNamespaceCode);
            return b;
        }

        public static Builder create(RoleMemberContract contract) {
            Builder b = new Builder(contract.getRoleId(), contract.getMemberId(), contract.getType());
            b.setId(contract.getId());
            b.setAttributes(contract.getAttributes());
            ArrayList<RoleResponsibilityAction.Builder> rraBuilders = new ArrayList<RoleResponsibilityAction.Builder>();
            if (!CollectionUtils.isEmpty(contract.getRoleRspActions())) {
                for (RoleResponsibilityActionContract roleResponsibilityActionContract : contract.getRoleRspActions()) {
                    rraBuilders.add(RoleResponsibilityAction.Builder.create(roleResponsibilityActionContract));
                }
            }
            b.setRoleRspActions(rraBuilders);
            b.setActiveFromDate(contract.getActiveFromDate());
            b.setActiveToDate(contract.getActiveToDate());
            b.setMemberName(contract.getMemberName());
            b.setMemberNamespaceCode(contract.getMemberNamespaceCode());
            b.setVersionNumber(contract.getVersionNumber());
            b.setObjectId(contract.getObjectId());
            return b;
        }

        public RoleMember build() {
            return new RoleMember(this);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            if (StringUtils.isEmpty((String)roleId)) {
                throw new IllegalArgumentException("roleId is empty");
            }
            this.roleId = roleId;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public List<RoleResponsibilityAction.Builder> getRoleRspActions() {
            return this.roleRspActions;
        }

        public void setRoleRspActions(List<RoleResponsibilityAction.Builder> roleRspActions) {
            this.roleRspActions = roleRspActions;
        }

        @Override
        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            if (StringUtils.isBlank((String)memberId)) {
                throw new IllegalArgumentException("memberId may not be null");
            }
            this.memberId = memberId;
        }

        @Override
        public MemberType getType() {
            return this.type;
        }

        @Override
        public String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public String getMemberNamespaceCode() {
            return this.memberNamespaceCode;
        }

        public void setMemberNamespaceCode(String memberNamespaceCode) {
            this.memberNamespaceCode = memberNamespaceCode;
        }

        public void setType(MemberType type) {
            if (type == null) {
                throw new IllegalArgumentException("type is null");
            }
            this.type = type;
        }

        public DateTime getActiveFromDate() {
            return this.activeFromDate;
        }

        public void setActiveFromDate(DateTime activeFromDate) {
            this.activeFromDate = activeFromDate;
        }

        public DateTime getActiveToDate() {
            return this.activeToDate;
        }

        public void setActiveToDate(DateTime activeToDate) {
            this.activeToDate = activeToDate;
        }

        public boolean isActive(DateTime activeAsOfDate) {
            return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, (DateTime)activeAsOfDate);
        }

        public boolean isActive() {
            return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, null);
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

