/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.common.template.TemplateContract;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityAttributeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityTemplateBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_RSP_T")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class ResponsibilityBo
extends DataObjectBase
implements ResponsibilityContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_RSP_ID_S")
    @GeneratedValue(generator="KRIM_RSP_ID_S")
    @Id
    @Column(name="RSP_ID")
    String id;
    @Column(name="NMSPC_CD")
    String namespaceCode;
    @Column(name="NM")
    String name;
    @Column(name="DESC_TXT")
    String description;
    @Column(name="RSP_TMPL_ID")
    String templateId;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    boolean active;
    @JoinFetch(value=JoinFetchType.OUTER)
    @ManyToOne(targetEntity=ResponsibilityTemplateBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="RSP_TMPL_ID", referencedColumnName="RSP_TMPL_ID", insertable=false, updatable=false)
    ResponsibilityTemplateBo template = new ResponsibilityTemplateBo();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=ResponsibilityAttributeBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="RSP_ID", referencedColumnName="RSP_ID")
    List<ResponsibilityAttributeBo> attributeDetails = new AutoPopulatingList(ResponsibilityAttributeBo.class);
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(mappedBy="kimResponsibility")
    @JoinColumn(name="RSP_ID", referencedColumnName="RSP_ID", insertable=false, updatable=false)
    List<RoleResponsibilityBo> roleResponsibilities = new AutoPopulatingList(RoleResponsibilityBo.class);
    @Transient
    Map<String, String> attributes;

    public Map<String, String> getAttributes() {
        return this._persistence_get_attributeDetails() != null ? KimAttributeDataBo.toAttributes(this._persistence_get_attributeDetails()) : this.attributes;
    }

    public static Responsibility to(ResponsibilityContract bo) {
        if (bo == null) {
            return null;
        }
        return Responsibility.Builder.create((ResponsibilityContract)bo).build();
    }

    public static ResponsibilityBo from(Responsibility im) {
        if (im == null) {
            return null;
        }
        ResponsibilityBo bo = new ResponsibilityBo();
        bo._persistence_set_id(im.getId());
        bo._persistence_set_namespaceCode(im.getNamespaceCode());
        bo._persistence_set_name(im.getName());
        bo._persistence_set_description(im.getDescription());
        bo._persistence_set_active(im.isActive());
        bo._persistence_set_templateId(im.getTemplate() != null ? im.getTemplate().getId() : null);
        bo._persistence_set_template(ResponsibilityTemplateBo.from((TemplateContract)im.getTemplate()));
        bo.attributes = im.getAttributes();
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        return bo;
    }

    public ResponsibilityTemplateBo getTemplate() {
        return this._persistence_get_template();
    }

    public String getDetailObjectsValues() {
        StringBuffer detailObjectsToDisplayBuffer = new StringBuffer();
        Iterator respIter = this._persistence_get_attributeDetails().iterator();
        while (respIter.hasNext()) {
            ResponsibilityAttributeBo respAttributeData = (ResponsibilityAttributeBo)((Object)respIter.next());
            detailObjectsToDisplayBuffer.append(respAttributeData.getAttributeValue());
            if (!respIter.hasNext()) continue;
            detailObjectsToDisplayBuffer.append(", ");
        }
        return detailObjectsToDisplayBuffer.toString();
    }

    public String getDetailObjectsToDisplay() {
        KimType kimType = this.getTypeInfoService().getKimType(this.getTemplate().getKimTypeId());
        StringBuffer detailObjects = new StringBuffer();
        Iterator respIter = this._persistence_get_attributeDetails().iterator();
        while (respIter.hasNext()) {
            ResponsibilityAttributeBo bo = (ResponsibilityAttributeBo)((Object)respIter.next());
            detailObjects.append(this.getKimAttributeLabelFromDD(kimType.getAttributeDefinitionById(bo.getKimAttributeId()))).append(":").append(bo.getAttributeValue());
            if (!respIter.hasNext()) continue;
            detailObjects.append(", ");
        }
        return detailObjects.toString();
    }

    private String getKimAttributeLabelFromDD(KimTypeAttribute attribute) {
        return this.getDataDictionaryService().getAttributeLabel(attribute.getKimAttribute().getComponentName(), attribute.getKimAttribute().getAttributeName());
    }

    private DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    private KimTypeInfoService getTypeInfoService() {
        return KimApiServiceLocator.getKimTypeInfoService();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getTemplateId() {
        return this._persistence_get_templateId();
    }

    public void setTemplateId(String templateId) {
        this._persistence_set_templateId(templateId);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setTemplate(ResponsibilityTemplateBo template) {
        this._persistence_set_template(template);
    }

    public List<ResponsibilityAttributeBo> getAttributeDetails() {
        return this._persistence_get_attributeDetails();
    }

    public void setAttributeDetails(List<ResponsibilityAttributeBo> attributeDetails) {
        this._persistence_set_attributeDetails(attributeDetails);
    }

    public List<RoleResponsibilityBo> getRoleResponsibilities() {
        return this._persistence_get_roleResponsibilities();
    }

    public void setRoleResponsibilities(List<RoleResponsibilityBo> roleResponsibilities) {
        this._persistence_set_roleResponsibilities(roleResponsibilities);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ResponsibilityBo();
    }

    public Object _persistence_get(String string) {
        if (string == "template") {
            return this.template;
        }
        if (string == "roleResponsibilities") {
            return this.roleResponsibilities;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        if (string == "attributeDetails") {
            return this.attributeDetails;
        }
        if (string == "templateId") {
            return this.templateId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "template") {
            this.template = (ResponsibilityTemplateBo)((Object)object);
            return;
        }
        if (string == "roleResponsibilities") {
            this.roleResponsibilities = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        if (string == "attributeDetails") {
            this.attributeDetails = (List)object;
            return;
        }
        if (string == "templateId") {
            this.templateId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public ResponsibilityTemplateBo _persistence_get_template() {
        this._persistence_checkFetched("template");
        return this.template;
    }

    public void _persistence_set_template(ResponsibilityTemplateBo responsibilityTemplateBo) {
        this._persistence_checkFetchedForSet("template");
        this._persistence_propertyChange("template", (Object)this.template, (Object)responsibilityTemplateBo);
        this.template = responsibilityTemplateBo;
    }

    public List _persistence_get_roleResponsibilities() {
        this._persistence_checkFetched("roleResponsibilities");
        return this.roleResponsibilities;
    }

    public void _persistence_set_roleResponsibilities(List list) {
        this._persistence_checkFetchedForSet("roleResponsibilities");
        this._persistence_propertyChange("roleResponsibilities", this.roleResponsibilities, list);
        this.roleResponsibilities = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this._persistence_propertyChange("namespaceCode", this.namespaceCode, string);
        this.namespaceCode = string;
    }

    public List _persistence_get_attributeDetails() {
        this._persistence_checkFetched("attributeDetails");
        return this.attributeDetails;
    }

    public void _persistence_set_attributeDetails(List list) {
        this._persistence_checkFetchedForSet("attributeDetails");
        this._persistence_propertyChange("attributeDetails", this.attributeDetails, list);
        this.attributeDetails = list;
    }

    public String _persistence_get_templateId() {
        this._persistence_checkFetched("templateId");
        return this.templateId;
    }

    public void _persistence_set_templateId(String string) {
        this._persistence_checkFetchedForSet("templateId");
        this._persistence_propertyChange("templateId", this.templateId, string);
        this.templateId = string;
    }
}

