/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.RoleResponsibility;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class ResponsibilityInternalServiceImpl
implements ResponsibilityInternalService {
    protected DataObjectService dataObjectService;
    protected ResponsibilityService responsibilityService;
    protected DateTimeService dateTimeService;

    @Override
    public RoleMemberBo saveRoleMember(RoleMemberBo roleMember) {
        List<RoleResponsibility> oldRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        RoleMemberBo member = (RoleMemberBo)((Object)this.dataObjectService.save((Object)roleMember, new PersistenceOption[]{PersistenceOption.FLUSH}));
        List<RoleResponsibility> newRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        this.updateActionRequestsForResponsibilityChange(this.getChangedRoleResponsibilityIds(oldRoleResp, newRoleResp));
        return member;
    }

    @Override
    public DelegateMemberBo saveDelegateMember(DelegateMemberBo delegateMember) {
        DelegateMemberBo member = (DelegateMemberBo)((Object)this.dataObjectService.save((Object)delegateMember, new PersistenceOption[]{PersistenceOption.FLUSH}));
        return member;
    }

    @Override
    public void removeRoleMember(RoleMemberBo roleMember) {
        List<RoleResponsibility> oldRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        roleMember.setActiveToDateValue(this.dateTimeService.getCurrentTimestamp());
        roleMember = (RoleMemberBo)((Object)this.dataObjectService.save((Object)roleMember, new PersistenceOption[]{PersistenceOption.FLUSH}));
        KimApiServiceLocator.getRoleService().notifyOnMemberRemoval(RoleMemberBo.to(roleMember));
        List<RoleResponsibility> newRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        this.updateActionRequestsForResponsibilityChange(this.getChangedRoleResponsibilityIds(oldRoleResp, newRoleResp));
    }

    @Override
    public void updateActionRequestsForRoleChange(String roleId) {
        List<RoleResponsibility> newRoleResp = this.getRoleResponsibilities(roleId);
        this.updateActionRequestsForResponsibilityChange(this.getChangedRoleResponsibilityIds(Collections.EMPTY_LIST, newRoleResp));
    }

    @Override
    public void updateActionRequestsForResponsibilityChange(Set<String> responsibilityIds) {
        KewApiServiceLocator.getResponsibilityChangeQueue().responsibilitiesChanged(responsibilityIds);
    }

    @Override
    public List<RoleResponsibility> getRoleResponsibilities(String roleId) {
        List rrBoList = this.dataObjectService.findMatching(RoleResponsibilityBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleId", (Object)roleId), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)})).getResults();
        ArrayList<RoleResponsibility> result = new ArrayList<RoleResponsibility>(rrBoList.size());
        for (RoleResponsibilityBo bo : rrBoList) {
            result.add(RoleResponsibilityBo.to(bo));
        }
        return result;
    }

    protected Set<String> getChangedRoleResponsibilityIds(List<RoleResponsibility> oldRespList, List<RoleResponsibility> newRespList) {
        HashSet<String> lRet = new HashSet<String>();
        for (RoleResponsibility resp : oldRespList) {
            lRet.add(resp.getResponsibilityId());
        }
        for (RoleResponsibility resp : newRespList) {
            lRet.add(resp.getResponsibilityId());
        }
        return lRet;
    }

    @Override
    public boolean areActionsAtAssignmentLevel(Responsibility responsibility) {
        Map details = responsibility.getAttributes();
        if (details == null) {
            return false;
        }
        String actionDetailsAtRoleMemberLevel = StringUtils.trimToEmpty((String)((String)details.get("actionDetailsAtRoleMemberLevel")));
        return Truth.strToBooleanIgnoreCase((String)actionDetailsAtRoleMemberLevel, (Boolean)Boolean.FALSE);
    }

    @Override
    public boolean areActionsAtAssignmentLevelById(String responsibilityId) {
        Responsibility responsibility = this.responsibilityService.getResponsibility(responsibilityId);
        if (responsibility == null) {
            return false;
        }
        return this.areActionsAtAssignmentLevel(responsibility);
    }

    public void setResponsibilityService(ResponsibilityService responsibilityService) {
        this.responsibilityService = responsibilityService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

