/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.role.RoleDao;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class RoleDaoJdbc
implements RoleDao {
    protected DataSource dataSource;

    @Override
    public List<RoleMemberBo> getRoleMembersForRoleIds(Collection<String> roleIds, String memberTypeCode, Map<String, String> qualification) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        final ArrayList<String> roleIDs = new ArrayList<String>(roleIds);
        final String memberTypeCd = memberTypeCode;
        final Map<String, String> qual = qualification;
        final ArrayList<RoleMemberBo> roleMemberBos = new ArrayList<RoleMemberBo>();
        template.execute(new PreparedStatementCreator(){

            /*
             * WARNING - void declaration
             */
            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                StringBuilder sql1 = new StringBuilder("SELECT  A0.ROLE_MBR_ID AS ROLE_MBR_ID,A0.ROLE_ID AS ROLE_ID,A0.MBR_ID AS MBR_ID,A0.MBR_TYP_CD AS MBR_TYP_CD,A0.VER_NBR AS ROLE_MBR_VER_NBR,A0.OBJ_ID AS ROLE_MBR_OBJ_ID,A0.ACTV_FRM_DT AS ROLE_MBR_ACTV_FRM_DT ,A0.ACTV_TO_DT AS ROLE_MBR_ACTV_TO_DT,  BO.KIM_TYP_ID AS KIM_TYP_ID, BO.KIM_ATTR_DEFN_ID AS KIM_ATTR_DEFN_ID, BO.ATTR_VAL AS ATTR_VAL, BO.ATTR_DATA_ID AS ATTR_DATA_ID, BO.OBJ_ID AS ATTR_DATA_OBJ_ID, BO.VER_NBR AS ATTR_DATA_VER_NBR,   C0.KIM_ATTR_DEFN_ID AS KIM_ATTR_DEFN_ID, C0.OBJ_ID AS ATTR_DEFN_OBJ_ID, C0.VER_NBR as ATTR_DEFN_VER_NBR, C0.NM AS ATTR_NAME, C0.LBL as ATTR_DEFN_LBL, C0.ACTV_IND as ATTR_DEFN_ACTV_IND, C0.NMSPC_CD AS ATTR_DEFN_NMSPC_CD, C0.CMPNT_NM AS ATTR_DEFN_CMPNT_NM  FROM KRIM_ROLE_MBR_T A0 JOIN KRIM_ROLE_MBR_ATTR_DATA_T BO ON A0.ROLE_MBR_ID = BO.ROLE_MBR_ID  JOIN KRIM_ATTR_DEFN_T C0 ON BO.KIM_ATTR_DEFN_ID = C0.KIM_ATTR_DEFN_ID  ");
                StringBuilder sql2 = new StringBuilder("SELECT D0.ROLE_MBR_ID AS ROLE_MBR_ID,D0.ROLE_ID AS ROLE_ID,D0.MBR_ID AS MBR_ID,D0.MBR_TYP_CD AS MBR_TYP_CD,D0.VER_NBR AS ROLE_MBR_VER_NBR,D0.OBJ_ID AS ROLE_MBR_OBJ_ID,D0.ACTV_FRM_DT AS ROLE_MBR_ACTV_FRM_DT ,D0.ACTV_TO_DT AS ROLE_MBR_ACTV_TO_DT,  '' AS KIM_TYP_ID, '' AS KIM_ATTR_DEFN_ID, '' AS ATTR_VAL, '' AS ATTR_DATA_ID, '' AS ATTR_DATA_OBJ_ID, NULL AS ATTR_DATA_VER_NBR, '' AS KIM_ATTR_DEFN_ID,'' AS ATTR_DEFN_OBJ_ID, NULL as ATTR_DEFN_VER_NBR, '' AS ATTR_NAME, '' as ATTR_DEFN_LBL, '' as ATTR_DEFN_ACTV_IND, '' AS ATTR_DEFN_NMSPC_CD, '' AS ATTR_DEFN_CMPNT_NM  FROM KRIM_ROLE_MBR_T D0  WHERE D0.ROLE_MBR_ID NOT IN (SELECT DISTINCT (E0.ROLE_MBR_ID) FROM KRIM_ROLE_MBR_ATTR_DATA_T E0)");
                StringBuilder criteria = new StringBuilder();
                ArrayList<String> params1 = new ArrayList<String>();
                ArrayList<String> params2 = new ArrayList<String>();
                if (roleIDs != null && !roleIDs.isEmpty()) {
                    criteria.append("A0.ROLE_ID IN (");
                    for (Object roleId : roleIDs) {
                        criteria.append("?,");
                        params1.add((String)roleId);
                        params2.add((String)roleId);
                    }
                    criteria.deleteCharAt(criteria.length() - 1);
                    criteria.append(")");
                }
                if (memberTypeCd != null) {
                    if (criteria.length() > 0) {
                        criteria.append(" AND ");
                    }
                    criteria.append("A0.MBR_TYP_CD = ?");
                    params1.add(memberTypeCd);
                    params2.add(memberTypeCd);
                }
                if (criteria.length() > 0) {
                    sql1.append(" WHERE ");
                    sql2.append(" AND ");
                    sql1.append((CharSequence)criteria);
                    sql2.append(criteria.toString().replaceAll("A0", "D0"));
                }
                if (qual != null && CollectionUtils.isNotEmpty(qual.keySet())) {
                    sql2 = new StringBuilder();
                    if (criteria.length() > 0) {
                        sql1.append(" AND ");
                    } else {
                        sql1.append(" WHERE ");
                    }
                    sql1.append(" EXISTS (SELECT B1.ROLE_MBR_ID FROM KRIM_ROLE_MBR_ATTR_DATA_T B1 WHERE ");
                    int conditionCount = 0;
                    for (Map.Entry entry : qual.entrySet()) {
                        if (StringUtils.isNotEmpty((String)((String)entry.getValue()))) {
                            if (++conditionCount == 1) {
                                sql1.append("(");
                            }
                            String value = ((String)entry.getValue()).replace('*', '%');
                            sql1.append(" (B1.ATTR_VAL LIKE ? AND B1.KIM_ATTR_DEFN_ID = ?) ");
                            params1.add(value);
                            params1.add((String)entry.getKey());
                        }
                        sql1.append("OR");
                    }
                    sql1.delete(sql1.length() - 2, sql1.length());
                    if (conditionCount != 0) {
                        sql1.append(") AND");
                    }
                    sql1.append(" B1.ROLE_MBR_ID = A0.ROLE_MBR_ID)");
                }
                StringBuilder sql = new StringBuilder(sql1.toString());
                if (sql2.length() > 0) {
                    sql.append(" UNION ALL ");
                    sql.append(sql2.toString());
                }
                sql.append(" ORDER BY ROLE_MBR_ID ");
                PreparedStatement statement = connection.prepareStatement(sql.toString());
                boolean bl = true;
                for (String param : params1) {
                    void var9_12;
                    statement.setString((int)var9_12, param);
                    ++var9_12;
                }
                if (sql2.length() > 0) {
                    for (String param : params2) {
                        void var9_13;
                        statement.setString((int)var9_13, param);
                        ++var9_13;
                    }
                }
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<RoleMemberBo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<RoleMemberBo> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                try (ResultSet rs = statement.executeQuery();){
                    RoleMemberBo lastRoleMember = null;
                    while (rs.next()) {
                        DateTime activeToDate;
                        boolean processRolemember = true;
                        String roleId = rs.getString("ROLE_ID");
                        String id = rs.getString("ROLE_MBR_ID");
                        String memberId = rs.getString("MBR_ID");
                        MemberType memberType = MemberType.fromCode((String)rs.getString("MBR_TYP_CD"));
                        DateTime activeFromDate = rs.getDate("ROLE_MBR_ACTV_FRM_DT") == null ? null : new DateTime((Object)rs.getDate("ROLE_MBR_ACTV_FRM_DT"));
                        DateTime dateTime = activeToDate = rs.getDate("ROLE_MBR_ACTV_TO_DT") == null ? null : new DateTime((Object)rs.getDate("ROLE_MBR_ACTV_TO_DT"));
                        if (lastRoleMember == null || !id.equals(lastRoleMember.getId())) {
                            RoleMember roleMember = RoleMember.Builder.create((String)roleId, (String)id, (String)memberId, (MemberType)memberType, (DateTime)activeFromDate, (DateTime)activeToDate, new HashMap(), (String)"", (String)"").build();
                            Long roleVersionNbr = rs.getLong("ROLE_MBR_VER_NBR");
                            String roleObjId = rs.getString("ROLE_MBR_OBJ_ID");
                            RoleMemberBo roleMemberBo = RoleMemberBo.from(roleMember);
                            roleMemberBo.setVersionNumber(roleVersionNbr);
                            roleMemberBo.setObjectId(roleObjId);
                            ArrayList<RoleMemberAttributeDataBo> roleMemAttrBos = new ArrayList<RoleMemberAttributeDataBo>();
                            roleMemberBo.setAttributeDetails(roleMemAttrBos);
                            if (roleMemberBo.isActive(new Timestamp(System.currentTimeMillis()))) {
                                roleMemberBos.add(roleMemberBo);
                            } else {
                                processRolemember = false;
                            }
                            lastRoleMember = roleMemberBo;
                        }
                        String kimTypeId = rs.getString("KIM_TYP_ID");
                        if (!processRolemember || !StringUtils.isNotEmpty((String)kimTypeId)) continue;
                        KimType theType = KimApiServiceLocator.getKimTypeInfoService().getKimType(kimTypeId);
                        RoleMemberAttributeDataBo roleMemAttrDataBo = new RoleMemberAttributeDataBo();
                        KimAttribute.Builder attrBuilder = KimAttribute.Builder.create((String)rs.getString("ATTR_DEFN_CMPNT_NM"), (String)rs.getString("ATTR_NAME"), (String)rs.getString("ATTR_DEFN_NMSPC_CD"));
                        attrBuilder.setActive(Truth.strToBooleanIgnoreCase((String)rs.getString("ATTR_DEFN_ACTV_IND")).booleanValue());
                        attrBuilder.setAttributeLabel(rs.getString("ATTR_DEFN_LBL"));
                        attrBuilder.setId(rs.getString("KIM_ATTR_DEFN_ID"));
                        attrBuilder.setObjectId(rs.getString("ATTR_DEFN_OBJ_ID"));
                        attrBuilder.setVersionNumber(Long.valueOf(rs.getLong("ATTR_DEFN_VER_NBR")));
                        roleMemAttrDataBo.setId(rs.getString("ATTR_DATA_ID"));
                        roleMemAttrDataBo.setAssignedToId(id);
                        roleMemAttrDataBo.setKimTypeId(kimTypeId);
                        roleMemAttrDataBo.setKimType(KimTypeBo.from(theType));
                        roleMemAttrDataBo.setKimAttributeId(attrBuilder.getId());
                        roleMemAttrDataBo.setAttributeValue(rs.getString("ATTR_VAL"));
                        roleMemAttrDataBo.setVersionNumber(attrBuilder.getVersionNumber());
                        roleMemAttrDataBo.setObjectId(attrBuilder.getObjectId());
                        roleMemAttrDataBo.setKimAttribute(KimAttributeBo.from(attrBuilder.build()));
                        lastRoleMember.getAttributeDetails().add(roleMemAttrDataBo);
                    }
                }
                return roleMemberBos;
            }
        });
        return roleMemberBos;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
    }
}

