/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.apache.pdfbox.util.Hex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FDFAnnotationStamp
extends FDFAnnotation {
    private static final Log LOG = LogFactory.getLog(FDFAnnotationStamp.class);
    public static final String SUBTYPE = "Stamp";

    public FDFAnnotationStamp() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationStamp(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationStamp(Element element) throws IOException {
        super(element);
        byte[] decodedAppearanceXML;
        String base64EncodedAppearance;
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        XPath xpath = XPathFactory.newInstance().newXPath();
        LOG.debug((Object)"Get the DOM Document for the stamp appearance");
        try {
            base64EncodedAppearance = xpath.evaluate("appearance", element);
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)("Error while evaluating XPath expression for appearance: " + e));
            return;
        }
        try {
            decodedAppearanceXML = Hex.decodeBase64(base64EncodedAppearance);
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)"Bad base64 encoded appearance ignored", (Throwable)ex);
            return;
        }
        if (base64EncodedAppearance != null && !base64EncodedAppearance.isEmpty()) {
            Document stampAppearance = this.getStampAppearanceDocument(decodedAppearanceXML);
            Element appearanceEl = stampAppearance.getDocumentElement();
            if (!"dict".equalsIgnoreCase(appearanceEl.getNodeName())) {
                throw new IOException("Error while reading stamp document, root should be 'dict' and not '" + appearanceEl.getNodeName() + "'");
            }
            LOG.debug((Object)"Generate and set the appearance dictionary to the stamp annotation");
            this.annot.setItem(COSName.AP, (COSBase)this.parseStampAnnotationAppearanceXML(appearanceEl));
        }
    }

    private Document getStampAppearanceDocument(byte[] xml) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(xml));
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)("Error while converting appearance xml to document: " + ex));
            throw new IOException(ex);
        }
        catch (SAXException ex) {
            LOG.error((Object)("Error while converting appearance xml to document: " + ex));
            throw new IOException(ex);
        }
    }

    private COSDictionary parseStampAnnotationAppearanceXML(Element appearanceXML) throws IOException {
        COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.N, (COSBase)new COSStream());
        LOG.debug((Object)"Build dictionary for Appearance based on the appearanceXML");
        NodeList nodeList = appearanceXML.getChildNodes();
        String parentAttrKey = appearanceXML.getAttribute("KEY");
        LOG.debug((Object)("Appearance Root - tag: " + appearanceXML.getTagName() + ", name: " + appearanceXML.getNodeName() + ", key: " + parentAttrKey + ", children: " + nodeList.getLength()));
        if (!"AP".equals(appearanceXML.getAttribute("KEY"))) {
            LOG.warn((Object)(parentAttrKey + " => Not handling element: " + appearanceXML.getTagName() + " with key: " + appearanceXML.getAttribute("KEY")));
            return dictionary;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if ("STREAM".equalsIgnoreCase(child.getTagName())) {
                LOG.debug((Object)(parentAttrKey + " => Process " + child.getAttribute("KEY") + " item in the dictionary after processing the " + child.getTagName()));
                dictionary.setItem(child.getAttribute("KEY"), (COSBase)this.parseStreamElement(child));
                LOG.debug((Object)(parentAttrKey + " => Set " + child.getAttribute("KEY")));
                continue;
            }
            LOG.warn((Object)(parentAttrKey + " => Not handling element: " + child.getTagName()));
        }
        return dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSStream parseStreamElement(Element streamEl) throws IOException {
        COSStream stream = new COSStream();
        NodeList nodeList = streamEl.getChildNodes();
        String parentAttrKey = streamEl.getAttribute("KEY");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            LOG.debug((Object)(parentAttrKey + " => reading child: " + child.getTagName() + " with key: " + childAttrKey));
            if ("INT".equalsIgnoreCase(child.getTagName())) {
                if ("Length".equals(childAttrKey)) continue;
                stream.setInt(COSName.getPDFName(childAttrKey), Integer.parseInt(childAttrVal));
                LOG.debug((Object)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("NAME".equalsIgnoreCase(child.getTagName())) {
                stream.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                LOG.debug((Object)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("BOOL".equalsIgnoreCase(child.getTagName())) {
                stream.setBoolean(COSName.getPDFName(childAttrKey), Boolean.parseBoolean(childAttrVal));
                LOG.debug((Object)(parentAttrKey + " => Set Interpolate: " + childAttrVal));
                continue;
            }
            if ("ARRAY".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseArrayElement(child));
                LOG.debug((Object)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("DICT".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                LOG.debug((Object)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("STREAM".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                LOG.debug((Object)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("DATA".equalsIgnoreCase(child.getTagName())) {
                LOG.debug((Object)(parentAttrKey + " => Handling DATA with encoding: " + child.getAttribute("ENCODING")));
                if ("HEX".equals(child.getAttribute("ENCODING"))) {
                    OutputStream os = null;
                    try {
                        os = stream.createRawOutputStream();
                        os.write(Hex.decodeHex(child.getTextContent()));
                        LOG.debug((Object)(parentAttrKey + " => Data was streamed"));
                        continue;
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                LOG.warn((Object)(parentAttrKey + " => Not handling element DATA encoding: " + child.getAttribute("ENCODING")));
                continue;
            }
            LOG.warn((Object)(parentAttrKey + " => Not handling child element: " + child.getTagName()));
        }
        return stream;
    }

    private COSArray parseArrayElement(Element arrayEl) throws IOException {
        LOG.debug((Object)("Parse " + arrayEl.getAttribute("KEY") + " Array"));
        COSArray array = new COSArray();
        NodeList nodeList = arrayEl.getElementsByTagName("FIXED");
        String elAttrKey = arrayEl.getAttribute("KEY");
        if ("BBox".equals(elAttrKey)) {
            if (nodeList.getLength() < 4) {
                throw new IOException("BBox does not have enough coordinates, only has: " + nodeList.getLength());
            }
        } else if ("Matrix".equals(elAttrKey) && nodeList.getLength() < 6) {
            throw new IOException("Matrix does not have enough coordinates, only has: " + nodeList.getLength());
        }
        LOG.debug((Object)("There are " + nodeList.getLength() + " FIXED elements"));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            LOG.debug((Object)(elAttrKey + " value(" + i + "): " + el.getAttribute("VAL")));
            array.add(new COSFloat(el.getAttribute("VAL")));
        }
        return array;
    }

    private COSDictionary parseDictElement(Element dictEl) throws IOException {
        LOG.debug((Object)("Parse " + dictEl.getAttribute("KEY") + " Dictionary"));
        COSDictionary dict = new COSDictionary();
        NodeList nodeList = dictEl.getChildNodes();
        String parentAttrKey = dictEl.getAttribute("KEY");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            if ("DICT".equals(child.getTagName())) {
                LOG.debug((Object)(parentAttrKey + " => Handling DICT element with key: " + childAttrKey));
                dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                LOG.debug((Object)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("STREAM".equals(child.getTagName())) {
                LOG.debug((Object)(parentAttrKey + " => Handling STREAM element with key: " + childAttrKey));
                dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                continue;
            }
            if ("NAME".equals(child.getTagName())) {
                LOG.debug((Object)(parentAttrKey + " => Handling NAME element with key: " + childAttrKey));
                dict.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                LOG.debug((Object)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            LOG.warn((Object)(parentAttrKey + " => NOT handling child element: " + child.getTagName()));
        }
        return dict;
    }
}

