/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.term;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.jdom2.IllegalAddException;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.BuilderUtils;
import org.kuali.rice.krms.api.repository.term.TermDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermParameterDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.w3c.dom.Element;

@XmlRootElement(name="termDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="termDefinitionType", propOrder={"id", "specification", "description", "parameters", "versionNumber", "_futureElements"})
public final class TermDefinition
extends AbstractDataTransferObject
implements TermDefinitionContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="specification", required=true)
    private final TermSpecificationDefinition specification;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElementWrapper(name="parameters", required=false)
    @XmlElement(name="parameter", required=false)
    private final List<TermParameterDefinition> parameters;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private TermDefinition() {
        this.id = null;
        this.specification = null;
        this.description = null;
        this.parameters = null;
        this.versionNumber = null;
    }

    private TermDefinition(Builder builder) {
        this.id = builder.getId();
        this.specification = builder.getSpecification().build();
        this.description = builder.getDescription();
        this.parameters = BuilderUtils.convertFromBuilderList(builder.getParameters());
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public TermSpecificationDefinition getSpecification() {
        return this.specification;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public List<TermParameterDefinition> getParameters() {
        return this.parameters;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/termDefinitionType";
    }

    static class Elements {
        public static final String ID = "id";
        public static final String SPECIFICATION = "specification";
        public static final String PARAMETERS = "parameters";
        public static final String DESCRIPTION = "description";

        Elements() {
        }
    }

    static class Constants {
        public static final String ROOT_ELEMENT_NAME = "termDefinition";
        public static final String TYPE_NAME = "termDefinitionType";

        Constants() {
        }
    }

    public static class Builder
    implements TermDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String description;
        private TermSpecificationDefinition.Builder specification;
        private List<TermParameterDefinition.Builder> parameters;
        private Long versionNumber;

        private Builder(String id, TermSpecificationDefinition.Builder termSpecificationDefinition, List<TermParameterDefinition.Builder> termParameters) {
            this.setId(id);
            this.setSpecification(termSpecificationDefinition);
            this.setParameters(termParameters);
        }

        public static Builder create(String id, TermSpecificationDefinition.Builder termSpecification, List<TermParameterDefinition.Builder> termParameters) {
            return new Builder(id, termSpecification, termParameters);
        }

        public static Builder create(TermDefinitionContract term) {
            if (term == null) {
                throw new IllegalAddException("term may not be null");
            }
            List<TermParameterDefinition.Builder> outParams = BuilderUtils.transform(term.getParameters(), TermParameterDefinition.Builder.toBuilder);
            Builder builder = Builder.create(term.getId(), TermSpecificationDefinition.Builder.create(term.getSpecification()), outParams);
            builder.setDescription(term.getDescription());
            builder.setVersionNumber(term.getVersionNumber());
            return builder;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setId(String id) {
            if (id != null && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id must contain non-whitespace chars");
            }
            this.id = id;
        }

        public void setSpecification(TermSpecificationDefinition.Builder termSpecification) {
            if (termSpecification == null) {
                throw new IllegalArgumentException("termSpecification must not be null");
            }
            this.specification = termSpecification;
        }

        public void setParameters(List<TermParameterDefinition.Builder> parameters) {
            this.parameters = parameters;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public TermSpecificationDefinition.Builder getSpecification() {
            return this.specification;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public List<TermParameterDefinition.Builder> getParameters() {
            return this.parameters;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public TermDefinition build() {
            return new TermDefinition(this);
        }
    }
}

