/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.File;
import java.io.FileWriter;
import org.apache.ddlutils.io.DataDtdWriter;
import org.apache.ddlutils.model.Database;
import org.apache.ojb.broker.ant.Command;
import org.apache.ojb.broker.ant.DdlUtilsDataHandling;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteDtdToFileCommand
extends Command {
    private File _outputFile;

    public void setOutputFile(File file) {
        this._outputFile = file;
    }

    public boolean isRequiringModel() {
        return true;
    }

    @Override
    public void execute(Task task, Database database, DescriptorRepository descriptorRepository) throws BuildException {
        if (this._outputFile == null) {
            throw new BuildException("No output file specified");
        }
        if (this._outputFile.exists() && !this._outputFile.canWrite()) {
            throw new BuildException("Cannot overwrite output file " + this._outputFile.getAbsolutePath());
        }
        try {
            FileWriter fileWriter = new FileWriter(this._outputFile);
            DataDtdWriter dataDtdWriter = new DataDtdWriter();
            DdlUtilsDataHandling ddlUtilsDataHandling = new DdlUtilsDataHandling();
            ddlUtilsDataHandling.setModel(database, descriptorRepository);
            ddlUtilsDataHandling.getDataDTD(fileWriter);
            fileWriter.close();
            task.log("Written DTD to " + this._outputFile.getAbsolutePath(), 2);
        }
        catch (Exception exception) {
            throw new BuildException("Failed to write to output file " + this._outputFile.getAbsolutePath(), (Throwable)exception);
        }
    }
}

