/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.CacheDistributor;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheDefaultImpl;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.cache.RuntimeCacheException;
import org.apache.ojb.broker.core.DelegatingPersistenceBroker;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheTwoLevelImpl
implements ObjectCacheInternal,
PBStateListener {
    private Logger log = LoggerFactory.getLogger(ObjectCacheTwoLevelImpl.class);
    public static final String APPLICATION_CACHE_PROP = "applicationCache";
    public static final String COPY_STRATEGY_PROP = "copyStrategy";
    public static final String FORCE_PROXIES = "forceProxies";
    private static final String DEF_COPY_STRATEGY = CopyStrategyImpl.class.getName();
    private static final String DEF_APP_CACHE = ObjectCacheDefaultImpl.class.getName();
    private HashMap sessionCache;
    private int invokeCounter;
    private ReferenceQueue queue = new ReferenceQueue();
    private ObjectCacheInternal applicationCache;
    private CopyStrategy copyStrategy;
    private PersistenceBrokerImpl broker;
    private boolean forceProxies = false;

    public ObjectCacheTwoLevelImpl(PersistenceBroker persistenceBroker, Properties properties) {
        if (persistenceBroker instanceof PersistenceBrokerImpl) {
            this.broker = (PersistenceBrokerImpl)persistenceBroker;
        } else if (persistenceBroker instanceof DelegatingPersistenceBroker) {
            this.broker = (PersistenceBrokerImpl)((DelegatingPersistenceBroker)persistenceBroker).getInnermostDelegate();
        } else {
            throw new RuntimeCacheException("Can't initialize two level cache, expect instance of" + PersistenceBrokerImpl.class + " or of " + DelegatingPersistenceBroker.class + " to setup application cache, but was " + persistenceBroker);
        }
        this.sessionCache = new HashMap(100);
        this.setupApplicationCache(this.broker, properties);
        persistenceBroker.addListener(this, true);
    }

    public PersistenceBrokerImpl getBroker() {
        return this.broker;
    }

    private void setupApplicationCache(PersistenceBrokerImpl persistenceBrokerImpl, Properties properties) {
        Class clazz;
        String string;
        String string2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start setup application cache for broker " + persistenceBrokerImpl);
        }
        if (properties == null) {
            properties = new Properties();
        }
        if ((string2 = properties.getProperty(COPY_STRATEGY_PROP, DEF_COPY_STRATEGY).trim()).length() == 0) {
            string2 = DEF_COPY_STRATEGY;
        }
        if ((string = properties.getProperty(APPLICATION_CACHE_PROP, DEF_APP_CACHE).trim()).length() == 0) {
            string = DEF_APP_CACHE;
        }
        String string3 = properties.getProperty(FORCE_PROXIES, "false").trim();
        this.forceProxies = Boolean.valueOf(string3);
        if (this.forceProxies && persistenceBrokerImpl.getProxyFactory().interfaceRequiredForProxyGeneration()) {
            this.log.warn("'forceProxies' is set to true, however a ProxyFactory implementation [" + persistenceBrokerImpl.getProxyFactory().getClass().getName() + "] " + " that requires persistent objects to implement an inteface is being used. Please ensure " + "that all persistent objects implement an interface, or change the ProxyFactory setting to a dynamic " + "proxy generator (like ProxyFactoryCGLIBImpl).");
        }
        Class[] classArray = new Class[]{PersistenceBroker.class, Properties.class};
        Object[] objectArray = new Object[]{persistenceBrokerImpl, properties};
        try {
            ObjectCache objectCache;
            this.copyStrategy = (CopyStrategy)ClassHelper.newInstance(string2);
            clazz = ClassHelper.getClass(string);
            if (clazz.equals(ObjectCacheDefaultImpl.class)) {
                properties.setProperty("autoSync", "false");
            }
            if (!((objectCache = (ObjectCache)ClassHelper.newInstance(clazz, classArray, objectArray)) instanceof ObjectCacheInternal)) {
                this.log.warn("Specified application cache class doesn't implement '" + ObjectCacheInternal.class.getName() + "'. For best interaction only specify caches implementing the internal object cache interface.");
                objectCache = new CacheDistributor.ObjectCacheInternalWrapper(objectCache);
            }
            this.applicationCache = (ObjectCacheInternal)objectCache;
        }
        catch (Exception exception) {
            throw new MetadataException("Can't setup application cache. Specified application cache was '" + string + "', copy strategy was '" + string2 + "'", exception);
        }
        if (this.log.isEnabledFor(2)) {
            clazz = new ToStringBuilder((Object)this);
            clazz.append(COPY_STRATEGY_PROP, string2).append(APPLICATION_CACHE_PROP, (Object)string);
            this.log.info("Setup cache: " + clazz.toString());
        }
    }

    public ObjectCacheInternal getApplicationCache() {
        return this.applicationCache;
    }

    private Object lookupFromApplicationCache(Identity identity) {
        Object object = null;
        Object object2 = this.getApplicationCache().lookup(identity);
        if (object2 != null) {
            object = this.copyStrategy.read(this.broker, object2);
        }
        return object;
    }

    private boolean putToApplicationCache(Identity identity, Object object, boolean bl) {
        Object object2 = null;
        if (!bl) {
            object2 = this.getApplicationCache().lookup(identity);
        }
        Object object3 = this.copyStrategy.write(this.broker, object, object2);
        if (bl) {
            return this.getApplicationCache().cacheIfNew(identity, object3);
        }
        this.getApplicationCache().cache(identity, object3);
        return false;
    }

    public void resetSessionCache() {
        this.sessionCache.clear();
        this.invokeCounter = 0;
    }

    private void pushToApplicationCache(int n, int n2) {
        for (CacheEntry cacheEntry : this.sessionCache.values()) {
            Object t = cacheEntry.get();
            if (t == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Object in session cache was gc, nothing to push to application cache");
                continue;
            }
            if (cacheEntry.type != n) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Move obj from session cache --> application cache : " + cacheEntry.oid);
            }
            if (!ProxyHelper.isMaterialized(t)) continue;
            this.putToApplicationCache(cacheEntry.oid, ProxyHelper.getRealObject(t), false);
            cacheEntry.type = n2;
        }
    }

    @Override
    public void doInternalCache(Identity identity, Object object, int n) {
        this.processQueue();
        if (n == 11) {
            boolean bl = this.putToApplicationCache(identity, object, true);
            CacheEntry cacheEntry = new CacheEntry(identity, object, 7, this.queue);
            if (bl) {
                this.putToSessionCache(identity, cacheEntry, false);
            } else {
                this.putToSessionCache(identity, cacheEntry, true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("The 'new' materialized object was already in cache, will not push it to application cache: " + identity);
                }
            }
        } else {
            CacheEntry cacheEntry = new CacheEntry(identity, object, n, this.queue);
            this.putToSessionCache(identity, cacheEntry, false);
        }
    }

    @Override
    public Object lookup(Identity identity) {
        Object object = null;
        CacheEntry cacheEntry = (CacheEntry)this.sessionCache.get(identity);
        if (cacheEntry != null) {
            object = cacheEntry.get();
        }
        if (object == null && (object = this.lookupFromApplicationCache(identity)) != null) {
            this.doInternalCache(identity, object, 7);
            this.materializeFullObject(object);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Materialized object from second level cache: " + identity);
            }
        }
        if (object != null && this.log.isDebugEnabled()) {
            this.log.debug("Match for: " + identity);
        }
        return object;
    }

    public void materializeFullObject(Object object) {
        ClassDescriptor classDescriptor = this.broker.getClassDescriptor(object.getClass());
        if (this.forceProxies) {
            this.broker.getReferenceBroker().retrieveProxyReferences(object, classDescriptor, false);
            this.broker.getReferenceBroker().retrieveProxyCollections(object, classDescriptor, false);
        } else {
            this.broker.getReferenceBroker().retrieveReferences(object, classDescriptor, false);
            this.broker.getReferenceBroker().retrieveCollections(object, classDescriptor, false);
        }
    }

    @Override
    public void remove(Identity identity) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove object " + identity);
        }
        this.sessionCache.remove(identity);
        this.getApplicationCache().remove(identity);
    }

    @Override
    public void clear() {
        this.sessionCache.clear();
        this.getApplicationCache().clear();
    }

    @Override
    public void cache(Identity identity, Object object) {
        this.doInternalCache(identity, object, 0);
    }

    @Override
    public boolean cacheIfNew(Identity identity, Object object) {
        boolean bl = this.putToApplicationCache(identity, object, true);
        if (bl) {
            CacheEntry cacheEntry = new CacheEntry(identity, object, 7, this.queue);
            this.putToSessionCache(identity, cacheEntry, true);
        }
        return bl;
    }

    private void putToSessionCache(Identity identity, CacheEntry cacheEntry, boolean bl) {
        if (bl) {
            if (!this.sessionCache.containsKey(identity)) {
                this.sessionCache.put(identity, cacheEntry);
            }
        } else {
            this.sessionCache.put(identity, cacheEntry);
        }
    }

    private void processQueue() {
        CacheEntry cacheEntry;
        while ((cacheEntry = (CacheEntry)this.queue.poll()) != null) {
            this.sessionCache.remove(cacheEntry.oid);
        }
    }

    @Override
    public void afterCommit(PBStateEvent pBStateEvent) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("afterCommit() call, push objects to application cache");
        }
        if (this.invokeCounter != 0) {
            this.log.error("** Please check method calls of ObjectCacheTwoLevelImpl#enableMaterialization and ObjectCacheTwoLevelImpl#disableMaterialization, number of calls have to be equals **");
        }
        try {
            this.pushToApplicationCache(5, 7);
        }
        finally {
            this.resetSessionCache();
        }
    }

    @Override
    public void beforeClose(PBStateEvent pBStateEvent) {
        if (!this.broker.isInTransaction()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Clearing the session cache");
            }
            this.resetSessionCache();
        }
    }

    @Override
    public void beforeRollback(PBStateEvent pBStateEvent) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("beforeRollback()");
        }
        this.resetSessionCache();
    }

    @Override
    public void afterOpen(PBStateEvent pBStateEvent) {
    }

    @Override
    public void beforeBegin(PBStateEvent pBStateEvent) {
    }

    @Override
    public void afterBegin(PBStateEvent pBStateEvent) {
    }

    @Override
    public void beforeCommit(PBStateEvent pBStateEvent) {
    }

    @Override
    public void afterRollback(PBStateEvent pBStateEvent) {
    }

    public static class CopyStrategyImpl
    implements CopyStrategy {
        static final String CLASS_NAME_STR = "ojbClassName11";

        @Override
        public Object read(PersistenceBroker persistenceBroker, Object object) {
            HashMap hashMap = (HashMap)object;
            String string = (String)hashMap.get(CLASS_NAME_STR);
            ClassDescriptor classDescriptor = persistenceBroker.getDescriptorRepository().getDescriptorFor(string);
            Object object2 = ClassHelper.buildNewObjectInstance(classDescriptor);
            for (FieldDescriptor fieldDescriptor : classDescriptor.getFieldDescriptor(true)) {
                Object object3 = hashMap.get(fieldDescriptor.getPersistentField().getName());
                if (object3 != null) {
                    object3 = fieldDescriptor.getJdbcType().getFieldType().copy(object3);
                }
                object3 = fieldDescriptor.getFieldConversion().sqlToJava(object3);
                fieldDescriptor.getPersistentField().set(object2, object3);
            }
            return object2;
        }

        @Override
        public Object write(PersistenceBroker persistenceBroker, Object object, Object object2) {
            ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
            HashMap hashMap = object2 != null ? (HashMap)object2 : new HashMap();
            for (FieldDescriptor fieldDescriptor : classDescriptor.getFieldDescriptor(true)) {
                Object object3 = fieldDescriptor.getPersistentField().get(object);
                object3 = fieldDescriptor.getFieldConversion().javaToSql(object3);
                object3 = fieldDescriptor.getJdbcType().getFieldType().copy(object3);
                hashMap.put(fieldDescriptor.getPersistentField().getName(), object3);
            }
            hashMap.put(CLASS_NAME_STR, object.getClass().getName());
            return hashMap;
        }
    }

    public static interface CopyStrategy {
        public Object read(PersistenceBroker var1, Object var2);

        public Object write(PersistenceBroker var1, Object var2, Object var3);
    }

    static final class CacheEntry
    extends SoftReference
    implements Serializable {
        private int type;
        private Identity oid;

        public CacheEntry(Identity identity, Object object, int n, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.oid = identity;
            this.type = n;
        }
    }
}

