/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.lang.ref.WeakReference;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.J2EETransactionImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.odmg.TransactionNotInProgressException;

public class JTATxManager
implements OJBTxManager {
    private Logger log = LoggerFactory.getLogger(JTATxManager.class);
    private static ThreadLocal txRepository = new ThreadLocal();

    @Override
    public void deregisterTx(Object object) {
        txRepository.set(null);
    }

    @Override
    public void registerTx(TransactionImpl transactionImpl) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerSynchronization was called");
        }
        Transaction transaction = null;
        try {
            transaction = this.getJTATransaction();
        }
        catch (SystemException systemException) {
            this.log.error("Obtain current transaction from container failed", systemException);
        }
        if (transaction == null) {
            this.log.error("Cannot get the external transaction from the external TM");
            throw new TransactionNotInProgressException("No external transaction found");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerSynchronization was called with parameters" + SystemUtils.LINE_SEPARATOR + "J2EETransactionImpl: " + transactionImpl + SystemUtils.LINE_SEPARATOR + "Transaction: " + transaction);
        }
        this.registerSynchronization(transactionImpl, transaction);
    }

    private void registerSynchronization(TransactionImpl transactionImpl, Transaction transaction) {
        if (transactionImpl == null || transaction == null) {
            this.log.error("One of the given parameters was null --> cannot do synchronization! omdg transaction was null: " + (transactionImpl == null) + ", external transaction was null: " + (transaction == null));
            return;
        }
        int n = -1;
        try {
            n = transaction.getStatus();
            if (n != 0) {
                throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx: " + JTATxManager.getStatusString(n));
            }
        }
        catch (SystemException systemException) {
            throw new OJBRuntimeException("Can't read status of external tx", systemException);
        }
        try {
            transaction.registerSynchronization((Synchronization)((J2EETransactionImpl)transactionImpl));
            txRepository.set(new TxBuffer(transactionImpl, transaction));
        }
        catch (Exception exception) {
            this.log.error("Cannot associate PersistenceBroker with running Transaction", exception);
            throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx", exception);
        }
    }

    private static String getStatusString(int n) {
        switch (n) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "NO STATUS FOUND";
    }

    private TransactionManager getTransactionManager() {
        TransactionManager transactionManager = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getTransactionManager called");
            }
            transactionManager = TransactionManagerFactoryFactory.instance().getTransactionManager();
        }
        catch (TransactionManagerFactoryException transactionManagerFactoryException) {
            this.log.warn("Exception trying to obtain TransactionManager from Factory", (Throwable)((Object)transactionManagerFactoryException));
            transactionManagerFactoryException.printStackTrace();
        }
        return transactionManager;
    }

    public Transaction getJTATransaction() throws SystemException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getTransaction called");
        }
        if (this.getTransactionManager() == null) {
            this.log.warn("TransactionManager was null");
            return null;
        }
        return this.getTransactionManager().getTransaction();
    }

    @Override
    public TransactionImpl getCurrentTransaction() {
        TransactionImpl transactionImpl = this.getTransaction();
        if (null == transactionImpl) {
            throw new TransactionNotInProgressException("Calling method needed transaction, but no transaction found via TransactionManager");
        }
        return transactionImpl;
    }

    @Override
    public TransactionImpl getTransaction() {
        TxBuffer txBuffer = (TxBuffer)txRepository.get();
        return txBuffer != null ? txBuffer.getInternTx() : null;
    }

    @Override
    public void abortExternalTx(TransactionImpl transactionImpl) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("abortExternTransaction was called");
        }
        if (transactionImpl == null) {
            return;
        }
        TxBuffer txBuffer = (TxBuffer)txRepository.get();
        Transaction transaction = txBuffer != null ? txBuffer.getExternTx() : null;
        try {
            if (transaction != null && transaction.getStatus() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set extern transaction to rollback");
                }
                transaction.setRollbackOnly();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        txRepository.set(null);
    }

    @Override
    public void configure(Configuration configuration) {
    }

    private static final class TxBuffer {
        private WeakReference externTx = null;
        private WeakReference internTx = null;

        public TxBuffer() {
        }

        public TxBuffer(TransactionImpl transactionImpl, Transaction transaction) {
            this.internTx = new WeakReference<TransactionImpl>(transactionImpl);
            this.externTx = new WeakReference<Transaction>(transaction);
        }

        public Transaction getExternTx() {
            return (Transaction)this.externTx.get();
        }

        public void setExternTx(Transaction transaction) {
            this.externTx = new WeakReference<Transaction>(transaction);
        }

        public TransactionImpl getInternTx() {
            return (TransactionImpl)this.internTx.get();
        }

        public void setInternTx(TransactionImpl transactionImpl) {
            this.internTx = new WeakReference<TransactionImpl>(transactionImpl);
        }
    }
}

