--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /

insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0009', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0009', '999901-00001', 1, '055125', '000001',
'9', '3', 1, '1', 'LOC - by award', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211401', '1',
'0211401', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80070'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999901-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00001', '999901-00001', '000000-00000',
'999901-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00001', 1, '2191506168',
'WILTON K LYKINS', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00001', 1, '3012703100', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999901-00001', 1, 'N', 10,
'Y', '1', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0010', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0010', '999901-00002', 1, '055125', '000001',
'9', '3', 1, '1', 'LOC - by award', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211402', '1',
'0211402', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80070'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999901-00002', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00001', '999901-00002', '999901-00001',
'999901-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00002', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00002', 1, '2191506168',
'WILTON K LYKINS', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00002', 1, '3012703100', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00002', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999901-00002', 1, 'N', 10,
'Y', '1', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0011', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0011', '999901-00003', 1, '055125', '000001',
'9', '3', 1, '1', 'LOC - by award', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211801', '1',
'0211801', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80070'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999901-00003', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00001', '999901-00003', '999901-00001',
'999901-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00003', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999901-00003', 1, '2191506168',
'WILTON K LYKINS', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00003', 1, '3012703100', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999901-00003', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999901-00003', 1, 'N', 10,
'Y', '1', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0012', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0012', '999902-00001', 1, '055124', '000001',
'9', '3', 1, '1', 'LOC - by acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211403', '1',
'0211403', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80072'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999902-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999902-00001', '999902-00001', '000000-00000',
'999902-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999902-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999902-00001', 1, '3428005487',
'WILLARD X JOHNSTONE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00001', 1, '2552202601', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999902-00001', 1, 'N', 10,
'N', '2', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0013', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0013', '999902-00002', 1, '055124', '000001',
'9', '3', 1, '1', 'LOC - by acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211404', '1',
'0211404', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80072'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999902-00002', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999902-00001', '999902-00002', '999902-00001',
'999902-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999902-00002', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999902-00002', 1, '3428005487',
'WILLARD X JOHNSTONE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00002', 1, '2552202601', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999902-00002', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999902-00002', 1, 'N', 10,
'N', '2', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0014', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0014', '999903-00001', 1, '055075', '000001',
'9', '3', 1, '1', 'LOC - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211405', '1',
'0211405', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80073'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999903-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00001', '999903-00001', '000000-00000',
'999903-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00001', 1, '1821805071',
'ELMER H ARMENDARIZ', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00001', 1, '1210908400', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999903-00001', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0015', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0015', '999903-00002', 1, '055075', '000001',
'9', '3', 1, '1', 'LOC - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211406', '1',
'0211406', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80073'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999903-00002', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00001', '999903-00002', '999903-00001',
'999903-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00002', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00002', 1, '1821805071',
'ELMER H ARMENDARIZ', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00002', 1, '1210908400', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00002', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999903-00002', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0016', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0016', '999903-00003', 1, '055075', '000001',
'9', '3', 1, '1', 'LOC - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211407', '1',
'0211407', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80073'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999903-00003', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00001', '999903-00003', '999903-00001',
'999903-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00003', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00003', 1, '1821805071',
'ELMER H ARMENDARIZ', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00003', 1, '1210908400', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00003', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999903-00003', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0017', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0017', '999903-00004', 1, '055075', '000001',
'9', '3', 1, '1', 'LOC - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211408', '1',
'0211408', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80073'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999903-00004', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00001', '999903-00004', '999903-00001',
'999903-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00004', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00004', 1, '1821805071',
'ELMER H ARMENDARIZ', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00004', 1, '1210908400', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00004', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999903-00004', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0018', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0018', '999903-00005', 1, '055075', '000001',
'9', '3', 1, '1', 'LOC - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211409', '1',
'0211409', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80073'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999903-00005', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00001', '999903-00005', '999903-00001',
'999903-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00005', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160630', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999903-00005', 1, '1821805071',
'ELMER H ARMENDARIZ', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00005', 1, '1210908400', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999903-00005', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999903-00005', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0019', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0019', '999904-00001', 1, '055076', '000001',
'9', '3', 1, '1', 'MILE - by acct', '00.000',
'1', '1', STR_TO_DATE('20140115', '%Y%m%d'), STR_TO_DATE('20140115', '%Y%m%d'), '0211503', '1',
'0211503', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80075'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999904-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999904-00001', '999904-00001', '000000-00000',
'999904-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999904-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20170115', '%Y%m%d'), STR_TO_DATE('20170115', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20170115', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999904-00001', 1, '3012703100',
'FRANCIS T SILER', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999904-00001', 1, '2191506168', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999904-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999904-00001', 1, 'N', 10,
'N', '2', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0020', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0020', '999905-00001', 1, '055078', '000001',
'9', '3', 1, '1', 'PD - by acct', '00.000',
'1', '1', STR_TO_DATE('20140106', '%Y%m%d'), STR_TO_DATE('20140106', '%Y%m%d'), '0211603', '1',
'0211603', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80078'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999905-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999905-00001', '999905-00001', '000000-00000',
'999905-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999905-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20180205', '%Y%m%d'), STR_TO_DATE('20180205', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20180205', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999905-00001', 1, '1308508136',
'MARTIN C HAGOOD', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999905-00001', 1, '5175504470', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999905-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999905-00001', 1, 'N', 20,
'N', '2', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0021', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0021', '999906-00001', 1, '055079', '000001',
'9', '3', 1, '1', 'MONTHLY - by award', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211701', '1',
'0211701', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80066'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999906-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00001', '999906-00001', '000000-00000',
'999906-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00001', 1, '2552202601',
'BILLIE O ISOM', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00001', 1, '3428005487', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999906-00001', 1, 'Y', 10,
'N', '1', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0022', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0022', '999906-00002', 1, '055079', '000001',
'9', '3', 1, '1', 'MONTHLY - by award', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211702', '1',
'0211702', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80066'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999906-00002', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00001', '999906-00002', '999906-00001',
'999906-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00002', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00002', 1, '2552202601',
'BILLIE O ISOM', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00002', 1, '3428005487', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00002', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999906-00002', 1, 'Y', 10,
'N', '1', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0023', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0023', '999906-00003', 1, '055079', '000001',
'9', '3', 1, '1', 'MONTHLY - by award', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211804', '1',
'0211804', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80066'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999906-00003', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00001', '999906-00003', '999906-00001',
'999906-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00003', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999906-00003', 1, '2552202601',
'BILLIE O ISOM', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00003', 1, '3428005487', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999906-00003', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999906-00003', 1, 'Y', 10,
'N', '1', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0024', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0024', '999907-00001', 1, '055126', '000001',
'9', '3', 1, '1', 'MONTHLY by acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211703', '1',
'0211703', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80067'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999907-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999907-00001', '999907-00001', '000000-00000',
'999907-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999907-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20170201', '%Y%m%d'), STR_TO_DATE('20170201', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20170201', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999907-00001', 1, '1210908400',
'DALE B DISNEY', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00001', 1, '1821805071', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999907-00001', 1, 'N', 10,
'N', '2', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0025', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0025', '999907-00002', 1, '055126', '000001',
'9', '3', 1, '1', 'MONTHLY by acct', '00.000',
'1', '1', STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20140101', '%Y%m%d'), '0211704', '1',
'0211704', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80067'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999907-00002', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999907-00001', '999907-00002', '999907-00001',
'999907-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999907-00002', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20170201', '%Y%m%d'), STR_TO_DATE('20170201', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20170201', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999907-00002', 1, '1210908400',
'DALE B DISNEY', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00002', 1, '1821805071', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999907-00002', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999907-00002', 1, 'N', 10,
'N', '2', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0026', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0026', '999908-00001', 1, '055127', '000001',
'9', '3', 1, '1', 'MONTHLY - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211705', '1',
'0211705', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80068'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999908-00001', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00001', '999908-00001', '000000-00000',
'999908-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00001', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00001', 1, '5175504470',
'ELNORA O MARBLE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00001', 1, '1308508136', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00001', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999908-00001', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0027', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0027', '999908-00002', 1, '055127', '000001',
'9', '3', 1, '1', 'MONTHLY - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211706', '1',
'0211706', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80068'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999908-00002', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00001', '999908-00002', '999908-00001',
'999908-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00002', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00002', 1, '5175504470',
'ELNORA O MARBLE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00002', 1, '1308508136', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00002', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999908-00002', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0028', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0028', '999908-00003', 1, '055127', '000001',
'9', '3', 1, '1', 'MONTHLY - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211707', '1',
'0211707', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80068'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999908-00003', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00001', '999908-00003', '999908-00001',
'999908-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00003', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00003', 1, '5175504470',
'ELNORA O MARBLE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00003', 1, '1308508136', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00003', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999908-00003', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0029', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0029', '999908-00004', 1, '055127', '000001',
'9', '3', 1, '1', 'MONTHLY - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211708', '1',
'0211708', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80068'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999908-00004', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00001', '999908-00004', '999908-00001',
'999908-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00004', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00004', 1, '5175504470',
'ELNORA O MARBLE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00004', 1, '1308508136', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00004', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999908-00004', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


insert into AWARD_DOCUMENT (DOCUMENT_NUMBER, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ('KCCGB0030', 1, NOW(), 'admin', UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD (AWARD_ID, DOCUMENT_NUMBER, AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE, LEAD_UNIT_NUMBER,
TRANSACTION_TYPE_CODE, ACTIVITY_TYPE_CODE, AWARD_TYPE_CODE, STATUS_CODE, TITLE, CFDA_NUMBER,
METHOD_OF_PAYMENT_CODE, BASIS_OF_PAYMENT_CODE, BEGIN_DATE, AWARD_EFFECTIVE_DATE, ACCOUNT_NUMBER, ACCOUNT_TYPE_CODE,
FIN_ACCOUNT_DOC_NBR, FIN_ACCOUNT_CREATION_DATE, FIN_CHART_OF_ACCOUNTS_CODE, AWARD_SEQUENCE_STATUS,
APPRVD_EQUIPMENT_INDICATOR, APPRVD_SUBCONTRACT_INDICATOR, APPRVD_FOREIGN_TRIP_INDICATOR, COST_SHARING_INDICATOR,
IDC_INDICATOR, PAYMENT_SCHEDULE_INDICATOR, SCIENCE_CODE_INDICATOR, SPECIAL_REVIEW_INDICATOR, TRANSFER_SPONSOR_INDICATOR,
VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), 'KCCGB0030', '999908-00005', 1, '055127', '000001',
'9', '3', 1, '1', 'MONTHLY - by cc acct', '00.000',
'1', '1', STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20140217', '%Y%m%d'), '0211709', '1',
'0211709', null, 'BL', 'ACTIVE',
'N', 'N', 'N', 'N',
'N', 'N', 'N', 'N', 'N',
1, NOW(), 'admin', UUID())
/

insert into AWARD_FUNDING_PROPOSALS (AWARD_FUNDING_PROPOSAL_ID, AWARD_ID, PROPOSAL_ID,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, ACTIVE, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select PROPOSAL_ID from PROPOSAL where PROPOSAL_NUMBER = '80068'),
NOW(), 'admin', 1, 'Y', UUID())
/
INSERT INTO SEQ_VERSION_HISTORY_ID VALUES(NULL)
/

insert into VERSION_HISTORY (VERSION_HISTORY_ID, SEQ_OWNER_CLASS_NAME, SEQ_OWNER_VERSION_NAME_FIELD,
SEQ_OWNER_VERSION_NAME_VALUE, SEQ_OWNER_SEQ_NUMBER, VERSION_STATUS, VERSION_DATE,
USER_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_VERSION_HISTORY_ID), 'org.kuali.kra.award.home.Award', 'awardNumber',
'999908-00005', 1, 'ACTIVE', NOW(),
'admin', NOW(), 'admin', 1, UUID())
/

insert into AWARD_HIERARCHY (AWARD_HIERARCHY_ID, ROOT_AWARD_NUMBER, AWARD_NUMBER, PARENT_AWARD_NUMBER,
ORIGINATING_AWARD_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, ACTIVE)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00001', '999908-00005', '999908-00001',
'999908-00001', NOW(), 'admin', 1, UUID(), 'Y')
/

insert into AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ANTICIPATED_TOTAL_DIRECT, ANTICIPATED_TOTAL_INDIRECT, OBLIGATED_TOTAL_DIRECT, OBLIGATED_TOTAL_INDIRECT,
ANTICIPATED_TOTAL_AMOUNT, ANT_DISTRIBUTABLE_AMOUNT, FINAL_EXPIRATION_DATE, CURRENT_FUND_EFFECTIVE_DATE,
AMOUNT_OBLIGATED_TO_DATE, OBLI_DISTRIBUTABLE_AMOUNT, OBLIGATION_EXPIRATION_DATE, ORIGINATING_AWARD_VERSION,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00005', 1,
200000, 100000, 200000, 100000,
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
300000, 300000, STR_TO_DATE('20160229', '%Y%m%d'), 1,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSONS (AWARD_PERSON_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '999908-00005', 1, '5175504470',
'ELNORA O MARBLE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID, AWARD_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERSON_CREDIT_SPLITS (AWARD_PERSON_CREDIT_SPLIT_ID, AWARD_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_ID) from AWARD_PERSONS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_PERS_UNIT_CRED_SPLITS (APU_CREDIT_SPLIT_ID, AWARD_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID) , (select max(AWARD_PERSON_UNIT_ID) from AWARD_PERSON_UNITS),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/

insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_CUSTOM_DATA_ID VALUES(NULL)
/
insert into AWARD_CUSTOM_DATA (AWARD_CUSTOM_DATA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_CUSTOM_DATA_ID), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
4, '5', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/

insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
325, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
505, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
353, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
371, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
538, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
318, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
354, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
372, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
417, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
544, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
556, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
567, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
569, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
493, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
500, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
410, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
437, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
383, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
578, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
601, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
322, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
367, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
448, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
480, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
333, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_AWARD_SPONSOR_TERM VALUES(NULL)
/
insert into AWARD_SPONSOR_TERM (AWARD_SPONSOR_TERM_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
SPONSOR_TERM_ID, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_AWARD_SPONSOR_TERM), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
369, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_UNIT_CONTACTS (AWARD_UNIT_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, PERSON_ID, FULL_NAME,
UNIT_ADMINISTRATOR_TYPE_CODE, UNIT_CONTACT_TYPE, UNIT_ADMINISTRATOR_UNIT_NUMBER, DEFAULT_UNIT_CONTACT,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00005', 1, '1308508136', 'quickstart',
'9', 'CONTACT', '000001', 'N',
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_SPONSOR_CONTACTS (AWARD_SPONSOR_CONTACT_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
ROLODEX_ID, FULL_NAME, CONTACT_ROLE_CODE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
1, 'Last Name, First Name Middle Name', '13', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/

insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
'6', '71', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_AWARD_ID VALUES(NULL)
/
insert into AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER,
REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE, FREQUENCY_BASE_CODE, OSP_DISTRIBUTION_CODE, DUE_DATE,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_AWARD_ID), (select max(AWARD_ID) from AWARD), '999908-00005', 1,
'1', '7', '7', '5', '1', null,
NOW(), 'admin', 1, UUID())
/

insert into AWARD_CGB (AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, ADDITIONAL_FORMS_REQ, MIN_INVOICE_AMT,
AUTO_APPROVE_INVOICE, INVOICING_OPTION, STOP_WORK, DUNNING_CAMPAIGN_ID, LAST_BILLED_DATE,
PREV_LAST_BILLED_DATE, FINAL_BILL, AMT_TO_DRAW, LETTER_OF_CREDIT_REVIEW,
INVOICE_DOCUMENT_STATUS, LOC_CREATION_TYPE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((select max(AWARD_ID) from AWARD), '999908-00005', 1, 'N', 10,
'N', '3', 'N', null, null,
null, 'N', null, 'N',
null, null, NOW(), 'admin', 1, UUID())
/


DELIMITER ;
