/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdDefTemplate
extends XmlTemplate {
    public RrdDefTemplate(InputSource xmlInputSource) throws IOException, RrdException {
        super(xmlInputSource);
    }

    public RrdDefTemplate(String xmlString) throws IOException, RrdException {
        super(xmlString);
    }

    public RrdDefTemplate(File xmlFile) throws IOException, RrdException {
        super(xmlFile);
    }

    public RrdDef getRrdDef() throws RrdException {
        Node[] arcNodes;
        Node[] dsNodes;
        if (!this.root.getTagName().equals("rrd_def")) {
            throw new RrdException("XML definition must start with <rrd_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"path", "start", "step", "datasource*", "archive*"});
        String path = this.getChildValue(this.root, "path");
        RrdDef rrdDef = new RrdDef(path);
        try {
            String startStr = this.getChildValue(this.root, "start");
            Calendar startGc = Util.getCalendar(startStr);
            rrdDef.setStartTime(startGc);
        }
        catch (RrdException startStr) {
            // empty catch block
        }
        try {
            long step = this.getChildValueAsLong(this.root, "step");
            rrdDef.setStep(step);
        }
        catch (RrdException step) {
            // empty catch block
        }
        Node[] nodeArray = dsNodes = RrdDefTemplate.getChildNodes(this.root, "datasource");
        int n = dsNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node dsNode = nodeArray[n2];
            this.validateTagsOnlyOnce(dsNode, new String[]{"name", "type", "heartbeat", "min", "max"});
            String name = this.getChildValue(dsNode, "name");
            String type = this.getChildValue(dsNode, "type");
            long heartbeat = this.getChildValueAsLong(dsNode, "heartbeat");
            double min = this.getChildValueAsDouble(dsNode, "min");
            double max = this.getChildValueAsDouble(dsNode, "max");
            rrdDef.addDatasource(name, type, heartbeat, min, max);
            ++n2;
        }
        Node[] nodeArray2 = arcNodes = RrdDefTemplate.getChildNodes(this.root, "archive");
        int n3 = arcNodes.length;
        n = 0;
        while (n < n3) {
            Node arcNode = nodeArray2[n];
            this.validateTagsOnlyOnce(arcNode, new String[]{"cf", "xff", "steps", "rows"});
            String consolFun = this.getChildValue(arcNode, "cf");
            double xff = this.getChildValueAsDouble(arcNode, "xff");
            int steps = this.getChildValueAsInt(arcNode, "steps");
            int rows = this.getChildValueAsInt(arcNode, "rows");
            rrdDef.addArchive(consolFun, xff, steps, rows);
            ++n;
        }
        return rrdDef;
    }
}

