/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.EpochMillisDateFormatter;
import org.elasticsearch.common.time.EpochSecondsDateFormatter;
import org.elasticsearch.common.time.JavaDateFormatter;

public class DateFormatters {
    private static final DateTimeFormatter TIME_ZONE_FORMATTER_NO_COLON = new DateTimeFormatterBuilder().appendOffset("+HHmm", "Z").toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_YEAR_MONTH_DAY_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_HOUR_MINUTE_SECOND_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_DATE_OPTIONAL_TIME_FORMATTER_1 = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).optionalStart().appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_DATE_OPTIONAL_TIME_FORMATTER_2 = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).optionalStart().appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalStart().appendOffset("+HHmm", "Z").optionalEnd().optionalEnd().toFormatter(Locale.ROOT);
    private static final DateFormatter STRICT_DATE_OPTIONAL_TIME = new JavaDateFormatter("strict_date_optional_time", STRICT_DATE_OPTIONAL_TIME_FORMATTER_1, STRICT_DATE_OPTIONAL_TIME_FORMATTER_1, STRICT_DATE_OPTIONAL_TIME_FORMATTER_2);
    private static final DateTimeFormatter STRICT_DATE_OPTIONAL_TIME_FORMATTER_WITH_NANOS_1 = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).optionalStart().appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_DATE_OPTIONAL_TIME_FORMATTER_WITH_NANOS_2 = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).optionalStart().appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).optionalEnd().optionalStart().appendOffset("+HHmm", "Z").optionalEnd().optionalEnd().toFormatter(Locale.ROOT);
    private static final DateFormatter STRICT_DATE_OPTIONAL_TIME_NANOS = new JavaDateFormatter("strict_date_optional_time_nanos", STRICT_DATE_OPTIONAL_TIME_FORMATTER_WITH_NANOS_1, STRICT_DATE_OPTIONAL_TIME_FORMATTER_WITH_NANOS_1, STRICT_DATE_OPTIONAL_TIME_FORMATTER_WITH_NANOS_2);
    private static final DateTimeFormatter BASIC_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final DateFormatter BASIC_TIME_NO_MILLIS = new JavaDateFormatter("basic_time_no_millis", new DateTimeFormatterBuilder().append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_TIME_PRINTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
    private static final DateFormatter BASIC_TIME = new JavaDateFormatter("basic_time", new DateTimeFormatterBuilder().append(BASIC_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_T_TIME_PRINTER = new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_PRINTER).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_T_TIME_FORMATTER = new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_FORMATTER).toFormatter(Locale.ROOT);
    private static final DateFormatter BASIC_T_TIME = new JavaDateFormatter("basic_t_time", new DateTimeFormatterBuilder().append(BASIC_T_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_T_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_T_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateFormatter BASIC_T_TIME_NO_MILLIS = new JavaDateFormatter("basic_t_time_no_millis", new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_YEAR_MONTH_DAY_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 4, SignStyle.NORMAL).appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(BASIC_YEAR_MONTH_DAY_FORMATTER).append(BASIC_T_TIME_FORMATTER).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_DATE_TIME_PRINTER = new DateTimeFormatterBuilder().append(BASIC_YEAR_MONTH_DAY_FORMATTER).append(BASIC_T_TIME_PRINTER).toFormatter(Locale.ROOT);
    private static final DateFormatter BASIC_DATE_TIME = new JavaDateFormatter("basic_date_time", new DateTimeFormatterBuilder().append(BASIC_DATE_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_DATE_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_DATE_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_DATE_T = new DateTimeFormatterBuilder().append(BASIC_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").toFormatter(Locale.ROOT);
    private static final DateFormatter BASIC_DATE_TIME_NO_MILLIS = new JavaDateFormatter("basic_t_time_no_millis", new DateTimeFormatterBuilder().append(BASIC_DATE_T).append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_DATE_T).append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_DATE_T).append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateFormatter BASIC_ORDINAL_DATE = new JavaDateFormatter("basic_ordinal_date", DateTimeFormatter.ofPattern("yyyyDDD", Locale.ROOT), new DateTimeFormatter[0]);
    private static final DateFormatter BASIC_ORDINAL_DATE_TIME = new JavaDateFormatter("basic_ordinal_date_time", new DateTimeFormatterBuilder().appendPattern("yyyyDDD").append(BASIC_T_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendPattern("yyyyDDD").append(BASIC_T_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateFormatter BASIC_ORDINAL_DATE_TIME_NO_MILLIS = new JavaDateFormatter("basic_ordinal_date_time_no_millis", new DateTimeFormatterBuilder().appendPattern("yyyyDDD").appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendPattern("yyyyDDD").appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendPattern("yyyyDDD").appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_WEEK_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(IsoFields.WEEK_BASED_YEAR).appendLiteral("W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1, 2, SignStyle.NEVER).appendValue(ChronoField.DAY_OF_WEEK).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_BASIC_WEEK_DATE_FORMATTER = new DateTimeFormatterBuilder().parseStrict().appendValue(IsoFields.WEEK_BASED_YEAR, 4).appendLiteral("W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1, 2, SignStyle.NEVER).appendValue(ChronoField.DAY_OF_WEEK).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_BASIC_WEEK_DATE_PRINTER = new DateTimeFormatterBuilder().parseStrict().appendValue(IsoFields.WEEK_BASED_YEAR, 4).appendLiteral("W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2, 2, SignStyle.NEVER).appendValue(ChronoField.DAY_OF_WEEK).toFormatter(Locale.ROOT);
    private static final DateFormatter STRICT_BASIC_WEEK_DATE = new JavaDateFormatter("strict_basic_week_date", STRICT_BASIC_WEEK_DATE_PRINTER, STRICT_BASIC_WEEK_DATE_FORMATTER);
    private static final DateFormatter STRICT_BASIC_WEEK_DATE_TIME_NO_MILLIS = new JavaDateFormatter("strict_basic_week_date_no_millis", new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_PRINTER).append(DateTimeFormatter.ofPattern("'T'HHmmssX", Locale.ROOT)).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_FORMATTER).append(DateTimeFormatter.ofPattern("'T'HHmmssX", Locale.ROOT)).toFormatter(Locale.ROOT));
    private static final DateFormatter STRICT_BASIC_WEEK_DATE_TIME = new JavaDateFormatter("strict_basic_week_date_time", new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_PRINTER).append(DateTimeFormatter.ofPattern("'T'HHmmss.SSSX", Locale.ROOT)).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_FORMATTER).append(DateTimeFormatter.ofPattern("'T'HHmmss.SSSX", Locale.ROOT)).toFormatter(Locale.ROOT));
    private static final DateFormatter STRICT_DATE = new JavaDateFormatter("strict_date", DateTimeFormatter.ISO_LOCAL_DATE.withResolverStyle(ResolverStyle.LENIENT), new DateTimeFormatter[0]);
    private static final DateFormatter STRICT_DATE_HOUR = new JavaDateFormatter("strict_date_hour", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH", Locale.ROOT), new DateTimeFormatter[0]);
    private static final DateFormatter STRICT_DATE_HOUR_MINUTE = new JavaDateFormatter("strict_date_hour_minute", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm", Locale.ROOT), new DateTimeFormatter[0]);
    private static final DateFormatter STRICT_YEAR_MONTH_DAY = new JavaDateFormatter("strict_year_month_day", STRICT_YEAR_MONTH_DAY_FORMATTER, new DateTimeFormatter[0]);
    private static final DateFormatter STRICT_YEAR_MONTH = new JavaDateFormatter("strict_year_month", new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
    private static final DateFormatter STRICT_YEAR = new JavaDateFormatter("strict_year", new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
    private static final DateFormatter STRICT_HOUR_MINUTE_SECOND = new JavaDateFormatter("strict_hour_minute_second", STRICT_HOUR_MINUTE_SECOND_FORMATTER, new DateTimeFormatter[0]);
    private static final DateTimeFormatter STRICT_DATE_FORMATTER = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().toFormatter(Locale.ROOT);
    private static final DateFormatter STRICT_DATE_TIME = new JavaDateFormatter("strict_date_time", new DateTimeFormatterBuilder().append(STRICT_DATE_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_DATE_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_DATE_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter STRICT_ORDINAL_DATE_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3, 3, SignStyle.NOT_NEGATIVE).appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT);
    private static final DateFormatter STRICT_ORDINAL_DATE_TIME_NO_MILLIS = new JavaDateFormatter("strict_ordinal_date_time_no_millis", new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter STRICT_DATE_TIME_NO_MILLIS_FORMATTER = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT);
    private static final DateFormatter STRICT_DATE_TIME_NO_MILLIS = new JavaDateFormatter("strict_date_time_no_millis", new DateTimeFormatterBuilder().append(STRICT_DATE_TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_DATE_TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_DATE_TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter STRICT_HOUR_MINUTE_SECOND_MILLIS_FORMATTER = new DateTimeFormatterBuilder().append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER = new DateTimeFormatterBuilder().append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
    private static final DateFormatter STRICT_HOUR_MINUTE_SECOND_MILLIS;
    private static final DateFormatter STRICT_HOUR_MINUTE_SECOND_FRACTION;
    private static final DateFormatter STRICT_DATE_HOUR_MINUTE_SECOND_FRACTION;
    private static final DateFormatter STRICT_DATE_HOUR_MINUTE_SECOND_MILLIS;
    private static final DateFormatter STRICT_HOUR;
    private static final DateFormatter STRICT_HOUR_MINUTE;
    private static final DateTimeFormatter STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE;
    private static final DateFormatter STRICT_ORDINAL_DATE_TIME;
    private static final DateTimeFormatter STRICT_TIME_FORMATTER_BASE;
    private static final DateTimeFormatter STRICT_TIME_PRINTER;
    private static final DateFormatter STRICT_TIME;
    private static final DateFormatter STRICT_T_TIME;
    private static final DateTimeFormatter STRICT_TIME_NO_MILLIS_BASE;
    private static final DateFormatter STRICT_TIME_NO_MILLIS;
    private static final DateFormatter STRICT_T_TIME_NO_MILLIS;
    private static final DateTimeFormatter ISO_WEEK_DATE;
    private static final DateTimeFormatter ISO_WEEK_DATE_T;
    private static final DateFormatter STRICT_WEEK_DATE;
    private static final DateFormatter STRICT_WEEK_DATE_TIME_NO_MILLIS;
    private static final DateFormatter STRICT_WEEK_DATE_TIME;
    private static final DateFormatter STRICT_WEEKYEAR;
    private static final DateTimeFormatter STRICT_WEEKYEAR_WEEK_FORMATTER;
    private static final DateFormatter STRICT_WEEKYEAR_WEEK;
    private static final DateFormatter STRICT_WEEKYEAR_WEEK_DAY;
    private static final DateFormatter STRICT_DATE_HOUR_MINUTE_SECOND;
    private static final DateFormatter BASIC_DATE;
    private static final DateTimeFormatter STRICT_ORDINAL_DATE_FORMATTER;
    private static final DateFormatter STRICT_ORDINAL_DATE;
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final DateTimeFormatter HOUR_MINUTE_FORMATTER;
    private static final DateFormatter DATE_OPTIONAL_TIME;
    private static final DateTimeFormatter HOUR_MINUTE_SECOND_FORMATTER;
    private static final DateTimeFormatter HOUR_MINUTE_SECOND_MILLIS_FORMATTER;
    private static final DateTimeFormatter ORDINAL_DATE_FORMATTER;
    private static final DateTimeFormatter ORDINAL_DATE_PRINTER;
    private static final DateFormatter ORDINAL_DATE;
    private static final DateTimeFormatter TIME_NO_MILLIS_FORMATTER;
    private static final DateTimeFormatter T_TIME_NO_MILLIS_FORMATTER;
    private static final DateTimeFormatter TIME_PREFIX;
    private static final DateTimeFormatter WEEK_DATE_FORMATTER;
    private static final DateFormatter WEEK_YEAR;
    private static final DateFormatter YEAR;
    private static final DateFormatter DATE_HOUR;
    private static final DateFormatter DATE_HOUR_MINUTE_SECOND_MILLIS;
    private static final DateFormatter DATE_HOUR_MINUTE_SECOND_FRACTION;
    private static final DateFormatter DATE_HOUR_MINUTE;
    private static final DateFormatter DATE_HOUR_MINUTE_SECOND;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static final DateFormatter DATE_TIME;
    private static final DateFormatter BASIC_WEEK_DATE;
    private static final DateFormatter DATE;
    private static final DateTimeFormatter DATE_TIME_NO_MILLIS_PRINTER;
    private static final DateTimeFormatter DATE_TIME_PREFIX;
    private static final DateFormatter DATE_TIME_NO_MILLIS;
    private static final DateFormatter HOUR_MINUTE_SECOND_MILLIS;
    private static final DateFormatter HOUR_MINUTE;
    private static final DateFormatter HOUR_MINUTE_SECOND;
    private static final DateFormatter HOUR;
    private static final DateTimeFormatter ORDINAL_DATE_TIME_FORMATTER_BASE;
    private static final DateFormatter ORDINAL_DATE_TIME;
    private static final DateTimeFormatter ORDINAL_DATE_TIME_NO_MILLIS_BASE;
    private static final DateFormatter ORDINAL_DATE_TIME_NO_MILLIS;
    private static final DateFormatter WEEK_DATE_TIME;
    private static final DateFormatter WEEK_DATE_TIME_NO_MILLIS;
    private static final DateFormatter BASIC_WEEK_DATE_TIME;
    private static final DateFormatter BASIC_WEEK_DATE_TIME_NO_MILLIS;
    private static final DateFormatter TIME;
    private static final DateFormatter TIME_NO_MILLIS;
    private static final DateFormatter T_TIME;
    private static final DateFormatter T_TIME_NO_MILLIS;
    private static final DateFormatter YEAR_MONTH;
    private static final DateFormatter YEAR_MONTH_DAY;
    private static final DateFormatter WEEK_DATE;
    private static final DateFormatter WEEKYEAR_WEEK;
    private static final DateFormatter WEEKYEAR_WEEK_DAY;
    private static final ZonedDateTime EPOCH_ZONED_DATE_TIME;

    public static DateFormatter forPattern(String input) {
        if (Strings.hasLength(input)) {
            input = input.trim();
        }
        if (input == null || input.length() == 0) {
            throw new IllegalArgumentException("No date pattern provided");
        }
        if ("basicDate".equals(input) || "basic_date".equals(input)) {
            return BASIC_DATE;
        }
        if ("basicDateTime".equals(input) || "basic_date_time".equals(input)) {
            return BASIC_DATE_TIME;
        }
        if ("basicDateTimeNoMillis".equals(input) || "basic_date_time_no_millis".equals(input)) {
            return BASIC_DATE_TIME_NO_MILLIS;
        }
        if ("basicOrdinalDate".equals(input) || "basic_ordinal_date".equals(input)) {
            return BASIC_ORDINAL_DATE;
        }
        if ("basicOrdinalDateTime".equals(input) || "basic_ordinal_date_time".equals(input)) {
            return BASIC_ORDINAL_DATE_TIME;
        }
        if ("basicOrdinalDateTimeNoMillis".equals(input) || "basic_ordinal_date_time_no_millis".equals(input)) {
            return BASIC_ORDINAL_DATE_TIME_NO_MILLIS;
        }
        if ("basicTime".equals(input) || "basic_time".equals(input)) {
            return BASIC_TIME;
        }
        if ("basicTimeNoMillis".equals(input) || "basic_time_no_millis".equals(input)) {
            return BASIC_TIME_NO_MILLIS;
        }
        if ("basicTTime".equals(input) || "basic_t_time".equals(input)) {
            return BASIC_T_TIME;
        }
        if ("basicTTimeNoMillis".equals(input) || "basic_t_time_no_millis".equals(input)) {
            return BASIC_T_TIME_NO_MILLIS;
        }
        if ("basicWeekDate".equals(input) || "basic_week_date".equals(input)) {
            return BASIC_WEEK_DATE;
        }
        if ("basicWeekDateTime".equals(input) || "basic_week_date_time".equals(input)) {
            return BASIC_WEEK_DATE_TIME;
        }
        if ("basicWeekDateTimeNoMillis".equals(input) || "basic_week_date_time_no_millis".equals(input)) {
            return BASIC_WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("date".equals(input)) {
            return DATE;
        }
        if ("dateHour".equals(input) || "date_hour".equals(input)) {
            return DATE_HOUR;
        }
        if ("dateHourMinute".equals(input) || "date_hour_minute".equals(input)) {
            return DATE_HOUR_MINUTE;
        }
        if ("dateHourMinuteSecond".equals(input) || "date_hour_minute_second".equals(input)) {
            return DATE_HOUR_MINUTE_SECOND;
        }
        if ("dateHourMinuteSecondFraction".equals(input) || "date_hour_minute_second_fraction".equals(input)) {
            return DATE_HOUR_MINUTE_SECOND_FRACTION;
        }
        if ("dateHourMinuteSecondMillis".equals(input) || "date_hour_minute_second_millis".equals(input)) {
            return DATE_HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("dateOptionalTime".equals(input) || "date_optional_time".equals(input)) {
            return DATE_OPTIONAL_TIME;
        }
        if ("dateTime".equals(input) || "date_time".equals(input)) {
            return DATE_TIME;
        }
        if ("dateTimeNoMillis".equals(input) || "date_time_no_millis".equals(input)) {
            return DATE_TIME_NO_MILLIS;
        }
        if ("hour".equals(input)) {
            return HOUR;
        }
        if ("hourMinute".equals(input) || "hour_minute".equals(input)) {
            return HOUR_MINUTE;
        }
        if ("hourMinuteSecond".equals(input) || "hour_minute_second".equals(input)) {
            return HOUR_MINUTE_SECOND;
        }
        if ("hourMinuteSecondFraction".equals(input) || "hour_minute_second_fraction".equals(input)) {
            return HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("hourMinuteSecondMillis".equals(input) || "hour_minute_second_millis".equals(input)) {
            return HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("ordinalDate".equals(input) || "ordinal_date".equals(input)) {
            return ORDINAL_DATE;
        }
        if ("ordinalDateTime".equals(input) || "ordinal_date_time".equals(input)) {
            return ORDINAL_DATE_TIME;
        }
        if ("ordinalDateTimeNoMillis".equals(input) || "ordinal_date_time_no_millis".equals(input)) {
            return ORDINAL_DATE_TIME_NO_MILLIS;
        }
        if ("time".equals(input)) {
            return TIME;
        }
        if ("timeNoMillis".equals(input) || "time_no_millis".equals(input)) {
            return TIME_NO_MILLIS;
        }
        if ("tTime".equals(input) || "t_time".equals(input)) {
            return T_TIME;
        }
        if ("tTimeNoMillis".equals(input) || "t_time_no_millis".equals(input)) {
            return T_TIME_NO_MILLIS;
        }
        if ("weekDate".equals(input) || "week_date".equals(input)) {
            return WEEK_DATE;
        }
        if ("weekDateTime".equals(input) || "week_date_time".equals(input)) {
            return WEEK_DATE_TIME;
        }
        if ("weekDateTimeNoMillis".equals(input) || "week_date_time_no_millis".equals(input)) {
            return WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("weekyear".equals(input) || "week_year".equals(input)) {
            return WEEK_YEAR;
        }
        if ("weekyearWeek".equals(input) || "weekyear_week".equals(input)) {
            return WEEKYEAR_WEEK;
        }
        if ("weekyearWeekDay".equals(input) || "weekyear_week_day".equals(input)) {
            return WEEKYEAR_WEEK_DAY;
        }
        if ("year".equals(input)) {
            return YEAR;
        }
        if ("yearMonth".equals(input) || "year_month".equals(input)) {
            return YEAR_MONTH;
        }
        if ("yearMonthDay".equals(input) || "year_month_day".equals(input)) {
            return YEAR_MONTH_DAY;
        }
        if ("epoch_second".equals(input)) {
            return EpochSecondsDateFormatter.INSTANCE;
        }
        if ("epoch_millis".equals(input)) {
            return EpochMillisDateFormatter.INSTANCE;
        }
        if ("strictBasicWeekDate".equals(input) || "strict_basic_week_date".equals(input)) {
            return STRICT_BASIC_WEEK_DATE;
        }
        if ("strictBasicWeekDateTime".equals(input) || "strict_basic_week_date_time".equals(input)) {
            return STRICT_BASIC_WEEK_DATE_TIME;
        }
        if ("strictBasicWeekDateTimeNoMillis".equals(input) || "strict_basic_week_date_time_no_millis".equals(input)) {
            return STRICT_BASIC_WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("strictDate".equals(input) || "strict_date".equals(input)) {
            return STRICT_DATE;
        }
        if ("strictDateHour".equals(input) || "strict_date_hour".equals(input)) {
            return STRICT_DATE_HOUR;
        }
        if ("strictDateHourMinute".equals(input) || "strict_date_hour_minute".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE;
        }
        if ("strictDateHourMinuteSecond".equals(input) || "strict_date_hour_minute_second".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE_SECOND;
        }
        if ("strictDateHourMinuteSecondFraction".equals(input) || "strict_date_hour_minute_second_fraction".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE_SECOND_FRACTION;
        }
        if ("strictDateHourMinuteSecondMillis".equals(input) || "strict_date_hour_minute_second_millis".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("strictDateOptionalTime".equals(input) || "strict_date_optional_time".equals(input)) {
            return STRICT_DATE_OPTIONAL_TIME;
        }
        if ("strictDateOptionalTimeNanos".equals(input) || "strict_date_optional_time_nanos".equals(input)) {
            return STRICT_DATE_OPTIONAL_TIME_NANOS;
        }
        if ("strictDateTime".equals(input) || "strict_date_time".equals(input)) {
            return STRICT_DATE_TIME;
        }
        if ("strictDateTimeNoMillis".equals(input) || "strict_date_time_no_millis".equals(input)) {
            return STRICT_DATE_TIME_NO_MILLIS;
        }
        if ("strictHour".equals(input) || "strict_hour".equals(input)) {
            return STRICT_HOUR;
        }
        if ("strictHourMinute".equals(input) || "strict_hour_minute".equals(input)) {
            return STRICT_HOUR_MINUTE;
        }
        if ("strictHourMinuteSecond".equals(input) || "strict_hour_minute_second".equals(input)) {
            return STRICT_HOUR_MINUTE_SECOND;
        }
        if ("strictHourMinuteSecondFraction".equals(input) || "strict_hour_minute_second_fraction".equals(input)) {
            return STRICT_HOUR_MINUTE_SECOND_FRACTION;
        }
        if ("strictHourMinuteSecondMillis".equals(input) || "strict_hour_minute_second_millis".equals(input)) {
            return STRICT_HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("strictOrdinalDate".equals(input) || "strict_ordinal_date".equals(input)) {
            return STRICT_ORDINAL_DATE;
        }
        if ("strictOrdinalDateTime".equals(input) || "strict_ordinal_date_time".equals(input)) {
            return STRICT_ORDINAL_DATE_TIME;
        }
        if ("strictOrdinalDateTimeNoMillis".equals(input) || "strict_ordinal_date_time_no_millis".equals(input)) {
            return STRICT_ORDINAL_DATE_TIME_NO_MILLIS;
        }
        if ("strictTime".equals(input) || "strict_time".equals(input)) {
            return STRICT_TIME;
        }
        if ("strictTimeNoMillis".equals(input) || "strict_time_no_millis".equals(input)) {
            return STRICT_TIME_NO_MILLIS;
        }
        if ("strictTTime".equals(input) || "strict_t_time".equals(input)) {
            return STRICT_T_TIME;
        }
        if ("strictTTimeNoMillis".equals(input) || "strict_t_time_no_millis".equals(input)) {
            return STRICT_T_TIME_NO_MILLIS;
        }
        if ("strictWeekDate".equals(input) || "strict_week_date".equals(input)) {
            return STRICT_WEEK_DATE;
        }
        if ("strictWeekDateTime".equals(input) || "strict_week_date_time".equals(input)) {
            return STRICT_WEEK_DATE_TIME;
        }
        if ("strictWeekDateTimeNoMillis".equals(input) || "strict_week_date_time_no_millis".equals(input)) {
            return STRICT_WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("strictWeekyear".equals(input) || "strict_weekyear".equals(input)) {
            return STRICT_WEEKYEAR;
        }
        if ("strictWeekyearWeek".equals(input) || "strict_weekyear_week".equals(input)) {
            return STRICT_WEEKYEAR_WEEK;
        }
        if ("strictWeekyearWeekDay".equals(input) || "strict_weekyear_week_day".equals(input)) {
            return STRICT_WEEKYEAR_WEEK_DAY;
        }
        if ("strictYear".equals(input) || "strict_year".equals(input)) {
            return STRICT_YEAR;
        }
        if ("strictYearMonth".equals(input) || "strict_year_month".equals(input)) {
            return STRICT_YEAR_MONTH;
        }
        if ("strictYearMonthDay".equals(input) || "strict_year_month_day".equals(input)) {
            return STRICT_YEAR_MONTH_DAY;
        }
        try {
            return new JavaDateFormatter(input, new DateTimeFormatterBuilder().appendPattern(input).toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid format: [" + input + "]: " + e.getMessage(), e);
        }
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor accessor) {
        return DateFormatters.toZonedDateTime(accessor, EPOCH_ZONED_DATE_TIME);
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor accessor, ZonedDateTime defaults) {
        try {
            return ZonedDateTime.from(accessor);
        }
        catch (DateTimeException dateTimeException) {
            ZonedDateTime result = defaults;
            if (accessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                result = result.with(ChronoField.INSTANT_SECONDS, accessor.getLong(ChronoField.INSTANT_SECONDS));
                if (accessor.isSupported(ChronoField.NANO_OF_SECOND)) {
                    result = result.with(ChronoField.NANO_OF_SECOND, accessor.getLong(ChronoField.NANO_OF_SECOND));
                }
                return result;
            }
            if (accessor.isSupported(ChronoField.YEAR)) {
                result = result.with(ChronoField.YEAR, accessor.getLong(ChronoField.YEAR));
            } else if (accessor.isSupported(ChronoField.YEAR_OF_ERA)) {
                result = result.with(ChronoField.YEAR_OF_ERA, accessor.getLong(ChronoField.YEAR_OF_ERA));
            } else {
                if (accessor.isSupported(WeekFields.ISO.weekBasedYear())) {
                    if (accessor.isSupported(WeekFields.ISO.weekOfWeekBasedYear())) {
                        return LocalDate.from(result).with(WeekFields.ISO.weekBasedYear(), accessor.getLong(WeekFields.ISO.weekBasedYear())).withDayOfMonth(1).with(WeekFields.ISO.weekOfWeekBasedYear(), accessor.getLong(WeekFields.ISO.weekOfWeekBasedYear())).atStartOfDay(ZoneOffset.UTC);
                    }
                    return LocalDate.from(result).with(WeekFields.ISO.weekBasedYear(), accessor.getLong(WeekFields.ISO.weekBasedYear())).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)).atStartOfDay(defaults.getZone());
                }
                if (accessor.isSupported(IsoFields.WEEK_BASED_YEAR)) {
                    result = result.with(IsoFields.WEEK_BASED_YEAR, accessor.getLong(IsoFields.WEEK_BASED_YEAR));
                    if (accessor.isSupported(IsoFields.WEEK_OF_WEEK_BASED_YEAR)) {
                        result = result.with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, accessor.getLong(IsoFields.WEEK_OF_WEEK_BASED_YEAR));
                    }
                    return result;
                }
            }
            if (accessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                result = result.with(ChronoField.MONTH_OF_YEAR, accessor.getLong(ChronoField.MONTH_OF_YEAR));
            }
            if (accessor.isSupported(ChronoField.DAY_OF_MONTH)) {
                result = result.with(ChronoField.DAY_OF_MONTH, accessor.getLong(ChronoField.DAY_OF_MONTH));
            }
            if (accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                result = result.with(ChronoField.HOUR_OF_DAY, accessor.getLong(ChronoField.HOUR_OF_DAY));
            }
            if (accessor.isSupported(ChronoField.MINUTE_OF_HOUR)) {
                result = result.with(ChronoField.MINUTE_OF_HOUR, accessor.getLong(ChronoField.MINUTE_OF_HOUR));
            }
            if (accessor.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                result = result.with(ChronoField.SECOND_OF_MINUTE, accessor.getLong(ChronoField.SECOND_OF_MINUTE));
            }
            if (accessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                result = result.withZoneSameLocal(ZoneOffset.ofTotalSeconds(accessor.get(ChronoField.OFFSET_SECONDS)));
            }
            if (accessor.isSupported(ChronoField.MILLI_OF_SECOND)) {
                result = result.with(ChronoField.MILLI_OF_SECOND, accessor.getLong(ChronoField.MILLI_OF_SECOND));
            }
            if (accessor.isSupported(ChronoField.NANO_OF_SECOND)) {
                result = result.with(ChronoField.NANO_OF_SECOND, accessor.getLong(ChronoField.NANO_OF_SECOND));
            }
            return result;
        }
    }

    static {
        STRICT_HOUR_MINUTE_SECOND_FRACTION = STRICT_HOUR_MINUTE_SECOND_MILLIS = new JavaDateFormatter("strict_hour_minute_second_millis", STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER, STRICT_HOUR_MINUTE_SECOND_MILLIS_FORMATTER);
        STRICT_DATE_HOUR_MINUTE_SECOND_MILLIS = STRICT_DATE_HOUR_MINUTE_SECOND_FRACTION = new JavaDateFormatter("strict_date_hour_minute_second_fraction", new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").append(STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT));
        STRICT_HOUR = new JavaDateFormatter("strict_hour", DateTimeFormatter.ofPattern("HH", Locale.ROOT), new DateTimeFormatter[0]);
        STRICT_HOUR_MINUTE = new JavaDateFormatter("strict_hour_minute", DateTimeFormatter.ofPattern("HH:mm", Locale.ROOT), new DateTimeFormatter[0]);
        STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3, 3, SignStyle.NOT_NEGATIVE).appendLiteral('T').appendPattern("HH:mm").optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().toFormatter(Locale.ROOT);
        STRICT_ORDINAL_DATE_TIME = new JavaDateFormatter("strict_ordinal_date_time", new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_TIME_FORMATTER_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
        STRICT_TIME_PRINTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
        STRICT_TIME = new JavaDateFormatter("strict_time", new DateTimeFormatterBuilder().append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_T_TIME = new JavaDateFormatter("strict_t_time", new DateTimeFormatterBuilder().appendLiteral('T').append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral('T').append(STRICT_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral('T').append(STRICT_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        STRICT_TIME_NO_MILLIS = new JavaDateFormatter("strict_time_no_millis", new DateTimeFormatterBuilder().append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_T_TIME_NO_MILLIS = new JavaDateFormatter("strict_t_time_no_millis", new DateTimeFormatterBuilder().appendLiteral("T").append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(STRICT_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        ISO_WEEK_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_WEEK, 1).toFormatter(Locale.ROOT);
        ISO_WEEK_DATE_T = new DateTimeFormatterBuilder().append(ISO_WEEK_DATE).appendLiteral('T').toFormatter(Locale.ROOT);
        STRICT_WEEK_DATE = new JavaDateFormatter("strict_week_date", ISO_WEEK_DATE, new DateTimeFormatter[0]);
        STRICT_WEEK_DATE_TIME_NO_MILLIS = new JavaDateFormatter("strict_week_date_time_no_millis", new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_WEEK_DATE_TIME = new JavaDateFormatter("strict_week_date_time", new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_WEEKYEAR = new JavaDateFormatter("strict_weekyear", new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear(), 4, 10, SignStyle.EXCEEDS_PAD).toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
        STRICT_WEEKYEAR_WEEK_FORMATTER = new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear(), 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(WeekFields.ISO.weekOfWeekBasedYear(), 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        STRICT_WEEKYEAR_WEEK = new JavaDateFormatter("strict_weekyear_week", STRICT_WEEKYEAR_WEEK_FORMATTER, new DateTimeFormatter[0]);
        STRICT_WEEKYEAR_WEEK_DAY = new JavaDateFormatter("strict_weekyear_week_day", new DateTimeFormatterBuilder().append(STRICT_WEEKYEAR_WEEK_FORMATTER).appendLiteral("-").appendValue(WeekFields.ISO.dayOfWeek()).toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
        STRICT_DATE_HOUR_MINUTE_SECOND = new JavaDateFormatter("strict_date_hour_minute_second", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss", Locale.ROOT), new DateTimeFormatter[0]);
        BASIC_DATE = new JavaDateFormatter("basic_date", new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 4, SignStyle.NORMAL).appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC), new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 4, SignStyle.NORMAL).appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC));
        STRICT_ORDINAL_DATE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3).optionalStart().toFormatter(Locale.ROOT);
        STRICT_ORDINAL_DATE = new JavaDateFormatter("strict_ordinal_date", STRICT_ORDINAL_DATE_FORMATTER, new DateTimeFormatter[0]);
        DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 5, SignStyle.NORMAL).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).optionalEnd().optionalEnd().toFormatter(Locale.ROOT);
        HOUR_MINUTE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        DATE_OPTIONAL_TIME = new JavaDateFormatter("date_optional_time", STRICT_DATE_OPTIONAL_TIME_FORMATTER_1, new DateTimeFormatterBuilder().append(DATE_FORMATTER).optionalStart().appendLiteral('T').optionalStart().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalEnd().optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalEnd().optionalEnd().optionalEnd().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_FORMATTER).optionalStart().appendLiteral('T').optionalStart().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalEnd().optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().optionalStart().appendOffset("+HHmm", "Z").optionalEnd().optionalEnd().optionalEnd().optionalEnd().toFormatter(Locale.ROOT));
        HOUR_MINUTE_SECOND_FORMATTER = new DateTimeFormatterBuilder().append(HOUR_MINUTE_FORMATTER).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        HOUR_MINUTE_SECOND_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
        ORDINAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 1, 3, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        ORDINAL_DATE_PRINTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3, 3, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        ORDINAL_DATE = new JavaDateFormatter("ordinal_date", ORDINAL_DATE_PRINTER, ORDINAL_DATE_FORMATTER);
        TIME_NO_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        T_TIME_NO_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendLiteral("T").append(TIME_NO_MILLIS_FORMATTER).toFormatter(Locale.ROOT);
        TIME_PREFIX = new DateTimeFormatterBuilder().append(TIME_NO_MILLIS_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
        WEEK_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendValue(ChronoField.DAY_OF_WEEK, 1).toFormatter(Locale.ROOT);
        WEEK_YEAR = new JavaDateFormatter("week_year", new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear()).toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
        YEAR = new JavaDateFormatter("year", new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR).toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
        DATE_HOUR = new JavaDateFormatter("date_hour", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH", Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT));
        DATE_HOUR_MINUTE_SECOND_FRACTION = DATE_HOUR_MINUTE_SECOND_MILLIS = new JavaDateFormatter("date_hour_minute_second_millis", new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").append(STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").append(HOUR_MINUTE_SECOND_MILLIS_FORMATTER).toFormatter(Locale.ROOT));
        DATE_HOUR_MINUTE = new JavaDateFormatter("date_hour_minute", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm", Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").append(HOUR_MINUTE_FORMATTER).toFormatter(Locale.ROOT));
        DATE_HOUR_MINUTE_SECOND = new JavaDateFormatter("date_hour_minute_second", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss", Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").append(HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT));
        DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().toFormatter(Locale.ROOT);
        DATE_TIME = new JavaDateFormatter("date_time", STRICT_DATE_OPTIONAL_TIME_FORMATTER_1, new DateTimeFormatterBuilder().append(DATE_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        BASIC_WEEK_DATE = new JavaDateFormatter("basic_week_date", STRICT_BASIC_WEEK_DATE_PRINTER, BASIC_WEEK_DATE_FORMATTER);
        DATE = new JavaDateFormatter("date", DateTimeFormatter.ISO_LOCAL_DATE.withResolverStyle(ResolverStyle.LENIENT), DATE_FORMATTER);
        DATE_TIME_NO_MILLIS_PRINTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE.withResolverStyle(ResolverStyle.LENIENT)).appendLiteral('T').appendPattern("HH:mm").appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendZoneId().toFormatter(Locale.ROOT);
        DATE_TIME_PREFIX = new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalEnd().toFormatter(Locale.ROOT);
        DATE_TIME_NO_MILLIS = new JavaDateFormatter("date_time_no_millis", DATE_TIME_NO_MILLIS_PRINTER, new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).optionalStart().append(TIME_ZONE_FORMATTER_NO_COLON).optionalEnd().toFormatter(Locale.ROOT));
        HOUR_MINUTE_SECOND_MILLIS = new JavaDateFormatter("hour_minute_second_millis", STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER, HOUR_MINUTE_SECOND_MILLIS_FORMATTER);
        HOUR_MINUTE = new JavaDateFormatter("hour_minute", DateTimeFormatter.ofPattern("HH:mm", Locale.ROOT), HOUR_MINUTE_FORMATTER);
        HOUR_MINUTE_SECOND = new JavaDateFormatter("hour_minute_second", STRICT_HOUR_MINUTE_SECOND_FORMATTER, new DateTimeFormatterBuilder().append(HOUR_MINUTE_FORMATTER).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT));
        HOUR = new JavaDateFormatter("hour", DateTimeFormatter.ofPattern("HH", Locale.ROOT), new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT));
        ORDINAL_DATE_TIME_FORMATTER_BASE = new DateTimeFormatterBuilder().append(ORDINAL_DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().toFormatter(Locale.ROOT);
        ORDINAL_DATE_TIME = new JavaDateFormatter("ordinal_date_time", new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        ORDINAL_DATE_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().append(ORDINAL_DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT);
        ORDINAL_DATE_TIME_NO_MILLIS = new JavaDateFormatter("ordinal_date_time_no_millis", new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        WEEK_DATE_TIME = new JavaDateFormatter("week_date_time", new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).appendLiteral("T").append(TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).appendLiteral("T").append(TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        WEEK_DATE_TIME_NO_MILLIS = new JavaDateFormatter("week_date_time_no_millis", new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).append(T_TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).append(T_TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        BASIC_WEEK_DATE_TIME = new JavaDateFormatter("basic_week_date_time", new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_PRINTER).append(DateTimeFormatter.ofPattern("'T'HHmmss.SSSX", Locale.ROOT)).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).append(BASIC_T_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).append(BASIC_T_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        BASIC_WEEK_DATE_TIME_NO_MILLIS = new JavaDateFormatter("basic_week_date_time_no_millis", new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_PRINTER).append(DateTimeFormatter.ofPattern("'T'HHmmssX", Locale.ROOT)).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        TIME = new JavaDateFormatter("time", new DateTimeFormatterBuilder().append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        TIME_NO_MILLIS = new JavaDateFormatter("time_no_millis", new DateTimeFormatterBuilder().append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        T_TIME = new JavaDateFormatter("t_time", new DateTimeFormatterBuilder().appendLiteral('T').append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        T_TIME_NO_MILLIS = new JavaDateFormatter("t_time_no_millis", new DateTimeFormatterBuilder().appendLiteral("T").append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(T_TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(T_TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        YEAR_MONTH = new JavaDateFormatter("year_month", new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR).toFormatter(Locale.ROOT));
        YEAR_MONTH_DAY = new JavaDateFormatter("year_month_day", STRICT_YEAR_MONTH_DAY_FORMATTER, new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH).toFormatter(Locale.ROOT));
        WEEK_DATE = new JavaDateFormatter("week_date", ISO_WEEK_DATE, WEEK_DATE_FORMATTER);
        WEEKYEAR_WEEK = new JavaDateFormatter("weekyear_week", STRICT_WEEKYEAR_WEEK_FORMATTER, new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear()).appendLiteral("-W").appendValue(WeekFields.ISO.weekOfWeekBasedYear()).toFormatter(Locale.ROOT));
        WEEKYEAR_WEEK_DAY = new JavaDateFormatter("weekyear_week_day", new DateTimeFormatterBuilder().append(STRICT_WEEKYEAR_WEEK_FORMATTER).appendLiteral("-").appendValue(WeekFields.ISO.dayOfWeek()).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear()).appendLiteral("-W").appendValue(WeekFields.ISO.weekOfWeekBasedYear()).appendLiteral("-").appendValue(WeekFields.ISO.dayOfWeek()).toFormatter(Locale.ROOT));
        EPOCH_ZONED_DATE_TIME = Instant.EPOCH.atZone(ZoneOffset.UTC);
    }

    static class MergedDateFormatter
    implements DateFormatter {
        private final String pattern;
        final List<DateFormatter> formatters;
        private final List<DateMathParser> dateMathParsers;

        MergedDateFormatter(String pattern, List<DateFormatter> formatters) {
            assert (formatters.size() > 0);
            this.pattern = pattern;
            this.formatters = Collections.unmodifiableList(formatters);
            this.dateMathParsers = formatters.stream().map(DateFormatter::toDateMathParser).collect(Collectors.toList());
        }

        @Override
        public TemporalAccessor parse(String input) {
            Throwable failure = null;
            for (DateFormatter formatter : this.formatters) {
                try {
                    return formatter.parse(input);
                }
                catch (IllegalArgumentException | DateTimeParseException e) {
                    if (failure == null) {
                        failure = new IllegalArgumentException("failed to parse date field [" + input + "] with format [" + this.pattern + "]", e);
                        continue;
                    }
                    failure.addSuppressed(e);
                }
            }
            throw failure;
        }

        @Override
        public DateFormatter withZone(ZoneId zoneId) {
            return new MergedDateFormatter(this.pattern, this.formatters.stream().map(f -> f.withZone(zoneId)).collect(Collectors.toList()));
        }

        @Override
        public DateFormatter withLocale(Locale locale) {
            return new MergedDateFormatter(this.pattern, this.formatters.stream().map(f -> f.withLocale(locale)).collect(Collectors.toList()));
        }

        @Override
        public String format(TemporalAccessor accessor) {
            return this.formatters.get(0).format(accessor);
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public Locale locale() {
            return this.formatters.get(0).locale();
        }

        @Override
        public ZoneId zone() {
            return this.formatters.get(0).zone();
        }

        @Override
        public DateMathParser toDateMathParser() {
            return (text, now, roundUp, tz) -> {
                Throwable failure = null;
                for (DateMathParser parser : this.dateMathParsers) {
                    try {
                        return parser.parse(text, now, roundUp, tz);
                    }
                    catch (ElasticsearchParseException e) {
                        if (failure == null) {
                            failure = new ElasticsearchParseException("failed to parse date field [" + text + "] with format [" + this.pattern + "]", (Throwable)e, new Object[0]);
                            continue;
                        }
                        failure.addSuppressed(e);
                    }
                }
                throw failure;
            };
        }
    }
}

