/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.closeout;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutService;
import org.kuali.kra.award.paymentreports.closeout.CloseoutReportTypeValuesFinder;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.PersistenceService;

public class AwardCloseoutServiceImpl
implements AwardCloseoutService {
    private static final String REPORT_OBJECT = "report";
    private static final String FREQUENCY_OBJECT = "frequency";
    private static final String MULTIPLE = "M";
    private PersistenceService persistenceService;
    private DateTimeService dateTimeService;

    protected void updateCloseoutDueDate(Map<String, Object> closeoutDueDates, Date dateCalculatedUsingFrequency, boolean allDueDatesAreEqual, String closeoutReportTypeCode) {
        if (allDueDatesAreEqual) {
            closeoutDueDates.put(closeoutReportTypeCode, new java.sql.Date(dateCalculatedUsingFrequency.getTime()));
        } else {
            closeoutDueDates.put(closeoutReportTypeCode, MULTIPLE);
        }
    }

    protected Date getCalculatedDueDate(java.sql.Date finalExpirationDate, AwardReportTerm awardReportTerm, Calendar calendar) {
        Frequency frequency = awardReportTerm.getFrequency();
        if (frequency != null) {
            if (frequency.getNumberOfDays() != null) {
                calendar.add(6, frequency.getNumberOfDays());
            }
            if (frequency.getNumberOfMonths() != null) {
                calendar.add(2, frequency.getNumberOfMonths());
            }
            if (frequency.getAdvanceNumberOfDays() != null) {
                calendar.add(6, -frequency.getAdvanceNumberOfDays().intValue());
            }
            if (frequency.getAdvanceNumberOfMonths() != null) {
                calendar.add(2, -frequency.getAdvanceNumberOfMonths().intValue());
            }
        }
        return calendar.getTime();
    }

    protected void assignedDueDatesOnAwardCloseouts(List<AwardCloseout> awardCloseoutItems, Map<String, Object> closeoutDueDates) {
        for (AwardCloseout awardCloseout : awardCloseoutItems) {
            if (!closeoutDueDates.containsKey(awardCloseout.getCloseoutReportCode())) continue;
            if (closeoutDueDates.get(awardCloseout.getCloseoutReportCode()) instanceof java.sql.Date) {
                awardCloseout.setDueDate((java.sql.Date)closeoutDueDates.get(awardCloseout.getCloseoutReportCode()));
                awardCloseout.setMultiple(false);
                continue;
            }
            if (closeoutDueDates.get(awardCloseout.getCloseoutReportCode()) == null) {
                awardCloseout.setDueDate(null);
                awardCloseout.setMultiple(false);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)MULTIPLE, (CharSequence)((String)closeoutDueDates.get(awardCloseout.getCloseoutReportCode())))) continue;
            awardCloseout.setMultiple(true);
        }
    }

    protected List<AwardReportTerm> filterAwardReportTerms(List<AwardReportTerm> awardReportTermItems, String reportClassCode) {
        ArrayList<AwardReportTerm> filteredAwardReportTerms = new ArrayList<AwardReportTerm>();
        for (AwardReportTerm awardReportTerm : awardReportTermItems) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)awardReportTerm.getReportClassCode(), (CharSequence)reportClassCode) || awardReportTerm.getReport() == null || !awardReportTerm.getReport().getFinalReportFlag()) continue;
            filteredAwardReportTerms.add(awardReportTerm);
        }
        return filteredAwardReportTerms;
    }

    protected void refreshAwardReportTerms(List<AwardReportTerm> awardReportTerms) {
        ArrayList<AwardReportTerm> persistableObjects = new ArrayList<AwardReportTerm>();
        ArrayList<String> referenceObjectNames = new ArrayList<String>();
        ArrayList<String> referenceObjectNames1 = new ArrayList<String>();
        for (AwardReportTerm awardReportTerm : awardReportTerms) {
            persistableObjects.add(awardReportTerm);
            referenceObjectNames.add(REPORT_OBJECT);
            referenceObjectNames1.add(FREQUENCY_OBJECT);
        }
        if (persistableObjects.size() > 0 && referenceObjectNames.size() > 0) {
            this.getPersistenceService().retrieveReferenceObjects(persistableObjects, referenceObjectNames);
        }
        if (persistableObjects.size() > 0 && referenceObjectNames1.size() > 0) {
            this.getPersistenceService().retrieveReferenceObjects(persistableObjects, referenceObjectNames1);
        }
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    @Override
    public void updateCloseoutDueDatesBeforeSave(Award award) {
        HashMap<String, Object> closeoutDueDates = new HashMap<String, Object>();
        java.sql.Date finalExpirationDate = award.getAwardAmountInfos().get(award.getIndexOfLastAwardAmountInfo()).getFinalExpirationDate();
        this.refreshAwardReportTerms(award.getAwardReportTermItems());
        for (KeyValue kl : new CloseoutReportTypeValuesFinder().getKeyValues()) {
            String closeoutReportTypeCode = kl.getKey().toString();
            boolean allDueDatesAreEqual = true;
            Date dateCalculatedUsingFrequency = null;
            List<AwardReportTerm> awardReportTerms = this.filterAwardReportTerms(award.getAwardReportTermItems(), closeoutReportTypeCode);
            if (awardReportTerms.size() == 0) {
                closeoutDueDates.put(closeoutReportTypeCode, null);
                continue;
            }
            Calendar calendar = this.getDateTimeService().getCalendar((Date)finalExpirationDate);
            Date dueDate = null;
            for (AwardReportTerm awardReportTerm : awardReportTerms) {
                dateCalculatedUsingFrequency = this.getCloseoutDueDate(finalExpirationDate, awardReportTerm, calendar);
                if (dueDate != null && !dueDate.equals(dateCalculatedUsingFrequency)) {
                    allDueDatesAreEqual = false;
                    break;
                }
                dueDate = dateCalculatedUsingFrequency;
            }
            if (dateCalculatedUsingFrequency == null) continue;
            this.updateCloseoutDueDate(closeoutDueDates, dateCalculatedUsingFrequency, allDueDatesAreEqual, closeoutReportTypeCode);
        }
        this.assignedDueDatesOnAwardCloseouts(award.getAwardCloseoutItems(), closeoutDueDates);
    }

    protected Date getCloseoutDueDate(java.sql.Date finalExpirationDate, AwardReportTerm awardReportTerm, Calendar calendar) {
        Date dueDate = calendar.getTime();
        if (awardReportTerm.getDueDate() != null) {
            dueDate = awardReportTerm.getDueDate();
        } else if (awardReportTerm.getFrequency() != null && (awardReportTerm.getFrequency().getNumberOfMonths() != null || awardReportTerm.getFrequency().getNumberOfDays() != null || awardReportTerm.getFrequency().getAdvanceNumberOfMonths() != null || awardReportTerm.getFrequency().getAdvanceNumberOfDays() != null)) {
            dueDate = this.getCalculatedDueDate(finalExpirationDate, awardReportTerm, (Calendar)calendar.clone());
        }
        return dueDate;
    }
}

