/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.docperm.DocumentAccess;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.medusa.MedusaService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.PropDevLookupableHelperService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyStatusConstants;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.lookup.LookupableImpl;
import org.kuali.rice.krad.service.impl.LookupCriteriaGenerator;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="propDevLookupableHelperService")
@Scope(value="prototype")
public class PropDevLookupableHelperServiceImpl
extends LookupableImpl
implements PropDevLookupableHelperService {
    private static final long serialVersionUID = 1L;
    private static final int SMALL_NUMBER_OF_RESULTS = 4;
    private static final int IN_OP_LIMIT = 1000;
    private static final String INITIATOR = "initiator";
    private static final String PRINCIPAL_INVESTIGATOR_NAME = "principalInvestigatorName";
    private static final String HIERARCHY_STATUS = "hierarchyStatus";
    private static final String PROPOSAL_PERSON = "proposalPerson";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String AGGREGATOR = "aggregator";
    private static final String PARTICIPANT = "participant";
    private static final String PROPOSAL_DOCUMENT_DOCUMENT_NUMBER = "proposalDocument.documentNumber";
    private static final String STATUS_CODE = "proposalStateTypeCode";
    private static final String LAST_NAME = "lastName";
    private static final String PERSON_ID = "personId";
    private static final String USER_NAME = "userName";
    private static final String PROPOSAL_PERSON_ROLE_ID = "proposalPersonRoleId";
    private static final String PRINCIPAL_ID = "principalId";
    private static final String NAMESPACE_CODE = "namespaceCode";
    private static final String ROLE_NAME = "roleName";
    private static final String PROPOSAL_DEVELOPMENT_DOCUMENT = "ProposalDevelopmentDocument";
    public static final String OSP_ADMIN_USERNAME_PATH = "ownedByUnit.unitAdministrators.person.userName";
    public static final String OSP_ADMIN_PERSON_ID_PATH = "ownedByUnit.unitAdministrators.personId";
    public static final String OSP_ADMIN_TYPE_CODE_PATH = "ownedByUnit.unitAdministrators.unitAdministratorTypeCode";
    public static final String OSP_ADMIN_TYPE_CODE_VALUE = "2";
    public static final String SEARCH_RESULT_FILTERING_PARAMETER_NAME = "Proposal_Search_Permissions_Filter";
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kcAuthorizationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="documentTypeService")
    private DocumentTypeService documentTypeService;
    @Autowired
    @Qualifier(value="kewWorkflowDocumentService")
    private WorkflowDocumentService workflowDocumentService;
    @Autowired
    @Qualifier(value="lookupCriteriaGenerator")
    private LookupCriteriaGenerator lookupCriteriaGenerator;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="medusaService")
    private MedusaService medusaService;

    protected Collection<?> executeSearch(Map<String, String> adjustedSearchCriteria, List<String> wildcardAsLiteralSearchCriteria, boolean bounded, Integer searchResultsLimit) {
        List<DevelopmentProposal> filteredProposals;
        if (StringUtils.isNotEmpty((CharSequence)adjustedSearchCriteria.get(OSP_ADMIN_USERNAME_PATH))) {
            Person person = this.personService.getPersonByPrincipalName(adjustedSearchCriteria.get(OSP_ADMIN_USERNAME_PATH));
            if (person != null) {
                adjustedSearchCriteria.put(OSP_ADMIN_PERSON_ID_PATH, person.getPrincipalId());
                adjustedSearchCriteria.put(OSP_ADMIN_TYPE_CODE_PATH, OSP_ADMIN_TYPE_CODE_VALUE);
            } else {
                return Collections.emptyList();
            }
        }
        HashMap<String, String> modifiedSearchCriteria = new HashMap<String, String>();
        modifiedSearchCriteria.putAll(adjustedSearchCriteria);
        String proposalNumberCriteria = adjustedSearchCriteria.get(PROPOSAL_NUMBER);
        boolean proposalNumberWildcarded = false;
        if (!StringUtils.isEmpty((CharSequence)proposalNumberCriteria) && proposalNumberCriteria.contains("*")) {
            proposalNumberWildcarded = true;
        }
        List<Object> documentNumbers = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)proposalNumberCriteria) || proposalNumberWildcarded) {
            String principalInvestigatorName = adjustedSearchCriteria.get(PRINCIPAL_INVESTIGATOR_NAME);
            String proposalPerson = adjustedSearchCriteria.get(PROPOSAL_PERSON);
            String initiator = adjustedSearchCriteria.get(INITIATOR);
            String participant = adjustedSearchCriteria.get(PARTICIPANT);
            String aggregator = adjustedSearchCriteria.get(AGGREGATOR);
            List<String> piProposals = this.getPiDocumentNumbers(principalInvestigatorName);
            List<String> personProposals = this.getProposalPersonDocumentNumbers(proposalPerson);
            List<String> initiatorProposals = this.getInitiatorDocumentNumbers(initiator);
            List<String> aggregatorProposals = this.getAggregatorDocumentNumbers(aggregator);
            Set<String> participantProposals = this.getParticipantDocumentNumbers(participant);
            if (!StringUtils.isEmpty((CharSequence)principalInvestigatorName) && piProposals.isEmpty() || !StringUtils.isEmpty((CharSequence)proposalPerson) && personProposals.isEmpty() || !StringUtils.isEmpty((CharSequence)initiator) && initiatorProposals.isEmpty() || !StringUtils.isEmpty((CharSequence)aggregator) && aggregatorProposals.isEmpty() || !StringUtils.isEmpty((CharSequence)participant) && participantProposals.isEmpty()) {
                return new ArrayList();
            }
            documentNumbers = this.intersectCollections(piProposals, personProposals, initiatorProposals, aggregatorProposals, participantProposals);
            if (documentNumbers.size() > 1000) {
                documentNumbers = documentNumbers.subList(0, 999);
            }
        }
        modifiedSearchCriteria.remove(PROPOSAL_PERSON);
        modifiedSearchCriteria.remove(INITIATOR);
        modifiedSearchCriteria.remove(PRINCIPAL_INVESTIGATOR_NAME);
        modifiedSearchCriteria.remove(PARTICIPANT);
        modifiedSearchCriteria.remove(AGGREGATOR);
        String hierarchyAwareProposalStatusCode = (String)modifiedSearchCriteria.remove("hierarchyAwareProposalStatus.code");
        QueryByCriteria.Builder query = this.lookupCriteriaGenerator.generateCriteria(DevelopmentProposal.class, modifiedSearchCriteria, wildcardAsLiteralSearchCriteria, this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(DevelopmentProposal.class, modifiedSearchCriteria));
        if (searchResultsLimit != null) {
            query.setMaxResults(Integer.valueOf(searchResultsLimit * 2));
        }
        if ((StringUtils.isBlank((CharSequence)proposalNumberCriteria) || proposalNumberWildcarded) && documentNumbers.size() > 0) {
            Predicate documentNumberPredicate = PredicateFactory.in((String)PROPOSAL_DOCUMENT_DOCUMENT_NUMBER, documentNumbers);
            if (modifiedSearchCriteria.size() > 0) {
                this.addPredicate(documentNumberPredicate, query);
            } else {
                query.setPredicates(new Predicate[]{documentNumberPredicate});
            }
        }
        java.util.function.Predicate<DevelopmentProposal> statusCodePredicate = ((java.util.function.Predicate<DevelopmentProposal>)proposal -> StringUtils.isBlank((CharSequence)hierarchyAwareProposalStatusCode)).or(proposal -> proposal.getHierarchyAwareProposalStatus().getCode().equals(hierarchyAwareProposalStatusCode));
        if (!StringUtils.isBlank((CharSequence)hierarchyAwareProposalStatusCode)) {
            Predicate queryPredicate = PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)STATUS_CODE, (Object)hierarchyAwareProposalStatusCode), PredicateFactory.notEqual((String)HIERARCHY_STATUS, (Object)HierarchyStatusConstants.Child.code())}), PredicateFactory.equal((String)HIERARCHY_STATUS, (Object)HierarchyStatusConstants.Child.code())});
            this.addPredicate(queryPredicate, query);
        }
        this.modifyCriteria(query);
        List<DevelopmentProposal> proposals = this.getDataObjectService().findMatching(DevelopmentProposal.class, query.build()).getResults().stream().filter(statusCodePredicate).distinct().collect(Collectors.toList());
        boolean filterResults = this.isPermissionFilteringEnabled();
        if (filterResults && CollectionUtils.isNotEmpty(proposals) && proposals.size() > 4) {
            filterResults = !this.canAccessAllProposals();
        }
        List<DevelopmentProposal> list = filteredProposals = filterResults ? this.filterPermissions(proposals) : proposals;
        if (searchResultsLimit != null && proposals.size() > searchResultsLimit) {
            return filteredProposals.subList(0, searchResultsLimit - 1);
        }
        return filteredProposals;
    }

    protected void addPredicate(Predicate predicate, QueryByCriteria.Builder query) {
        if (query.getPredicates().length != 0) {
            if (query.getPredicates()[0] instanceof AndPredicate && ((AndPredicate)query.getPredicates()[0]).getPredicates().size() == 0) {
                Predicate[] predicates = query.getPredicates();
                predicates[0] = predicate;
                query.setPredicates(predicates);
            } else {
                ArrayList<Predicate> predicateList = new ArrayList<Predicate>(Arrays.asList(query.getPredicates()));
                predicateList.add(predicate);
                query.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicateList.toArray(new Predicate[predicateList.size()]))});
            }
        } else {
            query.setPredicates(new Predicate[]{predicate});
        }
    }

    protected void modifyCriteria(QueryByCriteria.Builder query) {
    }

    protected boolean isPermissionFilteringEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-PD", "Document", SEARCH_RESULT_FILTERING_PARAMETER_NAME);
    }

    private List<DevelopmentProposal> filterPermissions(List<DevelopmentProposal> results) {
        List permissionables = results.stream().map(DevelopmentProposal::getProposalDocument).collect(Collectors.toList());
        return this.getKcAuthorizationService().filterForPermission(this.getGlobalVariableService().getUserSession().getPrincipalId(), permissionables, "KC-PD", "View Proposal").stream().map(ProposalDevelopmentDocument::getDevelopmentProposal).collect(Collectors.toList());
    }

    protected boolean canAccessAllProposals() {
        return this.hasPermissionTopUnitWithDescends();
    }

    protected boolean hasPermissionTopUnitWithDescends() {
        Unit top = this.unitService.getTopUnit();
        HashedMap qualifiers = new HashedMap();
        qualifiers.put("unitNumber", top.getUnitNumber());
        qualifiers.put("subunits", "Y");
        return this.permissionService.isAuthorized(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-PD", "Modify ProposalDevelopmentDocument", (Map)qualifiers) || this.permissionService.isAuthorized(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-PD", "View Proposal", (Map)qualifiers);
    }

    private List<String> getPiDocumentNumbers(String personSearchString) {
        if (StringUtils.isEmpty((CharSequence)personSearchString)) {
            return new ArrayList<String>();
        }
        ArrayList<String> piProposals = new ArrayList<String>();
        List proposalPersons = this.getDataObjectService().findMatching(ProposalPerson.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)PROPOSAL_PERSON_ROLE_ID, (Object)"PI"), this.buildProposalPersonOrPredicate(personSearchString)})).getResults();
        for (ProposalPerson person : proposalPersons) {
            piProposals.add(person.getDevelopmentProposal().getDocument().getDocumentNumber());
        }
        return piProposals;
    }

    private List<String> getProposalPersonDocumentNumbers(String personSearchString) {
        if (StringUtils.isEmpty((CharSequence)personSearchString)) {
            return new ArrayList<String>();
        }
        ArrayList<String> personProposals = new ArrayList<String>();
        List proposalPersons = this.getDataObjectService().findMatching(ProposalPerson.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{this.buildProposalPersonOrPredicate(personSearchString)})).getResults();
        for (ProposalPerson person : proposalPersons) {
            personProposals.add(person.getDevelopmentProposal().getDocument().getDocumentNumber());
        }
        return personProposals;
    }

    private Set<String> getParticipantDocumentNumbers(String personSearchString) {
        if (StringUtils.isEmpty((CharSequence)personSearchString)) {
            return new HashSet<String>();
        }
        HashSet<String> participantProposals = new HashSet<String>();
        ArrayList<String> propRoles = new ArrayList<String>();
        propRoles.add("PI");
        propRoles.add("COI");
        propRoles.add("MPI");
        Set<String> principalIds = this.getMatchingPrincipalIds(personSearchString);
        List proposalPersons = new ArrayList();
        if (!proposalPersons.isEmpty()) {
            proposalPersons = this.getDataObjectService().findMatching(ProposalPerson.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.in((String)PROPOSAL_PERSON_ROLE_ID, propRoles), PredicateFactory.in((String)PERSON_ID, principalIds)})).getResults();
        }
        for (ProposalPerson person : proposalPersons) {
            participantProposals.add(person.getDevelopmentProposal().getDocument().getDocumentNumber());
        }
        List<String> aggregatorDocumentNumbers = this.getAggregatorDocumentNumbers(personSearchString, principalIds);
        if (aggregatorDocumentNumbers != null) {
            participantProposals.addAll(aggregatorDocumentNumbers);
        }
        return participantProposals;
    }

    private List<String> getAggregatorDocumentNumbers(String personSearchString) {
        return this.getAggregatorDocumentNumbers(personSearchString, null);
    }

    private List<String> getAggregatorDocumentNumbers(String personSearchString, Collection<String> principalIds) {
        if (StringUtils.isEmpty((CharSequence)personSearchString)) {
            return new ArrayList<String>();
        }
        if (CollectionUtils.isEmpty(principalIds)) {
            principalIds = this.getMatchingPrincipalIds(personSearchString);
        }
        List accesses = new ArrayList();
        if (!principalIds.isEmpty()) {
            accesses = this.getDataObjectService().findMatching(DocumentAccess.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)ROLE_NAME, (Object)"Aggregator Document Level"), PredicateFactory.equal((String)NAMESPACE_CODE, (Object)"KC-PD"), PredicateFactory.in((String)PRINCIPAL_ID, principalIds)})).getResults();
        }
        ArrayList<String> documentNumbers = new ArrayList<String>();
        for (DocumentAccess access : accesses) {
            documentNumbers.add(access.getDocumentNumber());
        }
        return documentNumbers;
    }

    private Set<String> getMatchingPrincipalIds(String personSearchString) {
        HashSet<String> principalIds = new HashSet<String>();
        Person person = this.getPersonService().getPersonByPrincipalName(personSearchString);
        if (person != null) {
            principalIds.add(person.getPrincipalId());
        }
        if ((person = this.getPersonService().getPerson(personSearchString)) != null) {
            principalIds.add(person.getPrincipalId());
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(LAST_NAME, personSearchString);
        List persons = this.getPersonService().findPeople(criteria);
        for (Person p : persons) {
            principalIds.add(p.getPrincipalId());
        }
        return principalIds;
    }

    private List<String> getInitiatorDocumentNumbers(String initiator) {
        if (StringUtils.isEmpty((CharSequence)initiator)) {
            return new ArrayList<String>();
        }
        return this.getProposalDocumentIdsForInitiator(initiator);
    }

    private Predicate buildProposalPersonOrPredicate(String personSearchString) {
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
        orPredicates.add(PredicateFactory.likeIgnoreCase((String)USER_NAME, (CharSequence)personSearchString));
        orPredicates.add(PredicateFactory.likeIgnoreCase((String)PERSON_ID, (CharSequence)personSearchString));
        orPredicates.add(PredicateFactory.likeIgnoreCase((String)LAST_NAME, (CharSequence)personSearchString));
        return PredicateFactory.or((Predicate[])orPredicates.toArray(new Predicate[orPredicates.size()]));
    }

    private List<String> getProposalDocumentIdsForInitiator(String initiator) {
        ArrayList<String> documentIds = new ArrayList<String>();
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        builder.setInitiatorPrincipalName(initiator);
        builder.setDocumentTypeName(PROPOSAL_DEVELOPMENT_DOCUMENT);
        DocumentSearchResults results = this.workflowDocumentService.documentSearch(this.globalVariableService.getUserSession().getPrincipalId(), builder.build());
        for (DocumentSearchResult result : results.getSearchResults()) {
            documentIds.add(result.getDocument().getDocumentId());
        }
        return documentIds;
    }

    @SafeVarargs
    private final List<String> intersectCollections(Collection<String> ... collections) {
        Collection<Object> finalCollection = new ArrayList();
        for (Collection<String> collection : collections) {
            if (CollectionUtils.isNotEmpty(collection) && CollectionUtils.isNotEmpty(finalCollection)) {
                finalCollection = CollectionUtils.intersection(collection, finalCollection);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(collection)) continue;
            finalCollection = collection;
        }
        return new ArrayList<String>(finalCollection);
    }

    @Override
    public void buildPropDevViewActionLink(Link actionLink, Object model, String title) {
        actionLink.setTitle(title);
        actionLink.setLinkText(title);
        actionLink.setHref(this.getDocumentTypeService().getDocumentTypeByName(PROPOSAL_DEVELOPMENT_DOCUMENT).getResolvedDocumentHandlerUrl() + "&docId=" + actionLink.getHref() + "&command=displayDocSearchView&viewDocument=true");
    }

    @Override
    public void buildPropDevEditActionLink(Link actionLink, Object model, String title) {
        actionLink.setTitle(title);
        actionLink.setLinkText(title);
        actionLink.setHref(this.getConfigurationService().getPropertyValueAsString("workflow.url") + "/DocHandler.do?docId=" + actionLink.getHref() + "&command=displayDocSearchView");
    }

    @Override
    public void canModifyProposal(FieldGroup fieldGroup, Object model, ProposalDevelopmentDocument document) {
        boolean canModifyProposal = this.getKcAuthorizationService().hasPermission(this.getGlobalVariableService().getUserSession().getPrincipalId(), document, "Modify ProposalDevelopmentDocument");
        boolean canModifyBudget = this.getKcAuthorizationService().hasPermission(this.getGlobalVariableService().getUserSession().getPrincipalId(), document, "Modify Budget");
        if (!canModifyProposal && !canModifyBudget) {
            fieldGroup.setRender(false);
        }
    }

    public boolean isReactMedusaEnabled() {
        return this.medusaService.isReactMedusaEnabled();
    }

    public KcAuthorizationService getKcAuthorizationService() {
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public LookupCriteriaGenerator getLookupCriteriaGenerator() {
        return this.lookupCriteriaGenerator;
    }

    public void setLookupCriteriaGenerator(LookupCriteriaGenerator lookupCriteriaGenerator) {
        this.lookupCriteriaGenerator = lookupCriteriaGenerator;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

