/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.external.budget.FinancialObjectCodeMapping;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class FinancialObjectCodeMappingDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        FinancialObjectCodeMapping mapping = (FinancialObjectCodeMapping)document.getNewMaintainableObject().getDataObject();
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            if (document.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
                FinancialObjectCodeMapping oldDocument = (FinancialObjectCodeMapping)document.getOldMaintainableObject().getDataObject();
                if (!oldDocument.getUnitNumber().equals(mapping.getUnitNumber())) {
                    result &= this.validateUniqueEntry(mapping);
                    result &= this.checkExistence(mapping);
                }
            } else {
                result &= this.validateUniqueEntry(mapping);
                result &= this.checkExistence(mapping);
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean checkExistence(FinancialObjectCodeMapping newMapping) {
        HashMap<String, String> pkMap;
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)newMapping.getRateClassCode()) && StringUtils.isNotBlank((CharSequence)newMapping.getRateTypeCode())) {
            pkMap = new HashMap();
            pkMap.put("rateClassCode", newMapping.getRateClassCode());
            pkMap.put("rateTypeCode", newMapping.getRateTypeCode());
            RateType rateType = (RateType)this.getBusinessObjectService().findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{newMapping.getRateClassCode(), newMapping.getRateTypeCode()});
                valid = false;
            }
        }
        pkMap = new HashMap<String, String>();
        pkMap.put("unitNumber", newMapping.getUnitNumber());
        valid &= this.checkExistenceFromTable(Unit.class, pkMap, "unitNumber", "Unit Number");
        if (StringUtils.isNotEmpty((CharSequence)newMapping.getActivityTypeCode()) && newMapping instanceof FinancialObjectCodeMapping) {
            HashMap<String, String> pkMap1 = new HashMap<String, String>();
            pkMap1.put("code", newMapping.getActivityTypeCode());
            valid &= this.checkExistenceFromTable(ActivityType.class, pkMap1, "activityTypeCode", "Activity Type");
        }
        return valid;
    }

    private boolean validateUniqueEntry(FinancialObjectCodeMapping mapping) {
        String activityTypeCode = mapping.getActivityTypeCode();
        String rateClass = mapping.getRateClassCode();
        String rateType = mapping.getRateTypeCode();
        String unitNumber = mapping.getUnitNumber();
        boolean valid = true;
        if (rateClass != null && StringUtils.isNotBlank((CharSequence)rateClass) && rateType != null && StringUtils.isNotBlank((CharSequence)rateType) && unitNumber != null && StringUtils.isNotBlank((CharSequence)unitNumber)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rateClassCode", rateClass);
            map.put("rateTypeCode", rateType);
            map.put("unitNumber", unitNumber);
            Collection results = this.getBusinessObjectService().findMatching(FinancialObjectCodeMapping.class, map);
            if (results.size() > 0) {
                for (FinancialObjectCodeMapping result : results) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)result.getActivityTypeCode(), (CharSequence)activityTypeCode)) continue;
                    valid = false;
                    MessageMap errorMap = GlobalVariables.getMessageMap();
                    String error = "ActivityTypeCode: " + activityTypeCode + " RateClassCode: " + rateClass + " RateTypeCode: " + rateType + " UnitNumber: " + unitNumber;
                    errorMap.putError("document.newMaintainableObject.financialObjectCode", "error.award.budget.financial.objectCode.mapping.exists", new String[]{error});
                }
            }
        }
        return valid;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

