/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.servlet.ServletOutputStream;
import org.kuali.rice.ksb.security.DigitalSigner;

public class SignatureSigningOutputStream
extends ServletOutputStream {
    private boolean delayWrite;
    private DigitalSigner signer;
    private BufferedOutputStream bufferedDataHoldingStream;
    private ByteArrayOutputStream dataHoldingStream;
    private OutputStream wrappedOutputStream;

    public SignatureSigningOutputStream(DigitalSigner signer, OutputStream wrappedOutputStream, boolean delayWrite) {
        this.delayWrite = delayWrite;
        if (delayWrite) {
            this.dataHoldingStream = new ByteArrayOutputStream();
            this.bufferedDataHoldingStream = new BufferedOutputStream(this.dataHoldingStream);
        }
        this.wrappedOutputStream = wrappedOutputStream;
        this.signer = signer;
    }

    public void write(int data) throws IOException {
        if (this.delayWrite) {
            this.bufferedDataHoldingStream.write(data);
        } else {
            this.wrappedOutputStream.write(data);
        }
        try {
            this.signer.getSignature().update((byte)data);
        }
        catch (GeneralSecurityException e) {
            IOException exception = new IOException("Error updating signature.");
            exception.initCause(e);
            throw exception;
        }
    }

    public void close() throws IOException {
        try {
            this.signer.sign();
            if (this.delayWrite) {
                this.bufferedDataHoldingStream.close();
                byte[] data = this.dataHoldingStream.toByteArray();
                for (int index = 0; index < data.length; ++index) {
                    this.wrappedOutputStream.write(data[index]);
                }
            }
            this.wrappedOutputStream.close();
        }
        catch (Exception e) {
            IOException exception = new IOException("Error attaching digital signature to outbound response.");
            exception.initCause(e);
            throw exception;
        }
        finally {
            super.close();
        }
    }
}

