/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.service;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.ksb.service.BasicAuthenticationService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.beans.factory.InitializingBean;

public class BasicAuthenticationCredentials
implements InitializingBean {
    private BasicAuthenticationService authenticationService;
    private String serviceNameSpaceURI;
    private String localServiceName;
    private String username;
    private String password;

    public void afterPropertiesSet() throws Exception {
        if (this.validate()) {
            this.getAuthenticationService().registerServiceCredentials(this);
        }
    }

    public BasicAuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = KSBServiceLocator.getBasicAuthenticationService();
        }
        return this.authenticationService;
    }

    public void setAuthenticationService(BasicAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getServiceNameSpaceURI() {
        return this.serviceNameSpaceURI;
    }

    public void setServiceNameSpaceURI(String serviceNameSpaceURI) {
        this.serviceNameSpaceURI = serviceNameSpaceURI;
    }

    public String getLocalServiceName() {
        return this.localServiceName;
    }

    public void setLocalServiceName(String localServiceName) {
        this.localServiceName = localServiceName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected boolean validate() {
        return this.getAuthenticationService() != null && StringUtils.isNotBlank((String)this.getServiceNameSpaceURI()) && StringUtils.isNotBlank((String)this.getLocalServiceName()) && StringUtils.isNotBlank((String)this.getUsername()) && StringUtils.isNotBlank((String)this.getPassword());
    }
}

