/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.auth;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyException;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.lock.ProposalBudgetLockService;
import org.kuali.coeus.sys.framework.workflow.KcDocumentRejectionService;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizerBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalBudgetAuthorizer")
public class ProposalBudgetAuthorizer
extends ViewAuthorizerBase {
    private static final Logger LOG = LogManager.getLogger(ProposalBudgetAuthorizer.class);
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kcAuthorizationService;
    @Autowired
    @Qualifier(value="kcDocumentRejectionService")
    private KcDocumentRejectionService kcDocumentRejectionService;
    @Autowired
    @Qualifier(value="kcWorkflowService")
    private KcWorkflowService kcWorkflowService;
    @Autowired
    @Qualifier(value="proposalBudgetLockService")
    private ProposalBudgetLockService proposalBudgetLockService;
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    private ProposalHierarchyService proposalHierarchyService;

    public Set<String> getEditModes(View view, ViewModel model, Person user, Set<String> editModes) {
        ProposalBudgetForm form = (ProposalBudgetForm)model;
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        ProposalDevelopmentDocument parentDocument = (ProposalDevelopmentDocument)budget.getBudgetParent().getDocument();
        if (this.isAuthorizedToAddBudget((Document)parentDocument, user)) {
            editModes.add("addBudget");
        }
        if (this.isAuthorizedToModifyBudget(budget, user)) {
            editModes.add("viewBudget");
            if (!form.isViewOnly()) {
                editModes.add("canChangeCompleteStatus");
            }
            if (!this.isBudgetComplete(budget)) {
                if (!budget.getDevelopmentProposal().isParent()) {
                    editModes.add("modifyBudget");
                    if (this.isAuthorizedToModifyRates(budget, user)) {
                        editModes.add("modifyBudgetRates");
                    }
                    this.setPermissions(user, parentDocument, editModes);
                } else {
                    editModes.add("modifyParentBudget");
                }
            }
        } else if (this.isAuthorizedToViewBudget(budget, user)) {
            editModes.add("viewOnly");
            editModes.add("viewBudget");
            this.setPermissions(user, parentDocument, editModes);
        } else {
            editModes.add("unviewable");
        }
        if (this.isAuthorizedToMaintainProposalHierarchy((Document)parentDocument, user)) {
            editModes.add("maintainProposalHierarchy");
        }
        return editModes;
    }

    protected void setPermissions(Person user, BudgetParentDocument doc, Set<String> editModes) {
        if (this.isAuthorizedToAddBudget((Document)doc, user)) {
            editModes.add("addBudget");
        }
        if (this.isAuthorizedToPrintProposal((Document)doc, user)) {
            editModes.add("canPrint");
        }
        if (this.isAuthorizedToAlterProposalData((Document)doc, user)) {
            editModes.add("alterProposalData");
        }
        if (this.isAuthorizedToShowAlterBudgetData((Document)doc, user)) {
            editModes.add("showAlterProposalData");
        }
    }

    public boolean canOpenView(View view, ViewModel model, Person user) {
        ProposalBudgetForm form = (ProposalBudgetForm)model;
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        return this.canOpen(budget, user);
    }

    public boolean canOpen(ProposalDevelopmentBudgetExt budget, Person user) {
        return this.isAuthorizedToViewBudget(budget, user);
    }

    public boolean canEdit(ProposalDevelopmentBudgetExt budget, Person user) {
        return this.isAuthorizedToModifyBudget(budget, user);
    }

    public boolean canEditModularBudget(ProposalDevelopmentBudgetExt budget, Person user) {
        return this.isAuthorizedToModifyBudget(budget, user, false);
    }

    public boolean canSave(ProposalDevelopmentBudgetExt budget, Person user) {
        return this.canEdit(budget, user);
    }

    public boolean canReload(ProposalDevelopmentBudgetExt budget, Person user) {
        return this.canEdit(budget, user);
    }

    public boolean canModifyBudget(ProposalDevelopmentBudgetExt budget, Person user) {
        return this.isAuthorizedToModifyBudget(budget, user) && !this.isBudgetComplete(budget);
    }

    protected boolean isBudgetComplete(ProposalDevelopmentBudgetExt budget) {
        String budgetStatusCompleteCode = this.getParameterService().getParameterValueAsString(Budget.class, "budgetStatusCompleteCode");
        return StringUtils.equals((CharSequence)budgetStatusCompleteCode, (CharSequence)budget.getBudgetStatus());
    }

    protected boolean isAuthorizedToModifyRates(ProposalDevelopmentBudgetExt budget, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)budget.getBudgetParent().getDocument();
        boolean rejectedDocument = this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        return (!this.getKcWorkflowService().isInWorkflow((Document)pdDocument) || rejectedDocument) && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Modify Proposal Rates") && pdDocument.getDevelopmentProposal().getSubmitFlag() == false;
    }

    public boolean isAuthorizedToViewBudget(ProposalDevelopmentBudgetExt budget, Person user) {
        ProposalDevelopmentDocument doc = (ProposalDevelopmentDocument)budget.getBudgetParent().getDocument();
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), doc, "View Budget") || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), doc, "Modify Budget") || this.kcWorkflowService.hasWorkflowPermission(user.getPrincipalId(), (Document)doc);
    }

    protected boolean isAuthorizedToMaintainProposalHierarchy(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return !pdDocument.isViewOnly() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Maintain ProposalHierarchy");
    }

    protected boolean isAuthorizedToModifyBudget(ProposalDevelopmentBudgetExt budget, Person user) {
        return this.isAuthorizedToModifyBudget(budget, user, true);
    }

    protected boolean isAuthorizedToModifyBudget(ProposalDevelopmentBudgetExt budget, Person user, boolean checkPessimisticLocks) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)budget.getBudgetParent().getDocument();
        boolean rejectedDocument = this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        return !(this.getKcWorkflowService().isInWorkflow((Document)pdDocument) && !rejectedDocument || !this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Modify Budget") || pdDocument.getDevelopmentProposal().getSubmitFlag() != false || checkPessimisticLocks && !this.userHasLockOnBudget(budget, user));
    }

    protected boolean userHasLockOnBudget(ProposalDevelopmentBudgetExt budget, Person user) {
        ProposalDevelopmentDocument document = budget.getDevelopmentProposal().getProposalDocument();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!lock.isOwnedByUser(user) || !this.getProposalBudgetLockService().doesBudgetVersionMatchDescriptor(lock.getLockDescriptor(), budget.getBudgetVersionNumber())) continue;
            return true;
        }
        return false;
    }

    protected boolean isAuthorizedToAddBudget(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        boolean hasPermission = false;
        boolean rejectedDocument = this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        if (!(this.getKcWorkflowService().isInWorkflow((Document)pdDocument) && !rejectedDocument || pdDocument.isViewOnly() || pdDocument.getDevelopmentProposal().getSubmitFlag().booleanValue() || pdDocument.getDevelopmentProposal().isParent())) {
            hasPermission = this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Modify Budget");
        }
        return hasPermission;
    }

    protected boolean isAuthorizedToPrintProposal(Document document, Person user) {
        BudgetParentDocument bpDocument = (BudgetParentDocument)document;
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), bpDocument, "Print Proposal");
    }

    protected boolean isAuthorizedToAlterProposalData(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        boolean ret = true;
        if (pdDocument.getDevelopmentProposal().isChild()) {
            try {
                if (this.getProposalHierarchyService().getParentWorkflowDocument(pdDocument).isEnroute()) {
                    ret = false;
                }
            }
            catch (ProposalHierarchyException e) {
                LOG.error(String.format("Exception looking up parent of DevelopmentProposal %s, authorizer is going to deny edit access to this child.", pdDocument.getDevelopmentProposal().getProposalNumber()), (Throwable)e);
                ret = false;
            }
        }
        if (ret) {
            ret = this.getKcWorkflowService().isEnRoute((Document)pdDocument) && pdDocument.getDevelopmentProposal().getSubmitFlag() == false && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Alter Proposal Data");
        }
        return ret;
    }

    protected boolean isAuthorizedToShowAlterBudgetData(Document document, Person user) {
        return this.getKcWorkflowService().isInWorkflow(document);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public KcAuthorizationService getKcAuthorizationService() {
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }

    public KcDocumentRejectionService getKcDocumentRejectionService() {
        return this.kcDocumentRejectionService;
    }

    public void setKcDocumentRejectionService(KcDocumentRejectionService kcDocumentRejectionService) {
        this.kcDocumentRejectionService = kcDocumentRejectionService;
    }

    public KcWorkflowService getKcWorkflowService() {
        return this.kcWorkflowService;
    }

    public void setKcWorkflowService(KcWorkflowService kcWorkflowService) {
        this.kcWorkflowService = kcWorkflowService;
    }

    public ProposalBudgetLockService getProposalBudgetLockService() {
        return this.proposalBudgetLockService;
    }

    public void setProposalBudgetLockService(ProposalBudgetLockService proposalBudgetLockService) {
        this.proposalBudgetLockService = proposalBudgetLockService;
    }

    protected ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }
}

