/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.DisclosureProjectStatus;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.common.framework.medusa.MedusaService;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.print.KcAttachmentDataSource;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.SponsorSearchResult;
import org.kuali.coeus.common.framework.sponsor.SponsorSearchService;
import org.kuali.coeus.common.impl.KcViewHelperServiceImpl;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionExplanation;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.attachment.LegacyNarrativeService;
import org.kuali.coeus.propdev.impl.attachment.MultipartFileValidationService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentAttachmentHelper;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentAuthorizer;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentViewAuthorizer;
import org.kuali.coeus.propdev.impl.auth.perm.ProposalDevelopmentPermissionsService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperService;
import org.kuali.coeus.propdev.impl.custom.ProposalDevelopmentCustomDataGroupDto;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.location.AddProposalCongressionalDistrictEvent;
import org.kuali.coeus.propdev.impl.location.CongressionalDistrict;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.lock.ProposalLockService;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonCertificationDetails;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverride;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.propdev.impl.state.ProposalState;
import org.kuali.coeus.sys.framework.controller.KcFileService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.coeus.sys.impl.validation.DataValidationItem;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.file.FileMeta;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="proposalDevelopmentViewHelperService")
@Scope(value="prototype")
public class ProposalDevelopmentViewHelperServiceImpl
extends KcViewHelperServiceImpl
implements ProposalDevelopmentViewHelperService {
    private static final long serialVersionUID = -5122498699317873886L;
    private static final String PARENT_PROPOSAL_TYPE_CODE = "PRDV";
    private static final String ATTACHMENT_FILE = "multipartFile";
    public static final String NOT_YET_DISPOSITIONED = "Not Yet Dispositioned";
    public static final String DEADLINE_TYPE_REF = "deadlineTypeRef";
    public static final String AD_HOC_NOTIFICATION = "Ad-Hoc Notification";
    public static final String PROPOSAL_PERSON_CANNOT_BE_RETRIEVED_FROM_DEVELOPMENT_PROPOSAL = "proposal person cannot be retrieved from development proposal";
    public static final String DOCUMENT_DEVELOPMENT_PROPOSAL_INSTITUTE_ATTACHMENTS = "document.developmentProposal.instituteAttachments";
    private static final String INFO_PROPOSAL_CERTIFIED = "All questions answered.";
    private static final String WARN_PROPOSAL_CERTIFIED = "Please answer all questions in order to certify proposal.";
    private static final String PDF_BASE_URL = "https://apply07.grants.gov/apply/forms/sample/";
    private static final String FORMS_NAMESPACE_BASE_URL = "http://apply.grants.gov/forms/";
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="legacyNarrativeService")
    private LegacyNarrativeService narrativeService;
    @Autowired
    @Qualifier(value="noteService")
    private NoteService noteService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="keyPersonnelService")
    private KeyPersonnelService keyPersonnelService;
    @Autowired
    @Qualifier(value="auditHelper")
    private AuditHelper auditHelper;
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService kualiRuleService;
    @Autowired
    @Qualifier(value="proposalDevelopmentPermissionsService")
    private ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService;
    @Autowired
    @Qualifier(value="proposalDevelopmentService")
    private ProposalDevelopmentService proposalDevelopmentService;
    @Autowired
    @Qualifier(value="customAttributeService")
    private CustomAttributeService customAttributeService;
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    private ProposalHierarchyService proposalHierarchyService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="sponsorSearchService")
    private SponsorSearchService sponsorSearchService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kraAuthorizationService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="kcFileService")
    private KcFileService kcFileService;
    @Autowired
    @Qualifier(value="multipartFileValidationService")
    private MultipartFileValidationService multipartFileValidationService;
    @Autowired
    @Qualifier(value="proposalDevelopmentDocumentViewAuthorizer")
    private ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="proposalLockService")
    private ProposalLockService proposalLockService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="medusaService")
    private MedusaService medusaService;

    public void performCustomFinalize(LifecycleElement element, Object model, LifecycleElement parent) {
        S2sOverride s2sOverride = ((ProposalDevelopmentDocumentForm)model).getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null && s2sOverride.isActive()) {
            if (s2sOverride.getApplicationOverride() != null && s2sOverride.getApplicationOverride().getApplication() != null) {
                this.getGlobalVariableService().getMessageMap().putWarning("GLOBAL_ERRORS", "warn.s2s.override.present", new String[]{"Application XML"});
            } else if (StringUtils.isNotBlank((CharSequence)s2sOverride.getSignedBy()) && s2sOverride.getSubmittedDate() == null) {
                this.getGlobalVariableService().getMessageMap().putWarning("GLOBAL_ERRORS", "warn.s2s.override.present", new String[]{"Signed By User"});
            } else if (StringUtils.isBlank((CharSequence)s2sOverride.getSignedBy()) && s2sOverride.getSubmittedDate() != null) {
                this.getGlobalVariableService().getMessageMap().putWarning("GLOBAL_ERRORS", "warn.s2s.override.present", new String[]{"Submitted Date"});
            } else if (StringUtils.isNotBlank((CharSequence)s2sOverride.getSignedBy()) && s2sOverride.getSubmittedDate() != null) {
                this.getGlobalVariableService().getMessageMap().putWarning("GLOBAL_ERRORS", "warn.s2s.override.present", new String[]{"Signed By User, Submitted Date"});
            }
        }
        super.performCustomFinalize(element, model, parent);
    }

    public String getS2sOverrideMessage(ProposalDevelopmentDocument document) {
        S2sOverride s2sOverride = document.getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null && s2sOverride.isActive()) {
            if (s2sOverride.getApplicationOverride() != null && s2sOverride.getApplicationOverride().getApplication() != null) {
                return "Proposal S2S Submission data \\[Application XML\\] has been overridden. Do you want to continue?";
            }
            if (StringUtils.isNotBlank((CharSequence)s2sOverride.getSignedBy()) && s2sOverride.getSubmittedDate() == null) {
                return "Proposal S2S Submission data \\[Signed By User\\] has been overridden. Do you want to continue?";
            }
            if (StringUtils.isBlank((CharSequence)s2sOverride.getSignedBy()) && s2sOverride.getSubmittedDate() != null) {
                return "Proposal S2S Submission data \\[Submitted Date\\] has been overridden. Do you want to continue?";
            }
            if (StringUtils.isNotBlank((CharSequence)s2sOverride.getSignedBy()) && s2sOverride.getSubmittedDate() != null) {
                return "Proposal S2S Submission data \\[Signed By User, Submitted Date\\] has been overridden. Do you want to continue?";
            }
        }
        return "Proposal S2S Submission data has been overridden. Do you want to continue?";
    }

    public void processBeforeAddLine(ViewModel model, Object addLine, String collectionId, String collectionPath) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)model;
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        if (addLine instanceof Narrative) {
            Narrative narrative = (Narrative)addLine;
            this.getNarrativeService().prepareNarrative(document, narrative);
            if (StringUtils.equals((CharSequence)collectionPath, (CharSequence)DOCUMENT_DEVELOPMENT_PROPOSAL_INSTITUTE_ATTACHMENTS)) {
                narrative.setModuleStatusCode("C");
            }
            this.updateAttachmentInformation(narrative.getNarrativeAttachment());
        } else if (addLine instanceof ProposalPersonBiography) {
            ProposalPersonBiography biography = (ProposalPersonBiography)addLine;
            biography.setDevelopmentProposal(document.getDevelopmentProposal());
            biography.setBiographyNumber(document.getDocumentNextValue("proposalDevelopment.proposalPersonBiography.biographyNumber"));
            this.updateAttachmentInformation(biography.getPersonnelAttachment());
        } else if (addLine instanceof ProposalPersonDegree) {
            ((ProposalPersonDegree)addLine).setDegreeSequenceNumber(document.getDocumentNextValue("proposalDevelopment.proposalPerson.degree.degreeSequenceNumber"));
            try {
                ((ProposalPersonDegree)addLine).setProposalPerson((ProposalPerson)PropertyUtils.getNestedProperty((Object)form.getDevelopmentProposal(), (String)StringUtils.replace((String)collectionPath, (String)".proposalPersonDegrees", (String)"")));
            }
            catch (Exception e) {
                throw new RuntimeException(PROPOSAL_PERSON_CANNOT_BE_RETRIEVED_FROM_DEVELOPMENT_PROPOSAL, e);
            }
        } else if (addLine instanceof ProposalPersonUnit) {
            try {
                ProposalPersonUnit unit = (ProposalPersonUnit)addLine;
                ProposalPerson proposalPerson = (ProposalPerson)PropertyUtils.getNestedProperty((Object)form.getDevelopmentProposal(), (String)StringUtils.replace((String)collectionPath, (String)".units", (String)""));
                unit.setProposalPerson(proposalPerson);
                unit.getCreditSplits().addAll(this.getKeyPersonnelService().createCreditSplits(unit));
            }
            catch (Exception e) {
                throw new RuntimeException(PROPOSAL_PERSON_CANNOT_BE_RETRIEVED_FROM_DEVELOPMENT_PROPOSAL, e);
            }
        } else if (addLine instanceof ProposalAbstract) {
            ProposalAbstract proposalAbstract = (ProposalAbstract)addLine;
            proposalAbstract.setProposalNumber(proposal.getProposalNumber());
            proposalAbstract.refreshReferenceObject("abstractType");
            proposalAbstract.setUpdateDisplayFields();
        } else if (addLine instanceof ProposalSpecialReview) {
            ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)addLine;
            proposalSpecialReview.setDevelopmentProposal(document.getDevelopmentProposal());
        } else if (addLine instanceof ProposalSite) {
            ProposalSite newProposalSite = (ProposalSite)addLine;
            if (newProposalSite.getOrganizationId() != null) {
                ((ProposalSite)addLine).setLocationTypeCode(3);
            } else if (newProposalSite.getRolodexId() != null) {
                ((ProposalSite)addLine).setLocationTypeCode(4);
            }
            ((ProposalSite)addLine).setDevelopmentProposal(document.getDevelopmentProposal());
        } else if (addLine instanceof CongressionalDistrict) {
            CongressionalDistrict congressionalDistrict = (CongressionalDistrict)addLine;
            ((CongressionalDistrict)addLine).setCongressionalDistrict(congressionalDistrict.getNewState(), congressionalDistrict.getNewDistrictNumber());
        } else if (addLine instanceof Note) {
            Note note = (Note)addLine;
            note.setRemoteObjectIdentifier(document.getNoteTarget().getObjectId());
            note.setAuthorUniversalIdentifier(this.getGlobalVariableService().getUserSession().getPrincipalId());
            note.setNotePostedTimestampToCurrent();
            note.setNoteTypeCode("BO");
        } else if (addLine instanceof ProposalCfda) {
            ((ProposalCfda)addLine).setProposalNumber(proposal.getProposalNumber());
        }
        if (addLine instanceof KcPersistableBusinessObjectBase) {
            ((KcPersistableBusinessObjectBase)addLine).setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
            ((KcPersistableBusinessObjectBase)addLine).setUpdateUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
        }
    }

    public void processAfterAddLine(ViewModel model, Object lineObject, String collectionId, String collectionPath, boolean isValidLine) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)model;
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        if (lineObject instanceof Note) {
            this.getNoteService().save((Note)lineObject);
        } else if (lineObject instanceof ProposalUserRoles) {
            String fullName = this.getKcPersonService().getKcPersonByUserName(((ProposalUserRoles)lineObject).getUsername()).getFullName();
            ((ProposalUserRoles)lineObject).setFullname(fullName);
            this.getProposalDevelopmentPermissionsService().processAddPermission(document, (ProposalUserRoles)lineObject);
        } else if (lineObject instanceof ProposalSite) {
            ArrayList<ProposalSite> sites = (ArrayList<ProposalSite>)ObjectPropertyUtils.getPropertyValue((Object)model, (String)collectionPath);
            if (sites == null) {
                sites = new ArrayList<ProposalSite>();
            }
            if (!sites.contains(lineObject)) {
                sites.add(0, (ProposalSite)lineObject);
                ObjectPropertyUtils.setPropertyValue((Object)model, (String)collectionPath, sites);
            }
        }
    }

    public void finalizeNavigationLinks(Action action, Object model, String direction) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)model;
        List<Action> actions = pdForm.getOrderedNavigationActions();
        int indexOfCurrentAction = pdForm.findIndexOfPageId(actions);
        if (StringUtils.equals((CharSequence)direction, (CharSequence)"previous")) {
            action.setRender(indexOfCurrentAction > 0);
            if (indexOfCurrentAction > 0) {
                action.getActionParameters().put("navigateToPageId", pdForm.getOrderedNavigationActions().get(indexOfCurrentAction - 1).getNavigateToPageId());
            }
        } else if (StringUtils.equals((CharSequence)direction, (CharSequence)"next")) {
            action.setRender(action.isRender() && indexOfCurrentAction < actions.size());
            if (indexOfCurrentAction < actions.size()) {
                action.getActionParameters().put("navigateToPageId", pdForm.getOrderedNavigationActions().get(indexOfCurrentAction + 1).getNavigateToPageId());
            }
        }
    }

    public void setInvestigatorCreditTypes(Object model) {
        ((ProposalDevelopmentDocumentForm)model).getDevelopmentProposal().setInvestigatorCreditTypes(this.getKeyPersonnelService().getInvestigatorCreditTypes());
    }

    private String getNewCollectionPropertyPath(String collectionPath, String propertyName) {
        return "newCollectionLines['" + collectionPath + "']." + propertyName;
    }

    private boolean validateAdhocRoutePerson(String collectionPath, AdHocRoutePerson adhocPerson) {
        String propertyPath = this.getNewCollectionPropertyPath(collectionPath, "id");
        if (adhocPerson.getPerson() == null || StringUtils.isBlank((CharSequence)adhocPerson.getPerson().getPrincipalId())) {
            this.getGlobalVariableService().getMessageMap().putError(propertyPath, "error.adhoc.route.recipient.invalid", new String[]{adhocPerson.getId(), "person"});
            return false;
        }
        if (!adhocPerson.getPerson().isActive()) {
            this.getGlobalVariableService().getMessageMap().putError(propertyPath, "error.adhoc.route.recipient.inactive", new String[]{adhocPerson.getId(), "person"});
            return false;
        }
        return true;
    }

    private boolean validateAdhocRouteGroup(String collectionPath, AdHocRouteWorkgroup adhocGroup) {
        String propertyPath = this.getNewCollectionPropertyPath(collectionPath, "recipientName");
        if (adhocGroup.getGroup() == null) {
            this.getGlobalVariableService().getMessageMap().putError(propertyPath, "error.adhoc.route.recipient.invalid", new String[]{adhocGroup.getRecipientName(), "group"});
            return false;
        }
        if (!adhocGroup.getGroup().isActive()) {
            this.getGlobalVariableService().getMessageMap().putError(propertyPath, "error.adhoc.route.recipient.inactive", new String[]{adhocGroup.getRecipientName(), "group"});
            return false;
        }
        return true;
    }

    protected boolean performAddLineValidation(ViewModel viewModel, Object newLine, String collectionId, String collectionPath) {
        boolean isValid = super.performAddLineValidation(viewModel, newLine, collectionId, collectionPath);
        String collectionLabel = (String)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "collectionLabel");
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)viewModel;
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        if (newLine instanceof CongressionalDistrict) {
            Collection CongressionalDistricts = (Collection)ObjectPropertyUtils.getPropertyValue((Object)viewModel, (String)collectionPath);
            isValid = this.getKualiRuleService().applyRules((DocumentEvent)new AddProposalCongressionalDistrictEvent(document, (List)CongressionalDistricts, (CongressionalDistrict)newLine, collectionId, collectionLabel));
        } else if (newLine instanceof ProposalUserRoles) {
            ProposalUserRoles newProposalUserRoles = (ProposalUserRoles)newLine;
            isValid = this.getProposalDevelopmentPermissionsService().validateAddPermissions(document, form.getWorkingUserRoles(), newProposalUserRoles);
        } else if (newLine instanceof Narrative) {
            Narrative narrative = (Narrative)newLine;
            String selectedLine = form.getActionParamaterValue("selectedLineIndex");
            if (StringUtils.isNotBlank((CharSequence)selectedLine)) {
                String collectionPathWithIndex = collectionPath + "[" + selectedLine + "]";
                isValid = this.validateNarrativeRequiredFields(narrative, collectionPathWithIndex, true);
            }
        } else if (newLine instanceof ProposalPersonBiography) {
            ProposalPersonBiography biography = (ProposalPersonBiography)newLine;
            String selectedLine = form.getActionParamaterValue("selectedLineIndex");
            if (StringUtils.isNotBlank((CharSequence)selectedLine)) {
                String collectionPathWithIndex = collectionPath + "[" + selectedLine + "]";
                isValid = this.validateProposalPersonBiographyRequiredFields(biography, collectionPathWithIndex, true);
            }
        } else if (newLine instanceof ProposalPersonUnit) {
            Collection existingUnits = (Collection)ObjectPropertyUtils.getPropertyValue((Object)viewModel, (String)collectionPath);
            ProposalPersonUnit personUnit = (ProposalPersonUnit)newLine;
            for (ProposalPersonUnit existingUnit : existingUnits) {
                if (!existingUnit.getUnitNumber().equals(personUnit.getUnitNumber())) continue;
                this.getGlobalVariableService().getMessageMap().putError(collectionPath, "error.addExistingUnit", new String[]{personUnit.getUnitNumber(), personUnit.getProposalPerson().getFullName()});
                isValid = false;
                break;
            }
        } else if (newLine instanceof AdHocRoutePerson) {
            isValid &= this.validateAdhocRoutePerson(collectionPath, (AdHocRoutePerson)newLine);
        } else if (newLine instanceof AdHocRouteWorkgroup) {
            isValid &= this.validateAdhocRouteGroup(collectionPath, (AdHocRouteWorkgroup)newLine);
        }
        return isValid;
    }

    public void processAfterSaveLine(ViewModel model, Object lineObject, String collectionId, String collectionPath) {
        this.getDataObjectService().save(lineObject, new PersistenceOption[0]);
        if (lineObject instanceof ProposalPersonBiography) {
            MessageMap messages = this.multipartFileValidationService.validateMultipartFile(ATTACHMENT_FILE, ((ProposalPersonBiography)lineObject).getMultipartFile());
            if (!messages.hasMessages()) {
                try {
                    ((ProposalPersonBiography)lineObject).init(((ProposalPersonBiography)lineObject).getMultipartFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.getGlobalVariableService().getMessageMap().merge(messages);
            }
        } else if (lineObject instanceof Narrative) {
            MessageMap messages = this.multipartFileValidationService.validateMultipartFile(ATTACHMENT_FILE, ((Narrative)lineObject).getMultipartFile());
            if (!messages.hasMessages()) {
                try {
                    ((Narrative)lineObject).init(((Narrative)lineObject).getMultipartFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.getGlobalVariableService().getMessageMap().merge(messages);
            }
        }
    }

    protected boolean performDeleteLineValidation(ViewModel model, String collectionId, String collectionPath, Object deleteLine) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)model;
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)model, (String)collectionPath);
        int index = ((List)collection).indexOf(deleteLine);
        boolean isValid = true;
        if (deleteLine instanceof ProposalUserRoles && (isValid = this.getProposalDevelopmentPermissionsService().validateDeletePermissions(document, form.getWorkingUserRoles(), index))) {
            this.getProposalDevelopmentPermissionsService().processDeletePermission(document, (ProposalUserRoles)deleteLine);
        }
        if (deleteLine instanceof ProposalDevelopmentNotification) {
            return false;
        }
        if (deleteLine instanceof FileMeta) {
            this.getDataObjectService().delete(deleteLine);
        }
        return isValid;
    }

    public void processAfterDeleteLine(ViewModel model, String collectionId, String collectionPath, int lineIndex) {
        Integer typeCode;
        List collection;
        ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm = (ProposalDevelopmentDocumentForm)model;
        if (proposalDevelopmentDocumentForm.getEditableCollectionLines().containsKey(collectionPath)) {
            for (String index : proposalDevelopmentDocumentForm.getEditableCollectionLines().get(collectionPath)) {
                if (!index.equals(String.valueOf(lineIndex))) continue;
                proposalDevelopmentDocumentForm.getEditableCollectionLines().get(collectionPath).remove(index);
                break;
            }
        }
        if ((collection = (List)ObjectPropertyUtils.getPropertyValue((Object)model, (String)collectionPath)) != null && !collection.isEmpty() && collection.size() > lineIndex && collection.get(lineIndex) instanceof ProposalSite && ((typeCode = ((ProposalSite)collection.get(lineIndex)).getLocationTypeCode()).equals(3) || typeCode.equals(4))) {
            collection.remove(lineIndex);
            ObjectPropertyUtils.setPropertyValue((Object)model, (String)collectionPath, (Object)collection);
        }
    }

    public List<SponsorSuggestResult> performSponsorFieldSuggest(String sponsorSearchStr) {
        if (StringUtils.isBlank((CharSequence)sponsorSearchStr)) {
            return Collections.emptyList();
        }
        List<SponsorSearchResult> allSponsors = this.getSponsorSearchService().findSponsors(sponsorSearchStr);
        ArrayList<SponsorSuggestResult> result = new ArrayList<SponsorSuggestResult>();
        for (SponsorSearchResult sponsor : allSponsors) {
            result.add(new SponsorSuggestResult(sponsor));
        }
        return result;
    }

    public String getSponsorString(Sponsor sponsor) {
        if (sponsor != null) {
            return sponsor.getSponsorCode() + " - " + sponsor.getSponsorName();
        }
        return "";
    }

    public boolean containsOpportunity(ProposalDevelopmentDocument document) {
        return document.getDevelopmentProposal().hasS2sOpportunity() && document.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null;
    }

    public String createFormPdfUrl(String oppNameSpace) {
        return oppNameSpace.replace(FORMS_NAMESPACE_BASE_URL, PDF_BASE_URL) + ".pdf";
    }

    public boolean containsOverride(ProposalDevelopmentDocument document) {
        return document.getDevelopmentProposal().getS2sOverride() != null;
    }

    public boolean isCollectionLineEditable(String selectedCollectionPath, String index, Map<String, List<String>> editableCollectionLines) {
        boolean retVal = false;
        if (editableCollectionLines.containsKey(selectedCollectionPath) && editableCollectionLines.get(selectedCollectionPath).contains(index)) {
            retVal = true;
        }
        return retVal;
    }

    public String getDateUploadedFormatted(Timestamp uploadDate) {
        if (uploadDate != null) {
            return this.getDateTimeService().toDateString(new Date(uploadDate.getTime())) + " " + this.getDateTimeService().toTimeString(new Time(uploadDate.getTime()));
        }
        return "";
    }

    public boolean validateProposalPersonBiographyRequiredFields(ProposalPersonBiography biography, String collectionPath, boolean showErrors) {
        boolean success = true;
        if (StringUtils.isBlank((CharSequence)biography.getProposalPersonNumberString())) {
            if (showErrors) {
                this.getGlobalVariableService().getMessageMap().putError(collectionPath + ".proposalPersonNumberString", "validation.required", new String[0]);
            }
            success = false;
        }
        if (StringUtils.isBlank((CharSequence)biography.getDocumentTypeCode())) {
            if (showErrors) {
                this.getGlobalVariableService().getMessageMap().putError(collectionPath + ".documentTypeCode", "validation.required", new String[0]);
            }
            success = false;
        }
        return success;
    }

    public boolean validateNarrativeRequiredFields(Narrative narrative, String collectionPath, boolean showErrors) {
        boolean success = true;
        if (StringUtils.isBlank((CharSequence)narrative.getNarrativeTypeCode())) {
            if (showErrors) {
                this.getGlobalVariableService().getMessageMap().putError(collectionPath + ".narrativeTypeCode", "validation.required", new String[0]);
            }
            success = false;
        }
        if (StringUtils.isBlank((CharSequence)narrative.getModuleStatusCode())) {
            if (showErrors) {
                this.getGlobalVariableService().getMessageMap().putError(collectionPath + ".moduleStatusCode", "validation.required", new String[0]);
            }
            success = false;
        }
        return success;
    }

    public boolean displayKeywords() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "proposaldevelopment.displayKeywordPanel");
    }

    protected LegacyNarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public void setNarrativeService(LegacyNarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public boolean isCreditSplitEnabled() {
        return this.getKeyPersonnelService().isCreditSplitEnabled();
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public KeyPersonnelService getKeyPersonnelService() {
        return this.keyPersonnelService;
    }

    public void setKeyPersonnelService(KeyPersonnelService keyPersonnelService) {
        this.keyPersonnelService = keyPersonnelService;
    }

    public String displayProposalProgressCode(WorkflowDocument wd) {
        String proposalProgressCode = wd.isSaved() ? DocumentStatus.SAVED.name() : (wd.isEnroute() || wd.isException() ? DocumentStatus.ENROUTE.name() : (wd.isApproved() ? DocumentStatus.FINAL.name() : ""));
        return proposalProgressCode;
    }

    public boolean areActiveQuestionnaires(List<AnswerHeader> answerHeaders) {
        for (AnswerHeader answerHeader : answerHeaders) {
            if (!answerHeader.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnsweredAnswer(Answer answer) {
        if (answer.getAnswerNumber() != 1) {
            return true;
        }
        return answer.isAnswered();
    }

    public boolean isQuestionnaireMandatory(AnswerHeader header) {
        return header.isQuestionnaireMandatory();
    }

    public boolean areAnsweredQuestionnaires(List<AnswerHeader> answerHeaders) {
        for (AnswerHeader answerHeader : answerHeaders) {
            if (!answerHeader.isActive()) continue;
            for (Answer answer : answerHeader.getAnswers()) {
                if (!StringUtils.isNotEmpty((CharSequence)answer.getAnswer())) continue;
                return true;
            }
        }
        return false;
    }

    public String getQuestionMoreInfo(Question question) {
        StringBuilder moreInfo = new StringBuilder();
        moreInfo.append("\nQuestion Id : " + question.getQuestionSeqId() + "\n");
        for (QuestionExplanation explanation : question.getQuestionExplanations()) {
            if (StringUtils.isNotEmpty((CharSequence)explanation.getExplanation()) && explanation.getExplanationType().equals("E")) {
                moreInfo.append("Explanation : " + explanation.getExplanation() + "\n");
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)explanation.getExplanation()) && explanation.getExplanationType().equals("P")) {
                moreInfo.append("Policy : " + explanation.getExplanation() + "\n");
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)explanation.getExplanation()) || !explanation.getExplanationType().equals("R")) continue;
            moreInfo.append("Regulation : " + explanation.getExplanation() + "\n");
        }
        return moreInfo.toString();
    }

    public boolean isPersonnelCreditSplitOptInFeatureEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", "ENABLE_OPT_IN_PERSONNEL_CREDIT_SPLIT_FUNCTIONALITY");
    }

    public void populateCreditSplits(ProposalDevelopmentDocumentForm form) {
        this.getKeyPersonnelService().populateCreditSplit(form.getProposalDevelopmentDocument());
        form.setCreditSplitListItems(this.getKeyPersonnelService().createCreditSplitListItems(form.getProposalDevelopmentDocument()));
    }

    public void populateQuestionnaires(ProposalDevelopmentDocumentForm form) {
        form.setQuestionnaireHelper(new ProposalDevelopmentQuestionnaireHelper(form));
        form.setS2sQuestionnaireHelper(new ProposalDevelopmentS2sQuestionnaireHelper(form));
        form.getQuestionnaireHelper().populateAnswers();
        form.getQuestionnaireHelper().updateChildIndicators();
        form.getS2sQuestionnaireHelper().populateAnswers();
        form.getS2sQuestionnaireHelper().updateChildIndicators();
    }

    public List<DataValidationItem> populateDataValidation(ProposalDevelopmentDocumentForm form) {
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-AttachmentsPage")) {
            this.populateAttachmentReferences(form.getDevelopmentProposal());
        }
        this.getGlobalVariableService().getAuditErrorMap().clear();
        this.getAuditHelper().auditConditionally(form);
        return this.populateDataValidation();
    }

    public void populateAttachmentReferences(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            this.getDataObjectService().wrap((Object)narrative).fetchRelationship("narrativeType");
            this.getDataObjectService().wrap((Object)narrative).fetchRelationship("narrativeStatus");
        }
        for (Narrative narrative : developmentProposal.getInstituteAttachments()) {
            this.getDataObjectService().wrap((Object)narrative).fetchRelationship("narrativeType");
            this.getDataObjectService().wrap((Object)narrative).fetchRelationship("narrativeStatus");
        }
        for (ProposalPersonBiography biography : developmentProposal.getPropPersonBios()) {
            this.getDataObjectService().wrap((Object)biography).fetchRelationship("propPerDocType");
        }
    }

    public AuditHelper getAuditHelper() {
        return this.auditHelper;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public ProposalDevelopmentPermissionsService getProposalDevelopmentPermissionsService() {
        return this.proposalDevelopmentPermissionsService;
    }

    public void setProposalDevelopmentPermissionsService(ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService) {
        this.proposalDevelopmentPermissionsService = proposalDevelopmentPermissionsService;
    }

    public void setOrdinalPosition(List<ProposalPerson> proposalPersons) {
        int index = 0;
        for (ProposalPerson proposalPerson : proposalPersons) {
            proposalPerson.setOrdinalPosition(index);
            ++index;
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public boolean isAttachmentFileEditable(ProposalDevelopmentAttachmentHelper helper, String collectionPath, String index) {
        return helper.getEditableFileLineAttachments().get(collectionPath) != null && helper.getEditableFileLineAttachments().get(collectionPath).contains(index);
    }

    public void toggleAttachmentFile(ProposalDevelopmentDocumentForm form, String collectionPath, String index) {
        ProposalDevelopmentAttachmentHelper helper = form.getProposalDevelopmentAttachmentHelper();
        if (!this.isAttachmentFileEditable(helper, collectionPath, index)) {
            helper.getEditableFileLineAttachments().computeIfAbsent(collectionPath, k -> new ArrayList());
            helper.getEditableFileLineAttachments().get(collectionPath).add(index);
        } else {
            helper.getEditableFileLineAttachments().get(collectionPath).remove(index);
        }
    }

    public String showFileAttachmentName(ProposalDevelopmentAttachmentHelper helper, String attachmentType) {
        if (this.hasAttachment(helper, attachmentType)) {
            if (StringUtils.equals((CharSequence)attachmentType, (CharSequence)"Proposal Attachment")) {
                return helper.getNarrative().getNarrativeAttachment().getName();
            }
            if (StringUtils.equals((CharSequence)attachmentType, (CharSequence)"Personnel Attachment")) {
                return helper.getBiography().getPersonnelAttachment().getName();
            }
            if (StringUtils.equals((CharSequence)attachmentType, (CharSequence)"Institutional Attachment")) {
                return helper.getInstituteAttachment().getNarrativeAttachment().getName();
            }
        }
        return "";
    }

    public boolean hasAttachment(ProposalDevelopmentAttachmentHelper helper, String attachmentType) {
        if (StringUtils.equals((CharSequence)attachmentType, (CharSequence)"Proposal Attachment")) {
            return helper.getNarrative().getNarrativeAttachment() != null;
        }
        if (StringUtils.equals((CharSequence)attachmentType, (CharSequence)"Personnel Attachment")) {
            return helper.getBiography().getPersonnelAttachment() != null;
        }
        if (StringUtils.equals((CharSequence)attachmentType, (CharSequence)"Institutional Attachment")) {
            return helper.getInstituteAttachment().getNarrativeAttachment() != null;
        }
        return false;
    }

    public boolean hasSpecialReviewAttachment(ProposalSpecialReview proposalSpecialReview) {
        return proposalSpecialReview.getSpecialReviewAttachment() != null && proposalSpecialReview.getSpecialReviewAttachment().getFileDataId() != null;
    }

    public String showFileAttachmentName(ProposalSpecialReview proposalSpecialReview) {
        return proposalSpecialReview.getSpecialReviewAttachment() != null ? proposalSpecialReview.getSpecialReviewAttachment().getName() : "";
    }

    public boolean isSpecialReviewAttachmentRequired(ProposalDevelopmentDocument document, ProposalSpecialReview specialReview) {
        return document.getDevelopmentProposal().hasS2sOpportunity() && "1".equals(specialReview.getSpecialReviewTypeCode());
    }

    public String displayFullName(String userName) {
        if (ObjectUtils.isNull((Object)userName)) {
            return "";
        }
        Person person = this.getPersonService().getPersonByPrincipalName(userName);
        return person != null ? person.getName() : "";
    }

    public String replaceLineBreaks(String string) {
        return StringUtils.replace((String)string, (String)"\n", (String)"[br]");
    }

    public boolean renderPersonnelEditForHierarchyProposal(String personId, Integer rolodexId, DevelopmentProposal proposal) {
        return !proposal.isInHierarchy() || this.renderEditForPersonnelAttachment(personId, rolodexId, proposal);
    }

    protected boolean renderEditForPersonnelAttachment(String personId, Integer rolodexId, DevelopmentProposal proposal) {
        boolean inMultiple;
        boolean bl = inMultiple = StringUtils.isNotBlank((CharSequence)personId) ? this.getProposalHierarchyService().employeePersonInMultipleProposals(personId, proposal) : this.getProposalHierarchyService().nonEmployeePersonInMultipleProposals(rolodexId, proposal);
        return proposal.isParent() ? inMultiple : !inMultiple;
    }

    public String getProposalStatusForDisplay(DevelopmentProposal proposal) {
        ProposalState state = proposal.getHierarchyAwareProposalStatus();
        return state != null ? state.getDescription() : "";
    }

    public boolean isProposalStatusInProgress(DevelopmentProposal proposal) {
        ProposalState state = proposal.getHierarchyAwareProposalStatus();
        return state != null && "1".equals(state.getCode());
    }

    public String getProjectStatusForPerson(ProposalPerson person) {
        DisclosureProjectStatus projectStatus = this.getCoiStatusForPerson(person);
        return projectStatus.getStatus() == null ? "" : projectStatus.getStatus();
    }

    public String getDisclosureStatusForPerson(ProposalPerson person) {
        DisclosureProjectStatus projectStatus = this.getCoiStatusForPerson(person);
        return projectStatus.getAnnualDisclosureStatus() == null ? "" : projectStatus.getAnnualDisclosureStatus();
    }

    public String getDispositionStatusForPerson(ProposalPerson person) {
        DisclosureProjectStatus projectStatus = this.getCoiStatusForPerson(person);
        return projectStatus.getDisposition() == null ? NOT_YET_DISPOSITIONED : projectStatus.getDisposition();
    }

    public DisclosureProjectStatus getCoiStatusForPerson(ProposalPerson person) {
        String id = person.getPersonId() == null ? person.getRolodexId().toString() : person.getPersonId();
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)ViewLifecycle.getModel();
        List<DisclosureProjectStatus> projectStatuses = form.getDisclosureProjectStatuses();
        return projectStatuses.stream().filter(projectStatus -> projectStatus.getUserId().equalsIgnoreCase(id)).findFirst().orElse(new DisclosureProjectStatus());
    }

    public boolean getNeedsCertification(ProposalPerson person) {
        return person.needsCertification();
    }

    public boolean getOptInCertificationStatus(ProposalPerson person) {
        return person.getOptInCertificationStatus();
    }

    public String getCertifiedBy(ProposalPerson person) {
        if (person.getCertificationDetails() == null) {
            this.refreshDetails(person);
        }
        return person.getCertificationDetails() == null ? "" : person.getCertificationDetails().getCertifiedBy();
    }

    public String getCertifiedPersonName(ProposalPerson person) {
        if (person.getCertificationDetails() == null) {
            this.refreshDetails(person);
        }
        return person.getCertificationDetails() == null ? "" : person.getCertificationDetails().getCertifiedPersonName();
    }

    public String getCertifiedTimeStamp(ProposalPerson person) {
        if (person.getCertificationDetails() == null) {
            this.refreshDetails(person);
        }
        return person.getCertificationDetails() == null ? "" : person.getCertificationDetails().getCertifiedTimeStamp();
    }

    public void refreshDetails(ProposalPerson person) {
        ProposalPersonCertificationDetails.ProposalPersonCertificationDetailsId id = new ProposalPersonCertificationDetails.ProposalPersonCertificationDetailsId();
        id.setProposalNumber(person.getProposalNumber());
        id.setProposalPersonNumber(person.getProposalPersonNumber());
        ProposalPersonCertificationDetails details = (ProposalPersonCertificationDetails)this.dataObjectService.find(ProposalPersonCertificationDetails.class, (Object)id);
        person.setCertificationDetails(details);
    }

    public String certifyModalMessage() {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)ViewLifecycle.getModel();
        ProposalPersonQuestionnaireHelper proposalPersonQuestionnaireHelper = form.getProposalPersonQuestionnaireHelper();
        proposalPersonQuestionnaireHelper.updateChildIndicators();
        boolean complete = this.isQuestionnaireComplete(proposalPersonQuestionnaireHelper);
        if (complete && this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            return INFO_PROPOSAL_CERTIFIED;
        }
        return WARN_PROPOSAL_CERTIFIED;
    }

    public boolean hasPersonnelLock(ProposalPerson person) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)ViewLifecycle.getModel();
        return this.proposalLockService.hasPersonnelLock(form.getDocument().getDocumentNumber(), person.getProposalPersonNumber());
    }

    public boolean isQuestionnaireComplete(ProposalPersonQuestionnaireHelper helper) {
        boolean retVal = true;
        if (helper != null && helper.getAnswerHeaders() != null) {
            for (AnswerHeader ah : helper.getAnswerHeaders()) {
                boolean complete = this.questionnaireAnswerService.isQuestionnaireAnswerComplete(ah.getAnswers());
                ah.setCompleted(complete);
                retVal &= complete;
            }
        }
        return retVal;
    }

    public boolean isCoiDisclosureStatusEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ENABLE_DISCLOSURE_STATUS_FROM_COI_MODULE");
    }

    public boolean isDisplayCoiProjectStatus() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "COI_PROJECT_STATUS_FEATURE");
    }

    public boolean isCoiDisclosureDispositionStatusEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ENABLE_DISCLOSURE_DISPOSITION_STATUS_FROM_COI_MODULE");
    }

    public boolean canViewDispositionStatus(ProposalPerson person) {
        return this.isCoiDisclosureDispositionStatusEnabled() && this.proposalDevelopmentDocumentViewAuthorizer.canViewDisclosureDisposition(this.getGlobalVariableService().getUserSession().getPerson().getPrincipalId(), person.getPersonId());
    }

    public void prepareSummaryPage(ProposalDevelopmentDocumentForm form, Boolean forcePopulateQuestionnaire) {
        this.populateCreditSplits(form);
        if (forcePopulateQuestionnaire.booleanValue()) {
            this.populateQuestionnaires(form);
        }
        this.getDataObjectService().wrap((Object)form.getDevelopmentProposal()).fetchRelationship(DEADLINE_TYPE_REF);
        ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(form.getDevelopmentProposal(), "999", AD_HOC_NOTIFICATION);
        form.getNotificationHelper().initializeDefaultValues(context);
        if (form.getDevelopmentProposal().isInHierarchy()) {
            form.setHierarchyDevelopmentProposals(this.getProposalHierarchyService().getHierarchyProposals(form.getDevelopmentProposal()));
        }
        if (form.getDevelopmentProposal().getFinalBudget() != null || form.getDevelopmentProposal().getLatestBudget() != null) {
            if (form.getDevelopmentProposal().getFinalBudget() != null) {
                form.setSelectedBudget(form.getDevelopmentProposal().getFinalBudget());
            } else {
                form.setSelectedBudget(form.getDevelopmentProposal().getLatestBudget());
            }
        }
    }

    public void populateCustomData(ProposalDevelopmentDocumentForm form) {
        for (CustomAttributeDocValue customAttributeDocValue : form.getProposalDevelopmentDocument().getCustomDataList()) {
            boolean groupNamePresent = false;
            for (ProposalDevelopmentCustomDataGroupDto customDataGroupDto : form.getCustomDataGroups()) {
                if (!customDataGroupDto.getDescription().equals(customAttributeDocValue.getCustomAttribute().getGroupName())) continue;
                groupNamePresent = true;
                break;
            }
            if (groupNamePresent) continue;
            ProposalDevelopmentCustomDataGroupDto customDataGroupDto = new ProposalDevelopmentCustomDataGroupDto();
            customDataGroupDto.setDescription(customAttributeDocValue.getCustomAttribute().getGroupName());
            customDataGroupDto.setIdSuffix(customAttributeDocValue.getCustomAttribute().getGroupName().replace(" ", "_"));
            form.getCustomDataGroups().add(customDataGroupDto);
        }
    }

    public void updateAttachmentInformation(KcAttachmentDataSource attachment) {
        if (attachment != null) {
            attachment.setUploadUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
            attachment.setUploadTimestamp(this.getDateTimeService().getCurrentTimestamp());
        }
    }

    public boolean isPersonFieldEditable(String propertyName) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)ViewLifecycle.getModel();
        Boolean returnValue = form.getPersonEditableFields().get(propertyName);
        return returnValue != null && returnValue != false;
    }

    @Override
    public boolean requiresResubmissionPrompt(DevelopmentProposal developmentProposal, String resubmissionOption) {
        if (this.isResubmissionPromptDialogEnabled()) {
            return this.getProposalDevelopmentService().isProposalReniewedOrChangeCorrected(developmentProposal) && resubmissionOption == null;
        }
        return false;
    }

    @Override
    public boolean isResubmissionPromptDialogEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "enableIPGenerationPromptDialog");
    }

    public boolean renderQuestionnaire(ProposalPerson proposalPerson) {
        return proposalPerson.needsCertification();
    }

    public ProposalDevelopmentService getProposalDevelopmentService() {
        return this.proposalDevelopmentService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    public boolean isSummaryQuestionsPanelEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "enableSummaryQuestionsPanel");
    }

    public boolean isSummaryAttachmentsPanelEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "enableSummaryAttachmentsPanel");
    }

    public boolean isSummaryKeywordsPanelEnabled() {
        return this.displayKeywords() && this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "enableSummaryKeywordsPanel") != false;
    }

    public boolean isSummaryBudgetPanelEnabled(DevelopmentProposal developmentProposal) {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "enableBudgetSummaryPanel") != false && (developmentProposal.getLatestBudget() != null || developmentProposal.getFinalBudget() != null);
    }

    public boolean isS2sRevisionOther(S2sOpportunity s2sOpportunity) {
        if (s2sOpportunity != null) {
            return StringUtils.equals((CharSequence)s2sOpportunity.getRevisionCode(), (CharSequence)"E");
        }
        return false;
    }

    public CustomAttributeService getCustomAttributeService() {
        return this.customAttributeService;
    }

    public void setCustomAttributeService(CustomAttributeService customAttributeService) {
        this.customAttributeService = customAttributeService;
    }

    public boolean isRequired(CustomAttribute attr, List<? extends DocumentCustomData> customDataList) {
        return this.getCustomAttributeService().isRequired(PARENT_PROPOSAL_TYPE_CODE, attr, customDataList);
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public boolean displayDirectIndierctCosts() {
        return StringUtils.equals((CharSequence)this.getParameterService().getParameter("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST").getValue(), (CharSequence)"1");
    }

    public String getWorkloadApproverMessageText(DevelopmentProposal developmentProposal) {
        Person approver;
        Person assigner = developmentProposal.getAssignerId() == null ? null : this.personService.getPerson(developmentProposal.getAssignerId());
        Person person = approver = developmentProposal.getApproverId() == null ? null : this.personService.getPerson(developmentProposal.getApproverId());
        if (approver == null || assigner == null) {
            return "";
        }
        String approverEmail = Objects.nonNull(approver.getEmailAddress()) ? " (" + approver.getEmailAddress() + ") " : " ";
        return "Assigned approver " + approver.getName() + approverEmail + "added by " + assigner.getName();
    }

    public Boolean workloadApproverAssigned(DevelopmentProposal developmentProposal) {
        return developmentProposal.getAssignerId() != null && developmentProposal.getApproverId() != null;
    }

    public String getDisclaimerText() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "propSummaryDisclaimerText");
    }

    public boolean canViewCertificationTab(ProposalDevelopmentDocument document, ProposalPerson proposalPerson) {
        String currentUser = this.getGlobalVariableService().getUserSession().getPrincipalName();
        Person person = this.getPersonService().getPersonByPrincipalName(currentUser);
        return this.getProposalDevelopmentPermissionsService().hasCertificationPermissions(document, person, proposalPerson) || this.getKraAuthorizationService().hasPermission(person.getPrincipalId(), document, "View Certification");
    }

    public boolean canSaveCertification(ProposalDevelopmentDocument document, ProposalPerson proposalPerson) {
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary((Document)document);
        ProposalDevelopmentDocumentAuthorizer proposalDevelopmentDocumentAuthorizer = (ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer();
        Person currentUser = this.getGlobalVariableService().getUserSession().getPerson();
        return proposalDevelopmentDocumentAuthorizer.canSaveCertificationForPerson(document, currentUser, proposalPerson);
    }

    public boolean isCertificationReadOnly(ProposalPerson proposalPerson) {
        ProposalDevelopmentDocument document = proposalPerson.getDevelopmentProposal().getProposalDocument();
        return !this.canSaveCertification(document, proposalPerson) || this.hasProposalPersonApproved(document, proposalPerson);
    }

    public boolean hasProposalPersonApproved(ProposalDevelopmentDocument document, ProposalPerson proposalPerson) {
        if (this.isKeyPersonCertIsEnabled()) {
            ProposalDevelopmentDocumentAuthorizer proposalDevelopmentDocumentAuthorizer = (ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer();
            return proposalDevelopmentDocumentAuthorizer.hasProposalPersonApproved(document, proposalPerson);
        }
        return Boolean.FALSE;
    }

    public boolean isKeyPersonCertIsEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", "RESKC_1977_Make_Cert_Read_Only_After_Approval");
    }

    public String getWizardMaxResults() {
        return this.getParameterService().getParameterValueAsString("KR-KRAD", "Lookup", "RESULTS_LIMIT");
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public boolean isShowModularBudgetQuestion(String sponsorCode) {
        return this.getSponsorHierarchyService().isSponsorNihMultiplePi(sponsorCode);
    }

    public boolean syncRequiresEndDateExtension(DevelopmentProposal proposal) {
        DevelopmentProposal hierarchyProposal = this.getProposalHierarchyService().getDevelopmentProposal(proposal.getHierarchyParentProposalNumber());
        return this.getProposalHierarchyService().needToExtendProjectDate(hierarchyProposal, proposal);
    }

    public boolean syncAllRequiresEndDateExtension(DevelopmentProposal hierarchyProposal) {
        return this.getProposalHierarchyService().needToExtendProjectDate(hierarchyProposal);
    }

    public boolean isReactMedusaEnabled() {
        return this.medusaService.isReactMedusaEnabled();
    }

    public SponsorSearchService getSponsorSearchService() {
        return this.sponsorSearchService;
    }

    public void setSponsorSearchService(SponsorSearchService sponsorSearchService) {
        this.sponsorSearchService = sponsorSearchService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public String getDefaultOpenTab() {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)ViewLifecycle.getModel();
        String openTab = form.getDefaultOpenTab();
        form.setDefaultOpenTab("");
        return openTab;
    }

    public String getPropPersonName(String personId, Integer rolodexId) {
        if (StringUtils.isNotEmpty((CharSequence)personId)) {
            Person person = this.getPersonService().getPerson(personId);
            return person != null ? this.toFullName(person.getFirstName(), person.getMiddleName(), person.getLastName()) : "";
        }
        if (rolodexId != null) {
            RolodexContract rolodex = this.getRolodexService().getRolodex(rolodexId);
            return rolodex != null ? this.toFullName(rolodex.getFirstName(), rolodex.getMiddleName(), rolodex.getLastName()) : "";
        }
        return "";
    }

    protected String toFullName(String first, String middle, String last) {
        Object middleName = middle != null ? middle + " " : "";
        return (first + " " + (String)middleName + last).trim();
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public boolean isFederalSponsor(DevelopmentProposal developmentProposal) {
        return this.getProposalDevelopmentService().isGrantsGovEnabledForProposal(developmentProposal);
    }

    public void clearOpportunity(DevelopmentProposal proposal) {
        if (proposal.isMultiProjectParent()) {
            this.proposalHierarchyService.getHierarchyChildren(proposal.getProposalNumber()).stream().forEach(child -> this.clearOpportunity((DevelopmentProposal)child));
        }
        this.getLegacyDataAdapter().delete((Object)proposal.getS2sOpportunity());
        proposal.setS2sOpportunity(null);
        proposal.setProgramAnnouncementTitle("");
        proposal.setProgramAnnouncementNumber("");
        proposal.setProposalCfdas(new ArrayList<ProposalCfda>());
        proposal.setOpportunityIdForGG("");
    }

    public boolean personHasErrors(int personIndex) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)ViewLifecycle.getModel();
        boolean personHasErrors = this.getGlobalVariableService().getAuditErrorMap().values().stream().flatMap(auditCluster -> auditCluster.getAuditErrorList().stream()).anyMatch(auditError -> ((AuditError)auditError).getErrorKey().startsWith("document.developmentProposal.proposalPersons[" + personIndex + "]"));
        return form.isAuditActivated() && personHasErrors;
    }

    @Override
    protected Class<?> getParameterClass() {
        return ProposalDevelopmentDocument.class;
    }

    public String getMaxUploadSizeParameter() {
        return String.valueOf(this.getKcFileService().getMaxUploadSizeParameter());
    }

    public KcFileService getKcFileService() {
        return this.kcFileService;
    }

    public void setKcFileService(KcFileService kcFileService) {
        this.kcFileService = kcFileService;
    }

    public MultipartFileValidationService getMultipartFileValidationService() {
        return this.multipartFileValidationService;
    }

    public void setMultipartFileValidationService(MultipartFileValidationService multipartFileValidationService) {
        this.multipartFileValidationService = multipartFileValidationService;
    }

    public KcAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public ProposalDevelopmentDocumentViewAuthorizer getProposalDevelopmentDocumentViewAuthorizer() {
        return this.proposalDevelopmentDocumentViewAuthorizer;
    }

    public void setProposalDevelopmentDocumentViewAuthorizer(ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer) {
        this.proposalDevelopmentDocumentViewAuthorizer = proposalDevelopmentDocumentViewAuthorizer;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public static class SponsorSuggestResult {
        private SponsorSearchResult sponsor;

        public SponsorSuggestResult(SponsorSearchResult sponsor) {
            this.sponsor = sponsor;
        }

        public String getValue() {
            return this.sponsor.getSponsorCode();
        }

        public String getLabel() {
            return "<b>" + this.sponsor.getSponsorCode() + "</b><br/><i>" + this.sponsor.getSponsorName() + "</i>";
        }

        public String getSponsorName() {
            return this.sponsor.getSponsorName();
        }
    }
}

