/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardInvoiceMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private DictionaryValidationService dictionaryValidationService = KcServiceLocator.getService(DictionaryValidationService.class);
    private ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
    private SubAwardService subAwardService = KcServiceLocator.getService(SubAwardService.class);

    protected boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean valid = super.isDocumentValidForSave(document);
        SubAwardAmountReleased invoice = (SubAwardAmountReleased)document.getNoteTarget();
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
        valid &= this.dictionaryValidationService.isBusinessObjectValid((Object)invoice);
        if (invoice.getStartDate() != null && invoice.getEndDate() != null && invoice.getEndDate().before(invoice.getStartDate())) {
            valid = false;
            this.errorReporter.reportError("startDate", "subaward.error.end.date.greater.than.start", new String[0]);
        }
        if (invoice.getAmountReleased() != null) {
            SubAward subAward;
            if (invoice.getAmountReleased().isZero()) {
                valid = false;
                this.errorReporter.reportError("amountReleased", "subaward.error.amount.released.zero", new String[0]);
            }
            if ((subAward = invoice.getSubAward()).getSubAwardAmountReleasedList().contains(invoice)) {
                subAward.getSubAwardAmountReleasedList().remove(invoice);
            }
            subAward.getSubAwardAmountReleasedList().add(invoice);
            this.subAwardService.calculateAmountInfo(subAward);
            if (invoice.getSubAward().getTotalAvailableAmount().isNegative()) {
                valid = false;
                this.errorReporter.reportError("amountReleased", "subaward.error.amount.released.greater.than.obligated.amount", new String[0]);
            }
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return valid;
    }

    protected boolean primaryKeyCheck(MaintenanceDocument document) {
        return true;
    }
}

