/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.Expression;

public final class BinaryOperatorExpression
implements Expression<Boolean> {
    private final ComparisonOperator operator;
    private final Expression<? extends Object> lhs;
    private final Expression<? extends Object> rhs;

    public BinaryOperatorExpression(ComparisonOperator operator, Expression<? extends Object> lhs, Expression<? extends Object> rhs) {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Boolean invoke(ExecutionEnvironment environment) {
        Object lhsValue = this.lhs.invoke(environment);
        Object rhsValue = this.rhs.invoke(environment);
        return this.operator.compare(lhsValue, rhsValue);
    }
}

