/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationResponseBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.dao.NotificationDao;
import org.kuali.rice.ken.deliverer.impl.KEWActionListMessageDeliverer;
import org.kuali.rice.ken.service.NotificationAuthorizationService;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class NotificationServiceImpl
implements NotificationService {
    private static Logger LOG = LogManager.getLogger(NotificationServiceImpl.class);
    private DataObjectService dataObjectService;
    private NotificationDao notDao;
    private NotificationMessageContentService messageContentService;
    private NotificationAuthorizationService notificationAuthorizationService;
    private NotificationRecipientService notificationRecipientService;
    private NotificationMessageDeliveryService notificationMessageDeliveryService;

    public NotificationServiceImpl(DataObjectService dataObjectService, NotificationMessageContentService messageContentService, NotificationAuthorizationService notificationAuthorizationService, NotificationRecipientService notificationRecipientService, NotificationMessageDeliveryService notificationMessageDeliveryService, NotificationDao notDao) {
        this.dataObjectService = dataObjectService;
        this.messageContentService = messageContentService;
        this.notificationAuthorizationService = notificationAuthorizationService;
        this.notificationRecipientService = notificationRecipientService;
        this.notificationMessageDeliveryService = notificationMessageDeliveryService;
        this.notDao = notDao;
    }

    @Override
    public NotificationBo getNotification(Long id) {
        return (NotificationBo)this.dataObjectService.find(NotificationBo.class, (Object)id);
    }

    @Override
    public NotificationResponseBo sendNotification(String notificationMessageAsXml) throws IOException, XmlException {
        NotificationBo notification = this.messageContentService.parseNotificationRequestMessage(notificationMessageAsXml);
        return this.sendNotification(notification);
    }

    @Override
    public NotificationResponseBo sendNotification(NotificationBo notification) {
        NotificationResponseBo response = new NotificationResponseBo();
        boolean producerAuthorizedForChannel = this.notificationAuthorizationService.isProducerAuthorizedToSendNotificationForChannel(notification.getProducer(), notification.getChannel());
        if (!producerAuthorizedForChannel) {
            LOG.error("Producer " + notification.getProducer() + " is not authorized to send messages to channel " + notification.getChannel());
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because the Producer specified cannot send notifications for the Notification Channel specified.");
            return response;
        }
        for (int i = 0; i < notification.getRecipients().size(); ++i) {
            boolean validRecipient;
            NotificationRecipientBo recipient = notification.getRecipient(i);
            if (recipient.getNotification() == null) {
                recipient.setNotification(notification);
            }
            if (validRecipient = this.notificationRecipientService.isRecipientValid(recipient.getRecipientId(), recipient.getRecipientType())) continue;
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because one of the recipients that was specified was invalid and is not registered in the system. - recipientId=" + recipient.getRecipientId() + ", recipientType=" + recipient.getRecipientType());
            return response;
        }
        for (NotificationSenderBo sender : notification.getSenders()) {
            sender.setNotification(notification);
        }
        if (notification.getCreationDateTime() == null) {
            notification.setCreationDateTimeValue(new Timestamp(System.currentTimeMillis()));
        }
        if (notification.getSendDateTime() == null) {
            notification.setSendDateTimeValue(new Timestamp(System.currentTimeMillis()));
        }
        if (notification.getAutoRemoveDateTime() != null && notification.getAutoRemoveDateTimeValue().before(notification.getSendDateTimeValue())) {
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because the specified auto-remove date is before the send date.");
            return response;
        }
        if (!notification.getDeliveryType().equalsIgnoreCase("ACK") && !notification.getDeliveryType().equalsIgnoreCase("FYI")) {
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because the specified delivery type was invalid. - deliveryType=" + notification.getDeliveryType());
            return response;
        }
        try {
            notification = (NotificationBo)this.dataObjectService.save((Object)notification, new PersistenceOption[0]);
        }
        catch (Exception e) {
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because there was a problem when trying to save the notification to the database.");
            return response;
        }
        response.setMessage("The notification message has been successfully received by the system and will be processed and delivered.");
        response.setNotificationId(notification.getId());
        return response;
    }

    public Collection getNotificationsForRecipientByType(String contentTypeName, String recipientId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"contentType.name", (Object)contentTypeName), PredicateFactory.equal((String)"recipients.recipientId", (Object)recipientId)});
        return Collections.unmodifiableCollection(this.dataObjectService.findMatching(NotificationBo.class, criteria.build()).getResults());
    }

    @Override
    public void dismissNotificationMessageDelivery(Long id, String user, String cause) {
        NotificationMessageDelivery nmd = this.notificationMessageDeliveryService.getNotificationMessageDelivery(id);
        this.dismissNotificationMessageDelivery(nmd, user, cause);
    }

    public void dismissNotificationMessageDelivery(NotificationMessageDelivery nmd, String user, String cause) {
        NotificationBo notification = nmd.getNotification();
        Collection<NotificationMessageDelivery> userDeliveries = this.notificationMessageDeliveryService.getNotificationMessageDeliveries(notification, nmd.getUserRecipientId());
        String targetStatus = "autoremove".equals(cause) ? "AUTO_REMOVED" : "REMOVED";
        KEWActionListMessageDeliverer deliverer = new KEWActionListMessageDeliverer();
        for (NotificationMessageDelivery messageDelivery : userDeliveries) {
            if (!"DELIVERED".equals(messageDelivery.getMessageDeliveryStatus())) {
                LOG.info("Skipping dismissal of non-delivered message delivery #" + messageDelivery.getId());
            } else if (targetStatus.equals(messageDelivery.getMessageDeliveryStatus())) {
                LOG.info("Skipping dismissal of already removed message delivery #" + messageDelivery.getId());
            } else {
                LOG.debug("Dismissing message delivery #" + messageDelivery.getId() + " " + messageDelivery.getVersionNumber());
                deliverer.dismissMessageDelivery(messageDelivery, user, cause);
            }
            messageDelivery.setMessageDeliveryStatus(targetStatus);
            LOG.debug("Saving message delivery #" + messageDelivery.getId() + " " + messageDelivery.getVersionNumber());
            messageDelivery = (NotificationMessageDelivery)this.dataObjectService.save((Object)messageDelivery, new PersistenceOption[0]);
            LOG.debug("Message delivery '" + messageDelivery.getId() + "' for notification '" + messageDelivery.getNotification().getId() + "' was successfully dismissed.");
        }
    }

    @Override
    public Collection<NotificationBo> takeNotificationsForResolution() {
        Collection available_notifications = this.notDao.findMatchedNotificationsForResolution(new Timestamp(System.currentTimeMillis()), this.dataObjectService);
        ArrayList<NotificationBo> savedNotifications = new ArrayList<NotificationBo>();
        if (available_notifications != null) {
            for (NotificationBo notification : available_notifications) {
                LOG.info("notification: " + notification);
                notification.setLockedDateValue(new Timestamp(System.currentTimeMillis()));
                savedNotifications.add((NotificationBo)this.dataObjectService.save((Object)notification, new PersistenceOption[0]));
            }
        }
        return savedNotifications;
    }

    @Override
    public void unlockNotification(NotificationBo notification) {
        Collection notifications = this.notDao.findMatchedNotificationsForUnlock(notification, this.dataObjectService);
        if (notifications == null || notifications.size() == 0) {
            throw new RuntimeException("Notification #" + notification.getId() + " not found to unlock");
        }
        NotificationBo n = (NotificationBo)notifications.iterator().next();
        n.setLockedDateValue(null);
        this.dataObjectService.save((Object)n, new PersistenceOption[0]);
    }
}

