/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class DocumentNamespaceContext
implements NamespaceContext {
    private static final Logger LOG = LogManager.getLogger(DocumentNamespaceContext.class);
    private final Document doc;

    public DocumentNamespaceContext(Document doc) {
        this.doc = doc;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        LOG.debug("getNamespaceURI(" + prefix + ")");
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix cannot be null.");
        }
        if (prefix.length() == 0) {
            return this.doc.lookupNamespaceURI(null);
        }
        return this.doc.lookupNamespaceURI(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        LOG.debug("getPrefix(" + namespaceURI + ")");
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        return this.doc.lookupPrefix(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        LOG.debug("getPrefixes(" + namespaceURI + ")");
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        ArrayList<String> list = new ArrayList<String>(1);
        String s = this.getPrefix(namespaceURI);
        if (s != null) {
            list.add(s);
        }
        return list.iterator();
    }
}

