/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actiontaken.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.dao.ActionTakenDao;
import org.kuali.rice.kew.actiontaken.service.ActionTakenService;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class ActionTakenServiceImpl
implements ActionTakenService {
    private static final Logger LOG = LogManager.getLogger(ActionTakenServiceImpl.class);
    private static final String DOCUMENT_ID = "documentId";
    private static final String PRINCIPAL_ID = "principalId";
    private static final String CURRENT_INDICATOR = "currentIndicator";
    private static final String ACTION_DATE = "actionDate";
    private DataObjectService dataObjectService;
    private ActionTakenDao actionTakenDao;

    @Override
    public ActionTakenValue findByActionTakenId(String actionTakenId) {
        return (ActionTakenValue)this.getDataObjectService().find(ActionTakenValue.class, (Object)actionTakenId);
    }

    @Override
    public ActionTakenValue getPreviousAction(ActionRequestValue actionRequest) {
        return this.getPreviousAction(actionRequest, null);
    }

    @Override
    public ActionTakenValue getPreviousAction(ActionRequestValue actionRequest, List<ActionTakenValue> simulatedActionsTaken) {
        GroupService ims = KimApiServiceLocator.getGroupService();
        ActionTakenValue foundActionTaken = null;
        ArrayList<String> principalIds = new ArrayList<String>();
        if (actionRequest.isGroupRequest()) {
            principalIds.addAll(ims.getMemberPrincipalIds(actionRequest.getGroup().getId()));
        } else if (actionRequest.isUserRequest()) {
            principalIds.add(actionRequest.getPrincipalId());
        }
        for (String id : principalIds) {
            ArrayList<ActionTakenValue> actionsTakenByUser = new ArrayList<ActionTakenValue>(this.findByDocumentIdPrincipalId(actionRequest.getDocumentId(), id));
            if (simulatedActionsTaken != null) {
                for (ActionTakenValue simulatedAction : simulatedActionsTaken) {
                    if (!id.equals(simulatedAction.getPrincipalId())) continue;
                    actionsTakenByUser.add(simulatedAction);
                }
            }
            for (ActionTakenValue actionTaken : actionsTakenByUser) {
                if (ActionRequestValue.compareActionCode(actionTaken.getActionTaken(), actionRequest.getActionRequested(), true) < 0) continue;
                foundActionTaken = actionTaken;
            }
        }
        return foundActionTaken;
    }

    @Override
    public Collection<ActionTakenValue> findByDocumentId(String documentId) {
        LOG.debug("finding Action Takens by documentId " + documentId);
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE)});
        criteria.setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)ACTION_DATE, (OrderDirection)OrderDirection.ASCENDING).build()});
        return this.getDataObjectService().findMatching(ActionTakenValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionTakenValue> findByDocumentIdPrincipalId(String documentId, String principalId) {
        LOG.debug("finding Action Takens by documentId " + documentId + " and principalId" + principalId);
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)PRINCIPAL_ID, (Object)principalId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE)});
        return this.getDataObjectService().findMatching(ActionTakenValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionTakenValue> findByDocumentIdIgnoreCurrentInd(String documentId) {
        LOG.debug("finding ActionsTaken ignoring currentInd by documentId:" + documentId);
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId)});
        criteria.setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)ACTION_DATE, (OrderDirection)OrderDirection.ASCENDING).build()});
        return this.getDataObjectService().findMatching(ActionTakenValue.class, criteria.build()).getResults();
    }

    @Override
    public ActionTakenValue saveActionTaken(ActionTakenValue actionTaken) {
        LOG.debug("saving ActionTaken");
        this.checkNull(actionTaken.getDocumentId(), "Document ID");
        this.checkNull(actionTaken.getActionTaken(), "action taken code");
        this.checkNull(actionTaken.getDocVersion(), "doc version");
        this.checkNull(actionTaken.getPrincipal(), "user principalId");
        if (actionTaken.getActionDate() == null) {
            actionTaken.setActionDate(new Timestamp(System.currentTimeMillis()));
        }
        if (actionTaken.getCurrentIndicator() == null) {
            actionTaken.setCurrentIndicator(Boolean.TRUE);
        }
        LOG.debug("saving ActionTaken: routeHeader " + actionTaken.getDocumentId() + ", actionTaken " + actionTaken.getActionTaken() + ", principalId " + actionTaken.getPrincipalId());
        return (ActionTakenValue)this.getDataObjectService().save((Object)actionTaken, new PersistenceOption[0]);
    }

    @Override
    public void delete(ActionTakenValue actionTaken) {
        LOG.debug("deleting ActionTaken " + actionTaken.getActionTakenId());
        this.getDataObjectService().delete((Object)actionTaken);
    }

    @Override
    public boolean hasUserTakenAction(String principalId, String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)PRINCIPAL_ID, (Object)principalId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE)});
        criteria.setCountFlag(CountFlag.ONLY);
        return this.getDataObjectService().findMatching(ActionTakenValue.class, criteria.build()).getTotalRowCount() > 0;
    }

    @Override
    public Timestamp getLastApprovedDate(String documentId) {
        return this.getActionTakenDao().getLastActionTakenDate(documentId, ActionType.APPROVE);
    }

    private void checkNull(Object value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new IllegalArgumentException("Null value for " + valueName);
        }
    }

    public ActionTakenDao getActionTakenDao() {
        return this.actionTakenDao;
    }

    public void setActionTakenDao(ActionTakenDao actionTakenDao) {
        this.actionTakenDao = actionTakenDao;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

